/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.ClausesBasedStatement;
import org.neo4j.cypherdsl.core.DecoratedQuery;
import org.neo4j.cypherdsl.core.DefaultStatementBuilder;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.UnionQueryImpl;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.internal.LoadCSV;
import org.neo4j.cypherdsl.core.internal.ProcedureName;
import org.neo4j.cypherdsl.core.internal.UsingPeriodicCommit;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public interface Statement
extends Visitable {
    @NotNull
    @Contract(pure=true)
    public static StatementBuilder builder() {
        return new DefaultStatementBuilder(new Visitable[0]);
    }

    @NotNull
    public static Statement of(@NotNull List<Clause> clauses) {
        Assertions.notNull(clauses, "Clauses must not be null.");
        return new ClausesBasedStatement(clauses, null);
    }

    @API(status=API.Status.STABLE, since="2021.3.0")
    @NotNull
    public static Statement usingPeriodic(Integer batchSize, @NotNull List<Clause> clauses) {
        Assertions.notNull(clauses, "Clauses must not be null.");
        Assertions.isTrue(!clauses.isEmpty(), "Clauses must not be empty.");
        Assertions.isInstanceOf(LoadCSV.class, clauses.get(0), "First clause must be a LOAD CSV clause.");
        return new ClausesBasedStatement(clauses, new UsingPeriodicCommit(batchSize));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(String ... namespaceAndProcedure) {
        return new DefaultStatementBuilder.StandaloneCallBuilder(ProcedureName.from(namespaceAndProcedure));
    }

    @NotNull
    @Contract(pure=true)
    public Map<String, Object> getParameters();

    @NotNull
    @Contract(pure=true)
    public Collection<String> getParameterNames();

    @NotNull
    @Contract(pure=true)
    public Collection<Expression> getIdentifiableExpressions();

    @NotNull
    @Contract(pure=true)
    public String getCypher();

    @API(status=API.Status.INTERNAL, since="2021.0.0")
    @NotNull
    @Contract(pure=true)
    public StatementContext getContext();

    @Contract(pure=true)
    public boolean isRenderConstantsAsParameters();

    public void setRenderConstantsAsParameters(boolean var1);

    default public boolean doesReturnOrYield() {
        return this instanceof ResultStatement || this instanceof UnionQueryImpl;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UseStatement
    extends Statement {
        @NotNull
        @Contract(pure=true)
        default public Statement explain() {
            return DecoratedQuery.explain(this);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UnionQuery
    extends RegularQuery {
    }

    public static interface SingleQuery
    extends RegularQuery {
    }

    public static interface RegularQuery
    extends Statement {
    }
}

