/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.lang.reflect.Array;
import java.net.URI;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.BooleanLiteral;
import org.neo4j.cypherdsl.core.BuiltInFunctions;
import org.neo4j.cypherdsl.core.Case;
import org.neo4j.cypherdsl.core.ClausesBasedStatement;
import org.neo4j.cypherdsl.core.DecoratedQuery;
import org.neo4j.cypherdsl.core.ExposesLoadCSV;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.ForeignAdapter;
import org.neo4j.cypherdsl.core.ForeignAdapterFactory;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.InternalNodeImpl;
import org.neo4j.cypherdsl.core.InternalPropertyImpl;
import org.neo4j.cypherdsl.core.LabelExpression;
import org.neo4j.cypherdsl.core.ListComprehension;
import org.neo4j.cypherdsl.core.ListExpression;
import org.neo4j.cypherdsl.core.ListLiteral;
import org.neo4j.cypherdsl.core.ListOperator;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.LoadCSVStatementBuilder;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NullLiteral;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RawLiteral;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.StringLiteral;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.TemporalLiteral;
import org.neo4j.cypherdsl.core.UnionQueryImpl;
import org.neo4j.cypherdsl.core.UseClauseImpl;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class Cypher {
    static final ResourceBundle MESSAGES = ResourceBundle.getBundle("org.neo4j.cypherdsl.core.messages");
    private static volatile ForeignAdapterFactory foreignAdapterFactory;

    @NotNull
    @Contract(pure=true)
    public static Node node(String primaryLabel, String ... additionalLabels) {
        return new InternalNodeImpl(primaryLabel, additionalLabels);
    }

    @NotNull
    @Contract(pure=true)
    public static Node node(String primaryLabel, List<String> additionalLabels) {
        return new InternalNodeImpl(primaryLabel, additionalLabels.toArray(new String[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Node node(String primaryLabel, MapExpression properties, String ... additionalLabels) {
        return new InternalNodeImpl(null, primaryLabel, properties, additionalLabels);
    }

    @NotNull
    @Contract(pure=true)
    public static Node node(String primaryLabel, MapExpression properties, Collection<String> additionalLabels) {
        return Cypher.node(primaryLabel, properties, additionalLabels.toArray(new String[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Node anyNode() {
        return new InternalNodeImpl();
    }

    @NotNull
    @Contract(pure=true)
    public static Node node(LabelExpression labelExpression) {
        return new InternalNodeImpl(Objects.requireNonNull(labelExpression));
    }

    @NotNull
    @Contract(pure=true)
    public static Asterisk asterisk() {
        return Asterisk.INSTANCE;
    }

    @NotNull
    @Contract(pure=true)
    public static Node anyNode(String symbolicName) {
        return new InternalNodeImpl().named(symbolicName);
    }

    @NotNull
    @Contract(pure=true)
    public static Node anyNode(SymbolicName symbolicName) {
        return new InternalNodeImpl().named(symbolicName);
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(String containerName, String ... names) {
        return Cypher.property((Expression)Cypher.name(containerName), names);
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(String containerName, Collection<String> names) {
        return Cypher.property((Expression)Cypher.name(containerName), names.toArray(new String[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(Expression expression, String ... names) {
        return InternalPropertyImpl.create(expression, names);
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(Expression expression, Collection<String> names) {
        return Cypher.property(expression, names.toArray(new String[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(String containerName, Expression lookup) {
        return Cypher.property((Expression)Cypher.name(containerName), lookup);
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(Expression expression, Expression lookup) {
        return InternalPropertyImpl.create(expression, lookup);
    }

    @NotNull
    @Contract(pure=true)
    public static NamedPath.OngoingDefinitionWithName path(String name) {
        return NamedPath.named(name);
    }

    @NotNull
    @Contract(pure=true)
    public static NamedPath.OngoingDefinitionWithName path(SymbolicName name) {
        return NamedPath.named(name);
    }

    @NotNull
    @Contract(pure=true)
    public static NamedPath.OngoingShortestPathDefinitionWithName shortestPath(String name) {
        return NamedPath.named(name, (FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SHORTEST_PATH);
    }

    @NotNull
    @Contract(pure=true)
    public static NamedPath.OngoingShortestPathDefinitionWithName shortestPath(SymbolicName name) {
        return NamedPath.named(name, (FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SHORTEST_PATH);
    }

    @NotNull
    @Contract(pure=true)
    public static SymbolicName name(String value) {
        return SymbolicName.of(value);
    }

    @NotNull
    @Contract(pure=true)
    public static Parameter<Object> parameter(String name) {
        return Parameter.create(name);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Parameter<T> parameter(String name, T value) {
        return Parameter.create(name, value);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Parameter<T> anonParameter(T value) {
        return Parameter.anon(value);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere optionalMatch(PatternElement ... pattern) {
        return Statement.builder().optionalMatch(pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere optionalMatch(Collection<PatternElement> pattern) {
        return Cypher.optionalMatch(pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere match(PatternElement ... pattern) {
        return Statement.builder().match(pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere match(Collection<PatternElement> pattern) {
        return Cypher.match(pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
        return Statement.builder().match(optional, pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, Collection<PatternElement> pattern) {
        return Cypher.match(optional, pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
        return Statement.builder().create(pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUpdate create(Collection<PatternElement> pattern) {
        return Cypher.create(pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(String ... variables) {
        return Statement.builder().with(variables);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(IdentifiableElement ... elements) {
        return Statement.builder().with(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<IdentifiableElement> elements) {
        return Statement.builder().with(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
        return Statement.builder().merge(pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingMerge merge(Collection<PatternElement> pattern) {
        return Cypher.merge(pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUnwind unwind(Expression expression) {
        return Statement.builder().unwind(expression);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUnwind unwind(Expression ... expressions) {
        return Statement.builder().unwind((Expression)Cypher.listOf(expressions));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUnwind unwind(Collection<Expression> expressions) {
        return Cypher.unwind(expressions.toArray(new Expression[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static SortItem sort(Expression expression) {
        return SortItem.create(expression, null);
    }

    @NotNull
    @Contract(pure=true)
    public static SortItem sort(Expression expression, SortItem.Direction direction) {
        return SortItem.create(expression, direction);
    }

    @NotNull
    @Contract(pure=true)
    public static MapExpression mapOf(Object ... keysAndValues) {
        return MapExpression.create(keysAndValues);
    }

    @NotNull
    @Contract(pure=true)
    public static MapExpression asExpression(Map<String, Object> map) {
        return MapExpression.create(map);
    }

    @NotNull
    @Contract(pure=true)
    public static ListExpression listOf(Expression ... expressions) {
        return ListExpression.create(expressions);
    }

    @NotNull
    @Contract(pure=true)
    public static ListExpression listOf(Collection<Expression> expressions) {
        return Cypher.listOf(expressions.toArray(new Expression[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Literal<T> literalOf(Object object) {
        if (object == null) {
            return NullLiteral.INSTANCE;
        }
        if (object instanceof Literal) {
            return (Literal)object;
        }
        if (object instanceof CharSequence) {
            return new StringLiteral((CharSequence)object);
        }
        if (object instanceof Character) {
            return new StringLiteral(String.valueOf(object));
        }
        if (object instanceof Number) {
            return new NumberLiteral((Number)object);
        }
        if (object instanceof TemporalAccessor) {
            return new TemporalLiteral((TemporalAccessor)object);
        }
        if (object instanceof Iterable || object.getClass().isArray()) {
            ArrayList elements = new ArrayList();
            Consumer<Object> handleElement = element -> {
                if (element instanceof Literal) {
                    elements.add((Literal)element);
                } else {
                    try {
                        elements.add(Cypher.literalOf(element));
                    }
                    catch (Literal.UnsupportedLiteralException e) {
                        throw new Literal.UnsupportedLiteralException("Unsupported literal type in iterable.", element);
                    }
                }
            };
            if (object.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(object); ++i) {
                    handleElement.accept(Array.get(object, i));
                }
            } else {
                ((Iterable)object).forEach(handleElement);
            }
            ListLiteral listLiteral = new ListLiteral(elements);
            return listLiteral;
        }
        if (object instanceof Boolean) {
            return BooleanLiteral.of((Boolean)object);
        }
        throw new Literal.UnsupportedLiteralException(object);
    }

    @NotNull
    @Contract(pure=true)
    public static Literal<Boolean> literalTrue() {
        return BooleanLiteral.TRUE;
    }

    @NotNull
    @Contract(pure=true)
    public static Literal<Boolean> literalFalse() {
        return BooleanLiteral.FALSE;
    }

    @NotNull
    @Contract(pure=true)
    public static Literal<Void> literalNull() {
        return NullLiteral.INSTANCE;
    }

    @NotNull
    @Contract(pure=true)
    public static Statement.UnionQuery union(Statement ... statements) {
        return Cypher.unionImpl(false, statements);
    }

    @NotNull
    @Contract(pure=true)
    public static Statement.UnionQuery union(Collection<Statement> statements) {
        return Cypher.union(statements.toArray(new Statement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Statement unionAll(Statement ... statements) {
        return Cypher.unionImpl(true, statements);
    }

    @NotNull
    @Contract(pure=true)
    public static Statement unionAll(Collection<Statement> statements) {
        return Cypher.unionAll(statements.toArray(new Statement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
        return Statement.builder().returning(expressions);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingAndReturn returning(Collection<Expression> expressions) {
        return Statement.builder().returning(expressions);
    }

    @NotNull
    @Contract(pure=true)
    public static PatternComprehension.OngoingDefinitionWithPattern listBasedOn(RelationshipPattern relationshipPattern) {
        return PatternComprehension.basedOn(relationshipPattern);
    }

    @NotNull
    @Contract(pure=true)
    public static PatternComprehension.OngoingDefinitionWithPattern listBasedOn(NamedPath namedPath) {
        return PatternComprehension.basedOn(namedPath);
    }

    @NotNull
    @Contract(pure=true)
    public static ListComprehension.OngoingDefinitionWithVariable listWith(SymbolicName variable) {
        return ListComprehension.with(variable);
    }

    @NotNull
    @Contract(pure=true)
    public static String quote(String unquotedString) {
        return Cypher.literalOf(unquotedString).asString();
    }

    @NotNull
    @Contract(pure=true)
    public static Case caseExpression() {
        return Case.create(null);
    }

    @NotNull
    @Contract(pure=true)
    public static Case caseExpression(@Nullable Expression expression) {
        return Case.create(expression);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(String procedureName) {
        Assertions.hasText(procedureName, "The procedure name must not be null or empty.");
        return Cypher.call(procedureName.split("\\."));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(String ... namespaceAndProcedure) {
        return Statement.call(namespaceAndProcedure);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(Collection<String> namespaceAndProcedure) {
        return Cypher.call(namespaceAndProcedure.toArray(new String[0]));
    }

    @Neo4jVersion(minimum="4.0.0")
    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere call(Statement subquery) {
        return Statement.builder().call(subquery);
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subList(Expression targetExpression, Integer start, Integer end) {
        return ListOperator.subList(targetExpression, Cypher.literalOf(start), Cypher.literalOf(end));
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subList(Expression targetExpression, Expression start, Expression end) {
        return ListOperator.subList(targetExpression, start, end);
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subListFrom(Expression targetExpression, Integer start) {
        return ListOperator.subListFrom(targetExpression, Cypher.literalOf(start));
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subListFrom(Expression targetExpression, Expression start) {
        return ListOperator.subListFrom(targetExpression, start);
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subListUntil(Expression targetExpression, Integer end) {
        return ListOperator.subListUntil(targetExpression, Cypher.literalOf(end));
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subListUntil(Expression targetExpression, Expression end) {
        return ListOperator.subListUntil(targetExpression, end);
    }

    @NotNull
    @Contract(pure=true)
    public static ListOperator valueAt(Expression targetExpression, Integer index) {
        return Cypher.valueAt(targetExpression, Cypher.literalOf(index));
    }

    @NotNull
    @Contract(pure=true)
    public static ListOperator valueAt(Expression targetExpression, Expression index) {
        return ListOperator.valueAt(targetExpression, index);
    }

    @NotNull
    @Contract(pure=true)
    public static Expression raw(String format, Object ... mixedArgs) {
        return RawLiteral.create(format, mixedArgs);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
        return Statement.builder().returningRaw(rawExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    @Contract(pure=true)
    public static <FE> ForeignAdapter<FE> adapt(FE expression) {
        ForeignAdapterFactory initializedForeignAdapterFactory = foreignAdapterFactory;
        if (initializedForeignAdapterFactory != null) return initializedForeignAdapterFactory.getAdapterFor(expression);
        Class<Cypher> clazz = Cypher.class;
        synchronized (Cypher.class) {
            initializedForeignAdapterFactory = foreignAdapterFactory;
            if (initializedForeignAdapterFactory != null) return initializedForeignAdapterFactory.getAdapterFor(expression);
            initializedForeignAdapterFactory = foreignAdapterFactory = new ForeignAdapterFactory();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return initializedForeignAdapterFactory.getAdapterFor(expression);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static ExposesLoadCSV usingPeriodicCommit() {
        return Cypher.usingPeriodicCommit(null);
    }

    @NotNull
    @Contract(pure=true)
    public static ExposesLoadCSV usingPeriodicCommit(@Nullable Integer rate) {
        return LoadCSVStatementBuilder.usingPeriodicCommit(rate);
    }

    public static LoadCSVStatementBuilder.OngoingLoadCSV loadCSV(URI from) {
        return Cypher.loadCSV(from, false);
    }

    public static LoadCSVStatementBuilder.OngoingLoadCSV loadCSV(URI from, boolean withHeaders) {
        return LoadCSVStatementBuilder.loadCSV(from, withHeaders);
    }

    private static Statement.UnionQuery unionImpl(boolean unionAll, Statement ... statements) {
        Assertions.isTrue(statements != null && statements.length >= 2, "At least two statements are required!");
        int i = 0;
        UnionQueryImpl existingUnionQuery = null;
        boolean isUnionQuery = statements[0] instanceof UnionQueryImpl;
        if (isUnionQuery) {
            existingUnionQuery = (UnionQueryImpl)statements[0];
            Assertions.isTrue(existingUnionQuery.isAll() == unionAll, "Cannot mix union and union all!");
            i = 1;
        }
        ArrayList<Statement> listOfQueries = new ArrayList<Statement>();
        do {
            Assertions.isTrue(statements[i] instanceof Statement.SingleQuery || statements[i] instanceof ClausesBasedStatement, "Can only union single queries!");
            listOfQueries.add(statements[i]);
        } while (++i < statements.length);
        if (existingUnionQuery == null) {
            return UnionQueryImpl.create(unionAll, listOfQueries);
        }
        return existingUnionQuery.addAdditionalQueries(listOfQueries);
    }

    public static String format(Expression expression) {
        return Expressions.format(expression);
    }

    public static Statement.UseStatement use(String target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Statement.UseStatement use(Parameter<?> target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Statement.UseStatement use(StringLiteral target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Statement.UseStatement use(SymbolicName target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    private Cypher() {
    }
}

