/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.internal.SchemaNamesBridge;
import org.neo4j.cypherdsl.core.utils.Strings;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class StatementContextImpl
implements StatementContext {
    private final AtomicInteger parameterCount = new AtomicInteger();
    private final Map<Parameter<?>, String> parameterNames = new ConcurrentHashMap();
    private boolean renderConstantsAsParameters = false;
    private final Map<SymbolicName, String> resolvedSymbolicNames = new ConcurrentHashMap<SymbolicName, String>();

    StatementContextImpl() {
    }

    @Override
    public String getParameterName(Parameter<?> parameter) {
        return this.parameterNames.computeIfAbsent(parameter, p -> p.isAnon() ? String.format("pcdsl%02d", this.parameterCount.incrementAndGet()) : p.getName());
    }

    @Override
    public boolean isRenderConstantsAsParameters() {
        return this.renderConstantsAsParameters;
    }

    void setRenderConstantsAsParameters(boolean renderConstantsAsParameters) {
        this.renderConstantsAsParameters = renderConstantsAsParameters;
    }

    @Override
    public String resolve(SymbolicName symbolicName) {
        return this.resolvedSymbolicNames.computeIfAbsent(symbolicName, k -> {
            String value = k.getValue();
            if (Strings.hasText(value)) {
                return SchemaNamesBridge.sanitize(value, false).orElse(value);
            }
            return String.format("%s%03d", Strings.randomIdentifier(8), this.resolvedSymbolicNames.size());
        });
    }

    @Override
    public boolean isResolved(SymbolicName symbolicName) {
        return this.resolvedSymbolicNames.containsKey(symbolicName);
    }
}

