/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.FunctionInvocation;

@API(status=API.Status.INTERNAL, since="2020.1.0")
final class BuiltInFunctions {
    private BuiltInFunctions() {
    }

    static enum MathematicalFunctions implements FunctionInvocation.FunctionDefinition
    {
        ABS("abs"),
        CEIL("ceil"),
        FLOOR("floor"),
        RAND("rand", 0, 0),
        ROUND("round", 1, 3),
        SIGN("sign"),
        E("e", 0, 0),
        EXP("exp"),
        LOG("log"),
        LOG10("log10"),
        SQRT("sqrt"),
        ACOS("acos"),
        ASIN("asin"),
        ATAN("atan"),
        ATAN2("atan2", 2, 2),
        COS("cos"),
        COT("cot"),
        DEGREES("degrees"),
        HAVERSIN("haversin"),
        PI("pi", 0, 0),
        RADIANS("radians"),
        SIN("sin"),
        TAN("tan");

        private final String implementationName;
        private final int minArgs;
        private final int maxArgs;

        private MathematicalFunctions(String implementationName) {
            this(implementationName, 1, 1);
        }

        private MathematicalFunctions(String implementationName, int minArgs, int maxArgs) {
            this.implementationName = implementationName;
            this.minArgs = minArgs;
            this.maxArgs = maxArgs;
        }

        public int getMinArgs() {
            return this.minArgs;
        }

        public int getMaxArgs() {
            return this.maxArgs;
        }

        @Override
        public String getImplementationName() {
            return this.implementationName;
        }
    }

    static enum Temporals implements FunctionInvocation.FunctionDefinition
    {
        DATE("date"),
        DATETIME("datetime"),
        LOCALDATETIME("localdatetime"),
        LOCALTIME("localtime"),
        TIME("time"),
        DURATION("duration");

        private final String implementationName;

        private Temporals(String implementationName) {
            this.implementationName = implementationName;
        }

        @Override
        public String getImplementationName() {
            return this.implementationName;
        }
    }

    static enum Lists implements FunctionInvocation.FunctionDefinition
    {
        KEYS("keys"),
        LABELS("labels"),
        NODES("nodes"),
        RANGE("range"),
        REDUCE("reduce"),
        RELATIONSHIPS("relationships");

        private final String implementationName;

        private Lists(String implementationName) {
            this.implementationName = implementationName;
        }

        @Override
        public String getImplementationName() {
            return this.implementationName;
        }
    }

    static enum Aggregates implements FunctionInvocation.FunctionDefinition
    {
        AVG("avg"),
        COLLECT("collect"),
        COUNT("count"),
        MAX("max"),
        MIN("min"),
        PERCENTILE_CONT("percentileCont"),
        PERCENTILE_DISC("percentileDisc"),
        ST_DEV("stDev"),
        ST_DEV_P("stDevP"),
        SUM("sum");

        private final String implementationName;

        private Aggregates(String implementationName) {
            this.implementationName = implementationName;
        }

        @Override
        public String getImplementationName() {
            return this.implementationName;
        }

        @Override
        public boolean isAggregate() {
            return true;
        }
    }

    static enum Spatials implements FunctionInvocation.FunctionDefinition
    {
        POINT("point"),
        DISTANCE("distance");

        private final String implementationName;

        private Spatials(String implementationName) {
            this.implementationName = implementationName;
        }

        @Override
        public String getImplementationName() {
            return this.implementationName;
        }
    }

    static enum Strings implements FunctionInvocation.FunctionDefinition
    {
        LEFT("left"),
        LTRIM("ltrim"),
        REPLACE("replace"),
        REVERSE("reverse"),
        RIGHT("right"),
        RTRIM("rtrim"),
        SPLIT("split"),
        SUBSTRING("substring"),
        TO_LOWER("toLower"),
        TO_STRING("toString"),
        TO_STRING_OR_NULL("toStringOrNull"),
        TO_UPPER("toUpper"),
        TRIM("trim");

        private final String implementationName;

        private Strings(String implementationName) {
            this.implementationName = implementationName;
        }

        @Override
        public String getImplementationName() {
            return this.implementationName;
        }
    }

    static enum Scalars implements FunctionInvocation.FunctionDefinition
    {
        COALESCE("coalesce"),
        END_NODE("endNode"),
        HEAD("head"),
        ID("id"),
        ELEMENT_ID("elementId"),
        LAST("last"),
        LENGTH("length"),
        PROPERTIES("properties"),
        SHORTEST_PATH("shortestPath"),
        SIZE("size"),
        START_NODE("startNode"),
        TYPE("type"),
        TO_STRING("toString"),
        TO_INTEGER("toInteger"),
        TO_FLOAT("toFloat"),
        TO_BOOLEAN("toBoolean");

        private final String implementationName;

        private Scalars(String implementationName) {
            this.implementationName = implementationName;
        }

        @Override
        public String getImplementationName() {
            return this.implementationName;
        }
    }

    static enum Predicates implements FunctionInvocation.FunctionDefinition
    {
        ALL("all"),
        ANY("any"),
        EXISTS("exists"),
        NONE("none"),
        SINGLE("single");

        private final String implementationName;

        private Predicates(String implementationName) {
            this.implementationName = implementationName;
        }

        @Override
        public String getImplementationName() {
            return this.implementationName;
        }
    }
}

