/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Objects;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class Parameter<T>
implements Expression {
    static final Object NO_VALUE = new Object();
    private final String name;
    private final T value;

    static Parameter<Object> create(String name) {
        return Parameter.create(name, NO_VALUE);
    }

    static <T> Parameter<T> create(String name, T value) {
        Assertions.hasText(name, "The name of the parameter is required!");
        if (name.startsWith("$")) {
            return Parameter.create(name.substring(1), value);
        }
        return new Parameter<T>(name, value);
    }

    static <T> Parameter<T> anon(T value) {
        return new Parameter<T>(null, value);
    }

    private Parameter(String name, T value) {
        this.name = name;
        this.value = value;
    }

    @API(status=API.Status.STABLE, since="2021.0.0")
    public boolean isAnon() {
        return this.name == null || this.name.trim().isEmpty();
    }

    String getName() {
        return this.name;
    }

    @API(status=API.Status.STABLE, since="2021.0.0")
    public Parameter<?> withValue(Object newValue) {
        return Parameter.create(this.name, newValue);
    }

    @API(status=API.Status.INTERNAL, since="2021.1.0")
    public T getValue() {
        return this.value;
    }

    boolean hasValue() {
        return !Objects.equals(this.value, NO_VALUE);
    }
}

