/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.internal.StatementContext;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.DefaultVisitor;
import org.neo4j.cypherdsl.core.renderer.PrettyPrintingVisitor;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.cypherdsl.core.renderer.RenderingVisitor;
import org.neo4j.cypherdsl.core.utils.LRUCache;

class ConfigurableRenderer
implements Renderer {
    private static final Map<Configuration, ConfigurableRenderer> CONFIGURATIONS = new ConcurrentHashMap<Configuration, ConfigurableRenderer>(8);
    private static final int STATEMENT_CACHE_SIZE = 128;
    private final LinkedHashMap<Integer, String> renderedStatementCache = new LRUCache<Integer, String>(128);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();
    private final Configuration configuration;

    static ConfigurableRenderer create(Configuration configuration) {
        return CONFIGURATIONS.computeIfAbsent(configuration, ConfigurableRenderer::new);
    }

    ConfigurableRenderer(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(Statement statement) {
        String renderedContent;
        int key = Objects.hash(statement, statement.isRenderConstantsAsParameters());
        try {
            this.read.lock();
            renderedContent = this.renderedStatementCache.get(key);
        }
        finally {
            this.read.unlock();
        }
        if (renderedContent == null) {
            try {
                this.write.lock();
                RenderingVisitor renderingVisitor = this.createVisitor(statement.getContext());
                statement.accept(renderingVisitor);
                renderedContent = renderingVisitor.getRenderedContent().trim();
                this.renderedStatementCache.put(key, renderedContent);
            }
            finally {
                this.write.unlock();
            }
        }
        return renderedContent;
    }

    private RenderingVisitor createVisitor(StatementContext statementContext) {
        if (!this.configuration.isPrettyPrint()) {
            return new DefaultVisitor(statementContext, this.configuration.isAlwaysEscapeNames());
        }
        return new PrettyPrintingVisitor(statementContext, this.configuration.isAlwaysEscapeNames(), this.configuration.getIndentStyle(), this.configuration.getIndentSize());
    }
}

