/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.STABLE, since="2020.1.2")
@Neo4jVersion(minimum="4.0.0")
public final class Subquery
implements Clause {
    private final With imports;
    private final With renames;
    private final Statement statement;

    static Subquery call(Statement statement, IdentifiableElement ... imports) {
        return Subquery.call(statement, false, imports);
    }

    static Subquery call(Statement statement, boolean skipAssertions, IdentifiableElement ... imports) {
        boolean validReturn;
        if (!skipAssertions && !(validReturn = statement.doesReturnOrYield())) {
            throw new IllegalArgumentException("Only a statement that returns elements, either via RETURN or YIELD, can be used in a subquery.");
        }
        With optionalImports = null;
        With optionalRenames = null;
        if (imports.length > 0) {
            ExpressionList returnItems = new ExpressionList(Arrays.stream(imports).map(i -> {
                if (i instanceof AliasedExpression) {
                    return ((AliasedExpression)i).getDelegate();
                }
                return i.asExpression();
            }).collect(Collectors.toList()));
            optionalImports = new With(false, returnItems, null, null, null, null);
            returnItems = new ExpressionList(Arrays.stream(imports).filter(AliasedExpression.class::isInstance).map(AliasedExpression.class::cast).collect(Collectors.toList()));
            optionalRenames = new With(false, returnItems, null, null, null, null);
        }
        return new Subquery(optionalImports, optionalRenames, statement);
    }

    private Subquery(@Nullable With imports, @Nullable With renames, Statement statement) {
        this.imports = imports;
        this.renames = renames;
        this.statement = statement;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Visitable.visitIfNotNull(this.imports, visitor);
        Visitable.visitIfNotNull(this.renames, visitor);
        this.statement.accept(visitor);
        visitor.leave(this);
    }
}

