/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.IdentifiableExpressionCollectingVisitor;
import org.neo4j.cypherdsl.core.ParameterCollectingVisitor;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementContextImpl;
import org.neo4j.cypherdsl.core.internal.StatementContext;
import org.neo4j.cypherdsl.core.renderer.Renderer;

@API(status=API.Status.INTERNAL, since="2021.0.0")
abstract class AbstractStatement
implements Statement {
    private final StatementContextImpl context = new StatementContextImpl();
    private volatile ParameterCollectingVisitor.ParameterInformation parameterInformation;
    private volatile String cypher;
    private volatile Collection<Expression> identifiables;

    AbstractStatement() {
    }

    @Override
    @NotNull
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public boolean isRenderConstantsAsParameters() {
        return this.context.isRenderConstantsAsParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRenderConstantsAsParameters(boolean renderConstantsAsParameters) {
        AbstractStatement abstractStatement = this;
        synchronized (abstractStatement) {
            this.context.setRenderConstantsAsParameters(renderConstantsAsParameters);
            this.cypher = null;
            this.parameterInformation = null;
        }
    }

    @Override
    @NotNull
    public Map<String, Object> getParameters() {
        return this.getParameterInformation().values;
    }

    @NotNull
    public Set<String> getParameterNames() {
        return this.getParameterInformation().names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<Expression> getIdentifiableExpressions() {
        Collection<Expression> result = this.identifiables;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.identifiables;
                if (result == null) {
                    IdentifiableExpressionCollectingVisitor visitor = new IdentifiableExpressionCollectingVisitor();
                    this.accept(visitor);
                    result = this.identifiables = visitor.getResult();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getCypher() {
        String result = this.cypher;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.cypher;
                if (result == null) {
                    result = this.cypher = Renderer.getDefaultRenderer().render(this);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParameterCollectingVisitor.ParameterInformation getParameterInformation() {
        ParameterCollectingVisitor.ParameterInformation result = this.parameterInformation;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.parameterInformation;
                if (result == null) {
                    result = this.parameterInformation = this.collectParameters();
                }
            }
        }
        return result;
    }

    private ParameterCollectingVisitor.ParameterInformation collectParameters() {
        ParameterCollectingVisitor parameterCollectingVisitor = new ParameterCollectingVisitor(this.getContext());
        this.accept(parameterCollectingVisitor);
        return parameterCollectingVisitor.getResult();
    }
}

