/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.executables;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.executables.DefaultReactiveExecutableResultStatement;
import org.neo4j.cypherdsl.core.executables.DefaultReactiveExecutableStatement;
import org.neo4j.cypherdsl.core.executables.ExecutableStatement;
import org.neo4j.cypherdsl.core.executables.ReactiveExecutableResultStatement;
import org.neo4j.driver.reactive.RxQueryRunner;
import org.neo4j.driver.summary.ResultSummary;
import org.reactivestreams.Publisher;

@API(status=API.Status.EXPERIMENTAL, since="2021.2.1")
public interface ReactiveExecutableStatement
extends ExecutableStatement {
    public static ReactiveExecutableStatement makeExecutable(Statement statement) {
        if (statement.doesReturnOrYield()) {
            return new DefaultReactiveExecutableResultStatement(statement);
        }
        return new DefaultReactiveExecutableStatement(statement);
    }

    public static ReactiveExecutableResultStatement makeExecutable(ResultStatement statement) {
        return new DefaultReactiveExecutableResultStatement(statement);
    }

    public static ReactiveExecutableStatement of(Statement statement) {
        return ReactiveExecutableStatement.makeExecutable(statement);
    }

    public static ReactiveExecutableResultStatement of(ResultStatement statement) {
        return ReactiveExecutableStatement.makeExecutable(statement);
    }

    public Publisher<ResultSummary> executeWith(RxQueryRunner var1);
}

