/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.DefaultStatementBuilder;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Limit;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.RawLiteral;
import org.neo4j.cypherdsl.core.ReturnBody;
import org.neo4j.cypherdsl.core.Skip;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.Distinct;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Return
implements Visitable {
    private final Distinct distinct;
    private final ReturnBody body;
    private final boolean raw;

    static Return create(boolean raw, boolean distinct, List<Expression> returnList, DefaultStatementBuilder.OrderBuilder orderBuilder) {
        if (returnList.isEmpty()) {
            return null;
        }
        if (raw) {
            String message = "A raw return must consist of exactly one raw expression.";
            Assertions.isTrue(returnList.size() == 1, message);
            Expression firstExpression = returnList.get(0);
            Assertions.isTrue(firstExpression instanceof RawLiteral || firstExpression instanceof AliasedExpression && ((AliasedExpression)firstExpression).getDelegate() instanceof RawLiteral, message);
        }
        ExpressionList returnItems = new ExpressionList(returnList);
        return new Return(raw, distinct, returnItems, orderBuilder.buildOrder().orElse(null), orderBuilder.getSkip(), orderBuilder.getLimit());
    }

    private Return(boolean raw, boolean distinct, ExpressionList returnItems, Order order, Skip skip, Limit limit) {
        this.distinct = !raw && distinct ? Distinct.INSTANCE : null;
        this.body = new ReturnBody(returnItems, order, skip, limit);
        this.raw = raw;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Visitable.visitIfNotNull(this.distinct, visitor);
        this.body.accept(visitor);
        visitor.leave(this);
    }

    @API(status=API.Status.INTERNAL)
    public boolean isRaw() {
        return this.raw;
    }

    Distinct getDistinct() {
        return this.distinct;
    }

    ReturnBody getBody() {
        return this.body;
    }
}

