/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.SymbolicName;

@API(status=API.Status.INTERNAL, since="1.0")
final class Expressions {
    static <T extends Expression> Expression nameOrExpression(T expression) {
        if (expression instanceof Named) {
            return ((Named)((Object)expression)).getSymbolicName().map(Expression.class::cast).orElse(expression);
        }
        return expression;
    }

    static Expression[] createSymbolicNames(String[] variables) {
        return (Expression[])Arrays.stream(variables).map(SymbolicName::of).toArray(Expression[]::new);
    }

    static Expression[] createSymbolicNames(Named[] variables) {
        return (Expression[])Arrays.stream(variables).map(Named::getRequiredSymbolicName).toArray(Expression[]::new);
    }

    private Expressions() {
    }

    public static Expression[] createSymbolicNames(IdentifiableElement[] variables) {
        return (Expression[])Arrays.stream(variables).map(IdentifiableElement::asExpression).toArray(Expression[]::new);
    }
}

