/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Arguments;
import org.neo4j.cypherdsl.core.CompoundCondition;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.DefaultLoadCSVStatementBuilder;
import org.neo4j.cypherdsl.core.Delete;
import org.neo4j.cypherdsl.core.ExistentialSubquery;
import org.neo4j.cypherdsl.core.ExposesReturning;
import org.neo4j.cypherdsl.core.ExposesWhere;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Hint;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Limit;
import org.neo4j.cypherdsl.core.LoadCSVStatementBuilder;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.MultiPartElement;
import org.neo4j.cypherdsl.core.MultiPartQuery;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.ProcedureCallImpl;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Remove;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.SinglePartQuery;
import org.neo4j.cypherdsl.core.Skip;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Unwind;
import org.neo4j.cypherdsl.core.UpdatingClause;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.internal.ProcedureName;
import org.neo4j.cypherdsl.core.internal.YieldItems;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL, since="2021.2.1")
class DefaultStatementBuilder
implements StatementBuilder,
StatementBuilder.OngoingUpdate,
StatementBuilder.OngoingMerge,
StatementBuilder.OngoingReadingWithWhere,
StatementBuilder.OngoingReadingWithoutWhere,
StatementBuilder.OngoingMatchAndUpdate,
StatementBuilder.BuildableMatchAndUpdate,
StatementBuilder.BuildableOngoingMergeAction {
    private final List<Visitable> currentSinglePartElements = new ArrayList<Visitable>();
    private MatchBuilder currentOngoingMatch;
    private DefaultStatementWithUpdateBuilder currentOngoingUpdate;
    private final List<MultiPartElement> multiPartElements = new ArrayList<MultiPartElement>();
    private static final EnumSet<UpdateType> MERGE_OR_CREATE = EnumSet.of(UpdateType.CREATE, UpdateType.MERGE);
    private static final EnumSet<UpdateType> SET = EnumSet.of(UpdateType.SET, UpdateType.MUTATE);

    DefaultStatementBuilder(Visitable ... visitables) {
        this.addVisitables(visitables);
    }

    DefaultStatementBuilder(DefaultStatementBuilder source, Visitable ... visitables) {
        this.currentSinglePartElements.addAll(source.currentSinglePartElements);
        this.currentOngoingMatch = source.currentOngoingMatch;
        this.currentOngoingUpdate = source.currentOngoingUpdate;
        this.multiPartElements.addAll(source.multiPartElements);
        this.addVisitables(visitables);
    }

    private void addVisitables(Visitable[] visitables) {
        for (Visitable visitable : visitables) {
            if (visitable == null) continue;
            this.currentSinglePartElements.add(visitable);
        }
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
        Assertions.notNull(pattern, "Patterns to match are required.");
        Assertions.notEmpty(pattern, "At least one pattern to match is required.");
        this.closeCurrentOngoingMatch();
        this.currentOngoingMatch = new MatchBuilder(optional);
        this.currentOngoingMatch.patternList.addAll(Arrays.asList(pattern));
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
        return this.update(UpdateType.CREATE, pattern);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate create(Collection<PatternElement> pattern) {
        return this.create(pattern.toArray(new PatternElement[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
        return this.update(UpdateType.MERGE, pattern);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingMergeAction onCreate() {
        return this.ongoingOnAfterMerge(MergeAction.Type.ON_CREATE);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingMergeAction onMatch() {
        return this.ongoingOnAfterMerge(MergeAction.Type.ON_MATCH);
    }

    private StatementBuilder.OngoingMergeAction ongoingOnAfterMerge(final MergeAction.Type type) {
        Assertions.notNull(this.currentOngoingUpdate, "MERGE must have been invoked before defining an event.");
        Assertions.isTrue(this.currentOngoingUpdate.builder instanceof SupportsActionsOnTheUpdatingClause, "MERGE must have been invoked before defining an event.");
        return new StatementBuilder.OngoingMergeAction(){

            @Override
            @NotNull
            public StatementBuilder.BuildableOngoingMergeAction mutate(Expression target, Expression properties) {
                ((SupportsActionsOnTheUpdatingClause)((Object)((DefaultStatementBuilder)DefaultStatementBuilder.this).currentOngoingUpdate.builder)).on(type, UpdateType.MUTATE, target, properties);
                return DefaultStatementBuilder.this;
            }

            @Override
            @NotNull
            public StatementBuilder.BuildableOngoingMergeAction set(Expression ... expressions) {
                ((SupportsActionsOnTheUpdatingClause)((Object)((DefaultStatementBuilder)DefaultStatementBuilder.this).currentOngoingUpdate.builder)).on(type, UpdateType.SET, expressions);
                return DefaultStatementBuilder.this;
            }

            @Override
            @NotNull
            public StatementBuilder.BuildableOngoingMergeAction set(Collection<Expression> expressions) {
                return this.set(expressions.toArray(new Expression[0]));
            }
        };
    }

    @Override
    public final StatementBuilder.OngoingUnwind unwind(Expression expression) {
        this.closeCurrentOngoingMatch();
        return new DefaultOngoingUnwind(expression);
    }

    private DefaultStatementBuilder update(UpdateType updateType, Object[] pattern) {
        Assertions.notNull(pattern, "Patterns to create are required.");
        Assertions.notEmpty(pattern, "At least one pattern to create is required.");
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingUpdate();
        if (pattern.getClass().getComponentType() == PatternElement.class) {
            this.currentOngoingUpdate = new DefaultStatementWithUpdateBuilder(updateType, (PatternElement[])pattern);
        } else if (pattern.getClass().getComponentType() == Expression.class) {
            this.currentOngoingUpdate = new DefaultStatementWithUpdateBuilder(updateType, (Expression[])pattern);
        }
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
        return this.returning(false, false, expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingAndReturn returning(Collection<Expression> expressions) {
        return this.returning(expressions.toArray(new Expression[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
        return this.returning(false, true, expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<Expression> expressions) {
        return this.returningDistinct(expressions.toArray(new Expression[0]));
    }

    @Override
    @NotNull
    public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
        return this.returning(true, false, rawExpression);
    }

    private StatementBuilder.OngoingReadingAndReturn returning(boolean raw, boolean distinct, Expression ... expressions) {
        DefaultStatementWithReturnBuilder ongoingMatchAndReturn = new DefaultStatementWithReturnBuilder(raw, distinct);
        ongoingMatchAndReturn.addExpressions(expressions);
        return ongoingMatchAndReturn;
    }

    @Override
    @NotNull
    public final StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(String ... variables) {
        return this.with(false, Expressions.createSymbolicNames(variables));
    }

    @Override
    @NotNull
    public final StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Named ... variables) {
        return this.with(false, Expressions.createSymbolicNames(variables));
    }

    @Override
    @NotNull
    public final StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(SymbolicName ... variables) {
        return this.with(false, (Expression[])variables);
    }

    @Override
    @NotNull
    public final StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(IdentifiableElement ... elements) {
        return this.with(false, Expressions.createSymbolicNames(elements));
    }

    @Override
    @NotNull
    public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(AliasedExpression ... expressions) {
        return this.with((Expression[])expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
        return this.with(false, expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<Expression> expressions) {
        return this.with(expressions.toArray(new Expression[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... expressions) {
        return this.with(true, expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<Expression> expressions) {
        return this.withDistinct(expressions.toArray(new Expression[0]));
    }

    private StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(boolean distinct, Expression ... expressions) {
        DefaultStatementWithWithBuilder ongoingMatchAndWith = new DefaultStatementWithWithBuilder(distinct);
        ongoingMatchAndWith.addExpressions(expressions);
        return ongoingMatchAndWith;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate delete(Expression ... expressions) {
        return this.update(UpdateType.DELETE, expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate delete(Collection<Expression> expressions) {
        return this.delete(expressions.toArray(new Expression[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate detachDelete(Expression ... expressions) {
        return this.update(UpdateType.DETACH_DELETE, expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate detachDelete(Collection<Expression> expressions) {
        return this.detachDelete(expressions.toArray(new Expression[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate set(Expression ... expressions) {
        this.closeCurrentOngoingUpdate();
        return new DefaultStatementWithUpdateBuilder(UpdateType.SET, expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate set(Collection<Expression> expressions) {
        return this.set(expressions.toArray(new Expression[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate set(Node named, String ... labels) {
        return new DefaultStatementWithUpdateBuilder(UpdateType.SET, Operations.set(named, labels));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate set(Node named, Collection<String> labels) {
        return this.set(named, labels.toArray(new String[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate mutate(Expression target, Expression properties) {
        this.closeCurrentOngoingUpdate();
        return new DefaultStatementWithUpdateBuilder(UpdateType.MUTATE, Operations.mutate(target, properties));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate remove(Property ... properties) {
        return new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, properties);
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate remove(Collection<Property> properties) {
        return this.remove(properties.toArray(new Property[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate remove(Node named, String ... labels) {
        return new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, Operations.remove(named, labels));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate remove(Node named, Collection<String> labels) {
        return this.remove(named, labels.toArray(new String[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
        this.currentOngoingMatch.conditionBuilder.where(newCondition);
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithWhere and(Condition additionalCondition) {
        this.currentOngoingMatch.conditionBuilder.and(additionalCondition);
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithWhere or(Condition additionalCondition) {
        this.currentOngoingMatch.conditionBuilder.or(additionalCondition);
        return this;
    }

    @Override
    @NotNull
    public Statement build() {
        return this.buildImpl(null);
    }

    protected final Statement buildImpl(Return returning) {
        SinglePartQuery singlePartQuery = SinglePartQuery.create(this.buildListOfVisitables(false), returning);
        if (this.multiPartElements.isEmpty()) {
            return singlePartQuery;
        }
        return MultiPartQuery.create(this.multiPartElements, singlePartQuery);
    }

    protected final List<Visitable> buildListOfVisitables(boolean clearAfter) {
        ArrayList<Visitable> visitables = new ArrayList<Visitable>(this.currentSinglePartElements);
        if (this.currentOngoingMatch != null) {
            visitables.add(this.currentOngoingMatch.buildMatch());
        }
        if (this.currentOngoingUpdate != null) {
            visitables.add(this.currentOngoingUpdate.builder.build());
        }
        if (clearAfter) {
            this.currentOngoingMatch = null;
            this.currentOngoingUpdate = null;
            this.currentSinglePartElements.clear();
        }
        return visitables;
    }

    protected final DefaultStatementBuilder addWith(Optional<With> optionalWith) {
        optionalWith.ifPresent(with -> this.multiPartElements.add(new MultiPartElement(this.buildListOfVisitables(true), (With)with)));
        return this;
    }

    protected final void addUpdatingClause(UpdatingClause updatingClause) {
        this.closeCurrentOngoingMatch();
        this.currentSinglePartElements.add(updatingClause);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere call(Statement statement) {
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingUpdate();
        this.currentSinglePartElements.add(Subquery.call(statement));
        return this;
    }

    private void closeCurrentOngoingMatch() {
        if (this.currentOngoingMatch == null) {
            return;
        }
        this.currentSinglePartElements.add(this.currentOngoingMatch.buildMatch());
        this.currentOngoingMatch = null;
    }

    private void closeCurrentOngoingUpdate() {
        if (this.currentOngoingUpdate == null) {
            return;
        }
        this.currentSinglePartElements.add(this.currentOngoingUpdate.builder.build());
        this.currentOngoingUpdate = null;
    }

    @Override
    @NotNull
    public final Condition asCondition() {
        if (this.currentOngoingMatch == null || !this.currentSinglePartElements.isEmpty()) {
            throw new IllegalArgumentException("Only simple MATCH statements can be used as existential subqueries.");
        }
        return ExistentialSubquery.exists(this.currentOngoingMatch.buildMatch());
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere usingIndex(Property ... properties) {
        this.currentOngoingMatch.hints.add(Hint.useIndexFor(false, properties));
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere usingIndexSeek(Property ... properties) {
        this.currentOngoingMatch.hints.add(Hint.useIndexFor(true, properties));
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere usingScan(Node node) {
        this.currentOngoingMatch.hints.add(Hint.useScanFor(node));
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere usingJoinOn(SymbolicName ... names) {
        this.currentOngoingMatch.hints.add(Hint.useJoinOn(names));
        return this;
    }

    @SafeVarargs
    private static <T extends Visitable> UpdatingClauseBuilder getUpdatingClauseBuilder(UpdateType updateType, T ... patternOrExpressions) {
        boolean mergeOrCreate = MERGE_OR_CREATE.contains((Object)updateType);
        String message = mergeOrCreate ? "At least one pattern is required." : "At least one modifying expressions is required.";
        Assertions.notNull(patternOrExpressions, message);
        Assertions.notEmpty(patternOrExpressions, message);
        if (mergeOrCreate) {
            List<PatternElement> patternElements = Arrays.stream(patternOrExpressions).map(PatternElement.class::cast).collect(Collectors.toList());
            if (updateType == UpdateType.CREATE) {
                return new AbstractUpdatingClauseBuilder.CreateBuilder(patternElements);
            }
            return new AbstractUpdatingClauseBuilder.MergeBuilder(patternElements);
        }
        List<Expression> expressions = Arrays.stream(patternOrExpressions).map(Expression.class::cast).collect(Collectors.toList());
        ExpressionList expressionList = new ExpressionList(SET.contains((Object)updateType) ? DefaultStatementBuilder.prepareSetExpressions(updateType, expressions) : expressions);
        switch (updateType) {
            case DETACH_DELETE: {
                return () -> new Delete(expressionList, true);
            }
            case DELETE: {
                return () -> new Delete(expressionList, false);
            }
            case SET: 
            case MUTATE: {
                return () -> new Set(expressionList);
            }
            case REMOVE: {
                return () -> new Remove(expressionList);
            }
        }
        throw new IllegalArgumentException("Unsupported update type " + (Object)((Object)updateType));
    }

    private static List<Expression> prepareSetExpressions(UpdateType updateType, List<Expression> possibleSetOperations) {
        ArrayList<Expression> propertyOperations;
        block12: {
            ArrayList<Expression> listOfExpressions;
            block11: {
                propertyOperations = new ArrayList<Expression>();
                listOfExpressions = new ArrayList<Expression>();
                for (Expression possibleSetOperation : possibleSetOperations) {
                    if (possibleSetOperation instanceof Operation) {
                        propertyOperations.add(possibleSetOperation);
                        continue;
                    }
                    listOfExpressions.add(possibleSetOperation);
                }
                if (listOfExpressions.size() % 2 != 0) {
                    throw new IllegalArgumentException("The list of expression to set must be even.");
                }
                if (updateType != UpdateType.SET) break block11;
                for (int i = 0; i < listOfExpressions.size(); i += 2) {
                    propertyOperations.add(Operations.set((Expression)listOfExpressions.get(i), (Expression)listOfExpressions.get(i + 1)));
                }
                break block12;
            }
            if (updateType != UpdateType.MUTATE) break block12;
            if (!listOfExpressions.isEmpty() && !propertyOperations.isEmpty()) {
                throw new IllegalArgumentException("A mutating SET must be build through a single operation or through a pair of expression, not both.");
            }
            if (listOfExpressions.isEmpty()) {
                for (Expression operation : propertyOperations) {
                    if (((Operation)operation).getOperator() == Operator.MUTATE) continue;
                    throw new IllegalArgumentException("Only property operations based on the " + Operator.MUTATE + " are supported inside a mutating SET.");
                }
            } else {
                for (int i = 0; i < listOfExpressions.size(); i += 2) {
                    Expression rhs = (Expression)listOfExpressions.get(i + 1);
                    if (rhs instanceof Parameter) {
                        propertyOperations.add(Operations.mutate((Expression)listOfExpressions.get(i), rhs));
                        continue;
                    }
                    if (rhs instanceof MapExpression) {
                        propertyOperations.add(Operations.mutate((Expression)listOfExpressions.get(i), (MapExpression)rhs));
                        continue;
                    }
                    throw new IllegalArgumentException("A mutating SET operation can only be used with a named parameter or a map expression.");
                }
            }
        }
        return propertyOperations;
    }

    @Override
    @NotNull
    public InQueryCallBuilder call(String ... namespaceAndProcedure) {
        Assertions.notEmpty(namespaceAndProcedure, "The procedure namespace and name must not be null or empty.");
        this.closeCurrentOngoingMatch();
        return new InQueryCallBuilder(ProcedureName.from(namespaceAndProcedure));
    }

    static final class OrderBuilder {
        protected final List<SortItem> sortItemList = new ArrayList<SortItem>();
        protected SortItem lastSortItem;
        protected Skip skip;
        protected Limit limit;

        OrderBuilder() {
        }

        protected void reset() {
            this.sortItemList.clear();
            this.lastSortItem = null;
            this.skip = null;
            this.limit = null;
        }

        protected void orderBy(SortItem ... sortItem) {
            this.sortItemList.addAll(Arrays.asList(sortItem));
        }

        protected void orderBy(Expression expression) {
            this.lastSortItem = Cypher.sort(expression);
        }

        protected void and(Expression expression) {
            this.orderBy(expression);
        }

        protected void descending() {
            this.sortItemList.add(this.lastSortItem.descending());
            this.lastSortItem = null;
        }

        protected void ascending() {
            this.sortItemList.add(this.lastSortItem.ascending());
            this.lastSortItem = null;
        }

        protected void skip(Expression expression) {
            if (expression != null) {
                this.skip = Skip.create(expression);
            }
        }

        protected void limit(Expression expression) {
            if (expression != null) {
                this.limit = Limit.create(expression);
            }
        }

        protected Optional<Order> buildOrder() {
            if (this.lastSortItem != null) {
                this.sortItemList.add(this.lastSortItem);
            }
            Optional<Order> result = this.sortItemList.size() > 0 ? Optional.of(new Order(this.sortItemList)) : Optional.empty();
            this.sortItemList.clear();
            this.lastSortItem = null;
            return result;
        }

        protected Skip getSkip() {
            return this.skip;
        }

        protected Limit getLimit() {
            return this.limit;
        }
    }

    static final class ConditionBuilder {
        protected Condition condition;

        ConditionBuilder() {
        }

        void where(Condition newCondition) {
            Assertions.notNull(newCondition, "The new condition must not be null.");
            this.condition = newCondition;
        }

        void and(Condition additionalCondition) {
            this.condition = this.condition.and(additionalCondition);
        }

        void or(Condition additionalCondition) {
            this.condition = this.condition.or(additionalCondition);
        }

        private boolean hasCondition() {
            return this.condition != null && (!(this.condition instanceof CompoundCondition) || ((CompoundCondition)this.condition).hasConditions());
        }

        Optional<Condition> buildCondition() {
            return this.hasCondition() ? Optional.of(this.condition) : Optional.empty();
        }
    }

    private final class InQueryCallBuilder
    extends AbstractCallBuilder
    implements StatementBuilder.OngoingInQueryCallWithoutArguments,
    StatementBuilder.OngoingInQueryCallWithArguments,
    StatementBuilder.OngoingInQueryCallWithReturnFields {
        private YieldItems yieldItems;

        InQueryCallBuilder(ProcedureName procedureName) {
            super(procedureName);
        }

        Statement buildCall() {
            return ProcedureCallImpl.create(this.procedureName, this.createArgumentList(), this.yieldItems, this.conditionBuilder.buildCondition().map(Where::new).orElse(null));
        }

        @Override
        @NotNull
        public InQueryCallBuilder withArgs(Expression ... arguments) {
            this.arguments = arguments;
            return this;
        }

        @Override
        @NotNull
        public InQueryCallBuilder yield(SymbolicName ... resultFields) {
            this.yieldItems = YieldItems.yieldAllOf(resultFields);
            return this;
        }

        @Override
        @NotNull
        public InQueryCallBuilder yield(AliasedExpression ... aliasedResultFields) {
            this.yieldItems = YieldItems.yieldAllOf(aliasedResultFields);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.returning(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Collection<Expression> expressions) {
            return this.returning(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.returningDistinct(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<Expression> expressions) {
            return this.returningDistinct(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.returningRaw(rawExpression);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.with(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<Expression> expressions) {
            return this.with(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... expressions) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.withDistinct(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<Expression> expressions) {
            return this.withDistinct(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithoutWhere call(Statement statement) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.call(statement);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.match(optional, pattern);
        }
    }

    private static final class YieldingStandaloneCallBuilder
    extends AbstractCallBuilder
    implements ExposesWhere,
    ExposesReturning,
    StatementBuilder.OngoingStandaloneCallWithReturnFields {
        private final YieldItems yieldItems;

        YieldingStandaloneCallBuilder(ProcedureName procedureName, Expression[] arguments, SymbolicName ... resultFields) {
            super(procedureName, arguments);
            this.yieldItems = YieldItems.yieldAllOf(resultFields);
        }

        YieldingStandaloneCallBuilder(ProcedureName procedureName, Expression[] arguments, AliasedExpression ... aliasedResultFields) {
            super(procedureName, arguments);
            this.yieldItems = YieldItems.yieldAllOf(aliasedResultFields);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
            return new DefaultStatementBuilder(this.buildCall()).returning(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Collection<Expression> expressions) {
            return this.returning(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
            return new DefaultStatementBuilder(this.buildCall()).returningDistinct(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<Expression> expressions) {
            return this.returningDistinct(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
            return new DefaultStatementBuilder(this.buildCall()).returningRaw(rawExpression);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            return new DefaultStatementBuilder(this.buildCall());
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
            return new DefaultStatementBuilder(this.buildCall()).with(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<Expression> expressions) {
            return this.with(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... expressions) {
            return new DefaultStatementBuilder(this.buildCall()).withDistinct(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<Expression> expressions) {
            return this.withDistinct(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithoutWhere call(Statement statement) {
            return new DefaultStatementBuilder(this.buildCall()).call(statement);
        }

        @Override
        @NotNull
        public ResultStatement build() {
            return (ResultStatement)((Object)ProcedureCallImpl.create(this.procedureName, this.createArgumentList(), this.yieldItems, this.conditionBuilder.buildCondition().map(Where::new).orElse(null)));
        }

        Statement buildCall() {
            return this.build();
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
            return new DefaultStatementBuilder(this.buildCall()).match(optional, pattern);
        }
    }

    static final class StandaloneCallBuilder
    extends AbstractCallBuilder
    implements StatementBuilder.OngoingStandaloneCallWithoutArguments,
    StatementBuilder.OngoingStandaloneCallWithArguments {
        StandaloneCallBuilder(ProcedureName procedureName) {
            super(procedureName);
        }

        @Override
        @NotNull
        public StandaloneCallBuilder withArgs(Expression ... arguments) {
            this.arguments = arguments;
            return this;
        }

        @Override
        @NotNull
        public YieldingStandaloneCallBuilder yield(SymbolicName ... resultFields) {
            return new YieldingStandaloneCallBuilder(this.procedureName, this.arguments, resultFields);
        }

        @Override
        @NotNull
        public YieldingStandaloneCallBuilder yield(AliasedExpression ... aliasedResultFields) {
            return new YieldingStandaloneCallBuilder(this.procedureName, this.arguments, aliasedResultFields);
        }

        @Override
        @NotNull
        public Expression asFunction(boolean distinct) {
            block5: {
                block4: {
                    if (this.arguments == null) break block4;
                    if (this.arguments.length != 0) break block5;
                }
                return FunctionInvocation.create(this.procedureName::getQualifiedName);
            }
            if (distinct) {
                return FunctionInvocation.createDistinct(this.procedureName::getQualifiedName, this.arguments);
            }
            return FunctionInvocation.create(this.procedureName::getQualifiedName, this.arguments);
        }

        @Override
        @NotNull
        public ProcedureCall build() {
            return ProcedureCallImpl.create(this.procedureName, this.createArgumentList(), null, this.conditionBuilder.buildCondition().map(Where::new).orElse(null));
        }
    }

    static abstract class AbstractCallBuilder {
        protected final ProcedureName procedureName;
        protected Expression[] arguments;
        protected final ConditionBuilder conditionBuilder = new ConditionBuilder();

        AbstractCallBuilder(ProcedureName procedureName) {
            this(procedureName, null);
        }

        AbstractCallBuilder(ProcedureName procedureName, Expression[] arguments) {
            this.procedureName = procedureName;
            this.arguments = arguments;
        }

        Arguments createArgumentList() {
            Arguments argumentsList = null;
            if (this.arguments != null && this.arguments.length > 0) {
                argumentsList = new Arguments(this.arguments);
            }
            return argumentsList;
        }
    }

    final class DefaultOngoingUnwind
    implements StatementBuilder.OngoingUnwind {
        private final Expression expressionToUnwind;

        DefaultOngoingUnwind(Expression expressionToUnwind) {
            this.expressionToUnwind = expressionToUnwind;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReading as(@NotNull String variable) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(new Unwind(this.expressionToUnwind, variable));
            return DefaultStatementBuilder.this;
        }
    }

    static final class MatchBuilder {
        private final List<PatternElement> patternList = new ArrayList<PatternElement>();
        private final List<Hint> hints = new ArrayList<Hint>();
        private final ConditionBuilder conditionBuilder = new ConditionBuilder();
        private final boolean optional;

        MatchBuilder(boolean optional) {
            this.optional = optional;
        }

        Match buildMatch() {
            Pattern pattern = new Pattern(this.patternList);
            return new Match(this.optional, pattern, this.conditionBuilder.buildCondition().map(Where::new).orElse(null), this.hints);
        }
    }

    protected final class DefaultStatementWithUpdateBuilder
    implements StatementBuilder.BuildableMatchAndUpdate {
        final UpdatingClauseBuilder builder;

        protected DefaultStatementWithUpdateBuilder(UpdateType updateType, PatternElement ... pattern) {
            this.builder = DefaultStatementBuilder.getUpdatingClauseBuilder((UpdateType)updateType, (Visitable[])pattern);
        }

        protected DefaultStatementWithUpdateBuilder(UpdateType updateType, Expression ... expressions) {
            this.builder = DefaultStatementBuilder.getUpdatingClauseBuilder((UpdateType)updateType, (Visitable[])expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... returnedExpressions) {
            Assertions.notNull(returnedExpressions, "Expressions to return are required.");
            Assertions.notEmpty(returnedExpressions, "At least one expressions to return is required.");
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementWithReturnBuilder delegate = new DefaultStatementWithReturnBuilder(false, false);
            delegate.returnList.addAll(Arrays.asList(returnedExpressions));
            return delegate;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Collection<Expression> returnedExpressions) {
            return this.returning(returnedExpressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... returnedExpressions) {
            DefaultStatementWithReturnBuilder delegate = (DefaultStatementWithReturnBuilder)this.returning(returnedExpressions);
            delegate.distinct = true;
            return delegate;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<Expression> returnedExpressions) {
            return this.returningDistinct(returnedExpressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
            DefaultStatementWithReturnBuilder delegate = (DefaultStatementWithReturnBuilder)this.returning(rawExpression);
            delegate.rawReturn = true;
            return delegate;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate delete(Expression ... deletedExpressions) {
            return this.delete(false, deletedExpressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate delete(Collection<Expression> deletedExpressions) {
            return this.delete(deletedExpressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate detachDelete(Expression ... deletedExpressions) {
            return this.delete(true, deletedExpressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate detachDelete(Collection<Expression> deletedExpressions) {
            return this.detachDelete(deletedExpressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.merge(pattern);
        }

        private StatementBuilder.OngoingUpdate delete(boolean nextDetach, Expression ... deletedExpressions) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.update(nextDetach ? UpdateType.DETACH_DELETE : UpdateType.DELETE, deletedExpressions);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Expression ... keyValuePairs) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.SET, keyValuePairs);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Collection<Expression> keyValuePairs) {
            return this.set(keyValuePairs.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, String ... labels) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.SET, Operations.set(node, labels));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, Collection<String> labels) {
            return this.set(node, labels.toArray(new String[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate mutate(Expression target, Expression properties) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.MUTATE, Operations.mutate(target, properties));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, String ... labels) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, Operations.set(node, labels));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, Collection<String> labels) {
            return this.remove(node, labels.toArray(new String[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Property ... properties) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, properties);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Collection<Property> properties) {
            return this.remove(properties.toArray(new Property[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... returnedExpressions) {
            return this.with(false, returnedExpressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<Expression> returnedExpressions) {
            return this.with(returnedExpressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... returnedExpressions) {
            return this.with(true, returnedExpressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<Expression> returnedExpressions) {
            return this.withDistinct(returnedExpressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.create(pattern);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate create(Collection<PatternElement> pattern) {
            return this.create(pattern.toArray(new PatternElement[0]));
        }

        private StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(boolean distinct, Expression ... returnedExpressions) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.with(distinct, returnedExpressions);
        }

        @Override
        @NotNull
        public Statement build() {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.buildImpl(null);
        }
    }

    private static abstract class AbstractUpdatingClauseBuilder<T extends UpdatingClause>
    implements UpdatingClauseBuilder {
        protected final List<PatternElement> patternElements;

        AbstractUpdatingClauseBuilder(List<PatternElement> patternElements) {
            this.patternElements = patternElements;
        }

        abstract Function<Pattern, T> getUpdatingClauseProvider();

        public T build() {
            return (T)((UpdatingClause)this.getUpdatingClauseProvider().apply(new Pattern(this.patternElements)));
        }

        static class MergeBuilder
        extends AbstractUpdatingClauseBuilder<Merge>
        implements SupportsActionsOnTheUpdatingClause {
            private final List<MergeAction> mergeActions = new ArrayList<MergeAction>();

            MergeBuilder(List<PatternElement> patternElements) {
                super(patternElements);
            }

            @Override
            Function<Pattern, Merge> getUpdatingClauseProvider() {
                return pattern -> new Merge((Pattern)pattern, this.mergeActions);
            }

            @Override
            public SupportsActionsOnTheUpdatingClause on(MergeAction.Type type, UpdateType updateType, Expression ... expressions) {
                ExpressionList expressionList = new ExpressionList(DefaultStatementBuilder.prepareSetExpressions(updateType, Arrays.asList(expressions)));
                this.mergeActions.add(new MergeAction(type, new Set(expressionList)));
                return this;
            }
        }

        static class CreateBuilder
        extends AbstractUpdatingClauseBuilder<Create> {
            CreateBuilder(List<PatternElement> patternElements) {
                super(patternElements);
            }

            @Override
            Function<Pattern, Create> getUpdatingClauseProvider() {
                return Create::new;
            }
        }
    }

    static interface SupportsActionsOnTheUpdatingClause {
        public SupportsActionsOnTheUpdatingClause on(MergeAction.Type var1, UpdateType var2, Expression ... var3);
    }

    private static interface UpdatingClauseBuilder {
        public UpdatingClause build();
    }

    static enum UpdateType {
        DELETE,
        DETACH_DELETE,
        SET,
        MUTATE,
        REMOVE,
        CREATE,
        MERGE;

    }

    protected final class DefaultStatementWithWithBuilder
    implements StatementBuilder.OngoingOrderDefinition,
    StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere,
    StatementBuilder.OrderableOngoingReadingAndWithWithWhere,
    StatementBuilder.OngoingReadingAndWithWithWhereAndOrder,
    StatementBuilder.OngoingReadingAndWithWithSkip {
        protected final ConditionBuilder conditionBuilder = new ConditionBuilder();
        protected final List<Expression> returnList = new ArrayList<Expression>();
        protected final OrderBuilder orderBuilder = new OrderBuilder();
        protected boolean distinct;

        protected DefaultStatementWithWithBuilder(boolean distinct) {
            this.distinct = distinct;
        }

        protected Optional<With> buildWith() {
            if (this.returnList.isEmpty()) {
                return Optional.empty();
            }
            ExpressionList returnItems = new ExpressionList(this.returnList);
            Where where = this.conditionBuilder.buildCondition().map(Where::new).orElse(null);
            Optional<With> returnedWith = Optional.of(new With(this.distinct, returnItems, this.orderBuilder.buildOrder().orElse(null), this.orderBuilder.getSkip(), this.orderBuilder.getLimit(), where));
            this.returnList.clear();
            this.orderBuilder.reset();
            return returnedWith;
        }

        protected void addExpressions(Expression ... expressions) {
            Assertions.notNull(expressions, "Expressions to return are required.");
            Assertions.notEmpty(expressions, "At least one expressions to return is required.");
            this.returnList.addAll(Arrays.asList(expressions));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returning(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Collection<Expression> expressions) {
            return this.returning(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returningDistinct(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<Expression> expressions) {
            return this.returningDistinct(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returningRaw(rawExpression);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate delete(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).delete(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate delete(Collection<Expression> expressions) {
            return this.delete(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate detachDelete(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).detachDelete(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate detachDelete(Collection<Expression> expressions) {
            return this.detachDelete(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).set(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Collection<Expression> expressions) {
            return this.set(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, String ... labels) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).set(node, labels);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, Collection<String> labels) {
            return this.set(node, labels.toArray(new String[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate mutate(Expression target, Expression properties) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).mutate(target, properties);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, String ... labels) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).remove(node, labels);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, Collection<String> labels) {
            return this.remove(node, labels.toArray(new String[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Property ... properties) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).remove(properties);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Collection<Property> properties) {
            return this.remove(properties.toArray(new Property[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).with(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<Expression> expressions) {
            return this.with(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).withDistinct(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<Expression> expressions) {
            return this.withDistinct(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere where(@NotNull Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere and(Condition additionalCondition) {
            this.conditionBuilder.and(additionalCondition);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere or(Condition additionalCondition) {
            this.conditionBuilder.or(additionalCondition);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).match(optional, pattern);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).create(pattern);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate create(Collection<PatternElement> pattern) {
            return this.create(pattern.toArray(new PatternElement[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).merge(pattern);
        }

        @Override
        public StatementBuilder.OngoingUnwind unwind(Expression expression) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).unwind(expression);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithoutWhere call(Statement statement) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).call(statement);
        }

        @Override
        @NotNull
        public InQueryCallBuilder call(String ... namespaceAndProcedure) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).call(namespaceAndProcedure);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderBy(SortItem ... sortItem) {
            this.orderBuilder.orderBy(sortItem);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderBy(Collection<SortItem> sortItem) {
            return this.orderBy(sortItem.toArray(new SortItem[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingOrderDefinition orderBy(@NotNull Expression expression) {
            this.orderBuilder.orderBy(expression);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingOrderDefinition and(@NotNull Expression expression) {
            this.orderBuilder.and(expression);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWithWithWhereAndOrder descending() {
            this.orderBuilder.descending();
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWithWithWhereAndOrder ascending() {
            this.orderBuilder.ascending();
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWithWithSkip skip(Number number) {
            return this.skip(number == null ? null : new NumberLiteral(number));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWithWithSkip skip(Expression expression) {
            this.orderBuilder.skip(expression);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWith limit(Number number) {
            return this.limit(number == null ? null : new NumberLiteral(number));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWith limit(Expression expression) {
            this.orderBuilder.limit(expression);
            return this;
        }

        @Override
        @NotNull
        public LoadCSVStatementBuilder.OngoingLoadCSV loadCSV(URI from, boolean withHeaders) {
            DefaultStatementBuilder $this = DefaultStatementBuilder.this.addWith(this.buildWith());
            return new DefaultLoadCSVStatementBuilder.PrepareLoadCSVStatementImpl(from, withHeaders, $this);
        }
    }

    protected class DefaultStatementWithReturnBuilder
    implements StatementBuilder.OngoingReadingAndReturn,
    StatementBuilder.TerminalOngoingOrderDefinition,
    StatementBuilder.OngoingMatchAndReturnWithOrder {
        protected final List<Expression> returnList = new ArrayList<Expression>();
        protected final OrderBuilder orderBuilder = new OrderBuilder();
        protected boolean rawReturn;
        protected boolean distinct;

        protected DefaultStatementWithReturnBuilder(boolean rawReturn, boolean distinct) {
            this.distinct = distinct;
            this.rawReturn = rawReturn;
        }

        @Override
        @NotNull
        public final StatementBuilder.OngoingMatchAndReturnWithOrder orderBy(SortItem ... sortItem) {
            this.orderBuilder.orderBy(sortItem);
            return this;
        }

        @Override
        @NotNull
        public final StatementBuilder.OngoingMatchAndReturnWithOrder orderBy(Collection<SortItem> sortItem) {
            return this.orderBy(sortItem.toArray(new SortItem[0]));
        }

        @Override
        @NotNull
        public final StatementBuilder.TerminalOngoingOrderDefinition orderBy(@NotNull Expression expression) {
            this.orderBuilder.orderBy(expression);
            return this;
        }

        @Override
        @NotNull
        public final StatementBuilder.TerminalOngoingOrderDefinition and(@NotNull Expression expression) {
            this.orderBuilder.and(expression);
            return this;
        }

        @Override
        @NotNull
        public final DefaultStatementWithReturnBuilder descending() {
            this.orderBuilder.descending();
            return this;
        }

        @Override
        @NotNull
        public final DefaultStatementWithReturnBuilder ascending() {
            this.orderBuilder.ascending();
            return this;
        }

        @Override
        @NotNull
        public final StatementBuilder.OngoingReadingAndReturn skip(Number number) {
            return this.skip(number == null ? null : new NumberLiteral(number));
        }

        @Override
        @NotNull
        public final StatementBuilder.OngoingReadingAndReturn skip(Expression expression) {
            this.orderBuilder.skip(expression);
            return this;
        }

        @NotNull
        public final StatementBuilder.OngoingReadingAndReturn limit(Number number) {
            return this.limit(number == null ? null : new NumberLiteral(number));
        }

        @NotNull
        public final StatementBuilder.OngoingReadingAndReturn limit(Expression expression) {
            this.orderBuilder.limit(expression);
            return this;
        }

        @Override
        @NotNull
        public ResultStatement build() {
            Return returning = Return.create(this.rawReturn, this.distinct, this.returnList, this.orderBuilder);
            return (ResultStatement)DefaultStatementBuilder.this.buildImpl(returning);
        }

        protected final void addExpressions(Expression ... expressions) {
            Assertions.notNull(expressions, "Expressions to return are required.");
            Assertions.notEmpty(expressions, "At least one expressions to return is required.");
            this.returnList.addAll(Arrays.asList(expressions));
        }
    }
}

