/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.DecoratedQuery;
import org.neo4j.cypherdsl.core.ExposesCall;
import org.neo4j.cypherdsl.core.ExposesCreate;
import org.neo4j.cypherdsl.core.ExposesHints;
import org.neo4j.cypherdsl.core.ExposesLogicalOperators;
import org.neo4j.cypherdsl.core.ExposesMatch;
import org.neo4j.cypherdsl.core.ExposesMerge;
import org.neo4j.cypherdsl.core.ExposesReturning;
import org.neo4j.cypherdsl.core.ExposesSubqueryCall;
import org.neo4j.cypherdsl.core.ExposesUnwind;
import org.neo4j.cypherdsl.core.ExposesWhere;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.RelationshipPatternCondition;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.utils.Assertions;
import org.neo4j.cypherdsl.core.utils.CheckReturnValue;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public interface StatementBuilder
extends ExposesMatch,
ExposesCreate,
ExposesMerge,
ExposesUnwind,
ExposesReturning,
ExposesSubqueryCall {
    @NotNull
    @CheckReturnValue
    public OrderableOngoingReadingAndWithWithoutWhere with(String ... var1);

    @NotNull
    @CheckReturnValue
    public OrderableOngoingReadingAndWithWithoutWhere with(Named ... var1);

    @NotNull
    @CheckReturnValue
    public OrderableOngoingReadingAndWithWithoutWhere with(Expression ... var1);

    public static interface OngoingMergeAction {
        @NotNull
        @CheckReturnValue
        public BuildableOngoingMergeAction set(Expression ... var1);

        @NotNull
        @CheckReturnValue
        default public BuildableOngoingMergeAction set(Named variable, Expression expression) {
            return this.set(variable.getRequiredSymbolicName(), expression);
        }

        @NotNull
        @CheckReturnValue
        public BuildableOngoingMergeAction mutate(Expression var1, Expression var2);

        @NotNull
        @CheckReturnValue
        default public BuildableOngoingMergeAction mutate(Named variable, Expression properties) {
            return this.mutate(variable.getRequiredSymbolicName(), properties);
        }
    }

    public static interface BuildableOngoingMergeAction
    extends BuildableMatchAndUpdate,
    ExposesMergeAction {
    }

    public static interface ExposesMergeAction {
        @NotNull
        @CheckReturnValue
        public OngoingMergeAction onCreate();

        @NotNull
        @CheckReturnValue
        public OngoingMergeAction onMatch();
    }

    public static interface BuildableMatchAndUpdate
    extends OngoingMatchAndUpdate,
    BuildableStatement {
    }

    public static interface OngoingMatchAndUpdate
    extends ExposesReturning,
    ExposesWith,
    ExposesUpdatingClause,
    ExposesCreate {
    }

    public static interface ExposesSetAndRemove
    extends ExposesSet {
        @NotNull
        @CheckReturnValue
        public BuildableMatchAndUpdate set(Node var1, String ... var2);

        @NotNull
        @CheckReturnValue
        public BuildableMatchAndUpdate remove(Node var1, String ... var2);

        @NotNull
        @CheckReturnValue
        public BuildableMatchAndUpdate remove(Property ... var1);
    }

    public static interface ExposesSet {
        @NotNull
        @CheckReturnValue
        public BuildableMatchAndUpdate set(Expression ... var1);

        @NotNull
        @CheckReturnValue
        default public BuildableMatchAndUpdate set(Named variable, Expression expression) {
            return this.set(variable.getRequiredSymbolicName(), expression);
        }

        @NotNull
        @CheckReturnValue
        public BuildableMatchAndUpdate mutate(Expression var1, Expression var2);

        @NotNull
        @CheckReturnValue
        default public BuildableMatchAndUpdate mutate(Named variable, Expression properties) {
            return this.mutate(variable.getRequiredSymbolicName(), properties);
        }
    }

    public static interface ExposesDelete {
        @NotNull
        @CheckReturnValue
        default public OngoingUpdate delete(String ... variables) {
            return this.delete(Expressions.createSymbolicNames(variables));
        }

        @NotNull
        @CheckReturnValue
        default public OngoingUpdate delete(Named ... variables) {
            return this.delete(Expressions.createSymbolicNames(variables));
        }

        @NotNull
        @CheckReturnValue
        public OngoingUpdate delete(Expression ... var1);

        @NotNull
        @CheckReturnValue
        default public OngoingUpdate detachDelete(String ... variables) {
            return this.detachDelete(Expressions.createSymbolicNames(variables));
        }

        @NotNull
        @CheckReturnValue
        default public OngoingUpdate detachDelete(Named ... variables) {
            return this.detachDelete(Expressions.createSymbolicNames(variables));
        }

        @NotNull
        @CheckReturnValue
        public OngoingUpdate detachDelete(Expression ... var1);
    }

    public static interface ExposesUpdatingClause
    extends ExposesDelete,
    ExposesMerge,
    ExposesSetAndRemove {
    }

    public static interface ExposesLimit {
        @NotNull
        @CheckReturnValue
        public OngoingReadingAndWith limit(Number var1);

        @NotNull
        @CheckReturnValue
        public OngoingReadingAndWith limit(Expression var1);
    }

    public static interface ExposesSkip {
        @NotNull
        @CheckReturnValue
        public OngoingReadingAndWithWithSkip skip(Number var1);

        @NotNull
        @CheckReturnValue
        public OngoingReadingAndWithWithSkip skip(Expression var1);
    }

    public static interface OngoingReadingAndWithWithSkip
    extends OngoingReadingAndWith,
    ExposesLimit {
    }

    public static interface ExposesOrderBy {
        @NotNull
        @CheckReturnValue
        public OrderableOngoingReadingAndWithWithWhere orderBy(SortItem ... var1);

        @NotNull
        @CheckReturnValue
        public OngoingOrderDefinition orderBy(@NotNull Expression var1);
    }

    public static interface TerminalExposesLimit
    extends BuildableStatement {
        @NotNull
        @CheckReturnValue
        public BuildableStatement limit(Number var1);

        @NotNull
        @CheckReturnValue
        public BuildableStatement limit(Expression var1);
    }

    public static interface TerminalExposesSkip {
        @NotNull
        @CheckReturnValue
        public TerminalExposesLimit skip(Number var1);

        @NotNull
        @CheckReturnValue
        public TerminalExposesLimit skip(Expression var1);
    }

    public static interface TerminalExposesOrderBy {
        @NotNull
        @CheckReturnValue
        public OngoingMatchAndReturnWithOrder orderBy(SortItem ... var1);

        @NotNull
        @CheckReturnValue
        public TerminalOngoingOrderDefinition orderBy(@NotNull Expression var1);
    }

    public static interface ExposesWith {
        @NotNull
        @CheckReturnValue
        default public OrderableOngoingReadingAndWithWithoutWhere with(String ... variables) {
            return this.with(Expressions.createSymbolicNames(variables));
        }

        @NotNull
        @CheckReturnValue
        default public OrderableOngoingReadingAndWithWithoutWhere with(Named ... variables) {
            return this.with(Expressions.createSymbolicNames(variables));
        }

        @NotNull
        @CheckReturnValue
        public OrderableOngoingReadingAndWithWithoutWhere with(Expression ... var1);

        @NotNull
        @CheckReturnValue
        default public OrderableOngoingReadingAndWithWithoutWhere withDistinct(String ... variables) {
            return this.withDistinct(Expressions.createSymbolicNames(variables));
        }

        @NotNull
        @CheckReturnValue
        default public OrderableOngoingReadingAndWithWithoutWhere withDistinct(Named ... variables) {
            return this.withDistinct(Expressions.createSymbolicNames(variables));
        }

        @NotNull
        @CheckReturnValue
        public OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... var1);
    }

    public static interface BuildableStatement {
        @NotNull
        @Contract(pure=true)
        public Statement build();

        @NotNull
        @Contract(pure=true)
        default public Statement explain() {
            return DecoratedQuery.explain(this.build());
        }

        @NotNull
        @Contract(pure=true)
        default public Statement profile() {
            return DecoratedQuery.profile(this.build());
        }
    }

    public static interface OngoingOrderDefinition
    extends ExposesSkip,
    ExposesLimit {
        @NotNull
        @CheckReturnValue
        public OngoingReadingAndWithWithWhereAndOrder descending();

        @NotNull
        @CheckReturnValue
        public OngoingReadingAndWithWithWhereAndOrder ascending();
    }

    public static interface OngoingReadingAndWithWithWhereAndOrder
    extends ExposesSkip,
    ExposesLimit,
    OngoingReadingAndWith {
        @NotNull
        @CheckReturnValue
        public OngoingOrderDefinition and(@NotNull Expression var1);
    }

    public static interface TerminalOngoingOrderDefinition
    extends TerminalExposesSkip,
    TerminalExposesLimit,
    BuildableStatement {
        @NotNull
        @CheckReturnValue
        public OngoingMatchAndReturnWithOrder descending();

        @NotNull
        @CheckReturnValue
        public OngoingMatchAndReturnWithOrder ascending();
    }

    public static interface OngoingMatchAndReturnWithOrder
    extends TerminalExposesSkip,
    TerminalExposesLimit,
    BuildableStatement {
        @NotNull
        @CheckReturnValue
        public TerminalOngoingOrderDefinition and(@NotNull Expression var1);
    }

    public static interface OrderableOngoingReadingAndWith
    extends ExposesOrderBy,
    ExposesSkip,
    ExposesLimit,
    OngoingReadingAndWith {
    }

    public static interface OngoingReadingAndWith
    extends OngoingReading,
    ExposesMatch {
    }

    public static interface OrderableOngoingReadingAndWithWithWhere
    extends OrderableOngoingReadingAndWith,
    ExposesLogicalOperators<OrderableOngoingReadingAndWithWithWhere> {
    }

    public static interface OrderableOngoingReadingAndWithWithoutWhere
    extends OrderableOngoingReadingAndWith {
        @NotNull
        @CheckReturnValue
        public OrderableOngoingReadingAndWithWithWhere where(@NotNull Condition var1);

        @NotNull
        @CheckReturnValue
        default public OrderableOngoingReadingAndWithWithWhere where(@NotNull RelationshipPattern pathPattern) {
            Assertions.notNull(pathPattern, "The path pattern must not be null.");
            return this.where(new RelationshipPatternCondition(pathPattern));
        }
    }

    public static interface OngoingReadingAndReturn
    extends TerminalExposesOrderBy,
    TerminalExposesSkip,
    TerminalExposesLimit,
    BuildableStatement {
    }

    public static interface OngoingUnwind {
        @NotNull
        @CheckReturnValue
        public OngoingReading as(@NotNull String var1);

        @NotNull
        @CheckReturnValue
        default public OngoingReading as(SymbolicName variable) {
            return this.as(variable.getValue());
        }
    }

    public static interface OngoingReading
    extends ExposesReturning,
    ExposesWith,
    ExposesUpdatingClause,
    ExposesUnwind,
    ExposesCreate,
    ExposesCall<ProcedureCall.OngoingInQueryCallWithoutArguments>,
    ExposesSubqueryCall {
    }

    public static interface OngoingReadingWithWhere
    extends OngoingReading,
    ExposesMatch,
    ExposesLogicalOperators<OngoingReadingWithWhere>,
    ExposesExistentialSubqueryCall {
    }

    public static interface OngoingReadingWithoutWhere
    extends OngoingReading,
    ExposesHints,
    ExposesWhere,
    ExposesMatch,
    ExposesExistentialSubqueryCall {
    }

    public static interface ExposesExistentialSubqueryCall {
        @Neo4jVersion(minimum="4.0.0")
        @NotNull
        @Contract(pure=true)
        public Condition asCondition();
    }

    public static interface OngoingMerge
    extends OngoingUpdate,
    ExposesMergeAction {
    }

    public static interface OngoingUpdate
    extends BuildableStatement,
    ExposesCreate,
    ExposesMerge,
    ExposesDelete,
    ExposesReturning,
    ExposesWith,
    ExposesSet {
    }
}

