/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.CompoundCondition;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Delete;
import org.neo4j.cypherdsl.core.ExistentialSubquery;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.Hint;
import org.neo4j.cypherdsl.core.Limit;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.MultiPartElement;
import org.neo4j.cypherdsl.core.MultiPartQuery;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Remove;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.SinglePartQuery;
import org.neo4j.cypherdsl.core.Skip;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Unwind;
import org.neo4j.cypherdsl.core.UpdatingClause;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.internal.ProcedureName;
import org.neo4j.cypherdsl.core.internal.YieldItems;
import org.neo4j.cypherdsl.core.utils.Assertions;

class DefaultStatementBuilder
implements StatementBuilder,
StatementBuilder.OngoingUpdate,
StatementBuilder.OngoingMerge,
StatementBuilder.OngoingReadingWithWhere,
StatementBuilder.OngoingReadingWithoutWhere,
StatementBuilder.OngoingMatchAndUpdate,
StatementBuilder.BuildableMatchAndUpdate,
StatementBuilder.BuildableOngoingMergeAction {
    private final List<Visitable> currentSinglePartElements = new ArrayList<Visitable>();
    private MatchBuilder currentOngoingMatch;
    private DefaultStatementWithUpdateBuilder currentOngoingUpdate;
    private final List<MultiPartElement> multiPartElements = new ArrayList<MultiPartElement>();
    private ProcedureCall.Builder currentOngoingCall;
    private static final EnumSet<UpdateType> MERGE_OR_CREATE = EnumSet.of(UpdateType.CREATE, UpdateType.MERGE);
    private static final EnumSet<UpdateType> SET = EnumSet.of(UpdateType.SET, UpdateType.MUTATE);

    DefaultStatementBuilder() {
    }

    DefaultStatementBuilder(ProcedureCall.Builder currentOngoingCall) {
        this.currentOngoingCall = currentOngoingCall;
    }

    @Override
    public StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
        Assertions.notNull(pattern, "Patterns to match are required.");
        Assertions.notEmpty(pattern, "At least one pattern to match is required.");
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingCall();
        this.currentOngoingMatch = new MatchBuilder(optional);
        this.currentOngoingMatch.patternList.addAll(Arrays.asList(pattern));
        return this;
    }

    @Override
    public StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
        return this.update(UpdateType.CREATE, pattern);
    }

    @Override
    public StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
        return this.update(UpdateType.MERGE, pattern);
    }

    @Override
    public StatementBuilder.OngoingMergeAction onCreate() {
        return this.ongoingOnAfterMerge(MergeAction.Type.ON_CREATE);
    }

    @Override
    public StatementBuilder.OngoingMergeAction onMatch() {
        return this.ongoingOnAfterMerge(MergeAction.Type.ON_MATCH);
    }

    private StatementBuilder.OngoingMergeAction ongoingOnAfterMerge(final MergeAction.Type type) {
        Assertions.notNull(this.currentOngoingUpdate, "MERGE must have been invoked before defining an event.");
        Assertions.isTrue(this.currentOngoingUpdate.builder instanceof SupportsActionsOnTheUpdatingClause, "MERGE must have been invoked before defining an event.");
        return new StatementBuilder.OngoingMergeAction(){

            @Override
            public StatementBuilder.BuildableOngoingMergeAction mutate(Expression target, Expression properties) {
                ((SupportsActionsOnTheUpdatingClause)((Object)((DefaultStatementBuilder)DefaultStatementBuilder.this).currentOngoingUpdate.builder)).on(type, UpdateType.MUTATE, target, properties);
                return DefaultStatementBuilder.this;
            }

            @Override
            public StatementBuilder.BuildableOngoingMergeAction set(Expression ... expressions) {
                ((SupportsActionsOnTheUpdatingClause)((Object)((DefaultStatementBuilder)DefaultStatementBuilder.this).currentOngoingUpdate.builder)).on(type, UpdateType.SET, expressions);
                return DefaultStatementBuilder.this;
            }
        };
    }

    @Override
    public StatementBuilder.OngoingUnwind unwind(Expression expression) {
        this.closeCurrentOngoingMatch();
        return new DefaultOngoingUnwind(expression);
    }

    private DefaultStatementBuilder update(UpdateType updateType, Object[] pattern) {
        Assertions.notNull(pattern, "Patterns to create are required.");
        Assertions.notEmpty(pattern, "At least one pattern to create is required.");
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingCall();
        this.closeCurrentOngoingUpdate();
        if (pattern.getClass().getComponentType() == PatternElement.class) {
            this.currentOngoingUpdate = new DefaultStatementWithUpdateBuilder(updateType, (PatternElement[])pattern);
        } else if (pattern.getClass().getComponentType() == Expression.class) {
            this.currentOngoingUpdate = new DefaultStatementWithUpdateBuilder(updateType, (Expression[])pattern);
        }
        return this;
    }

    @Override
    public StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
        return this.returning(false, expressions);
    }

    @Override
    public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
        return this.returning(true, expressions);
    }

    private StatementBuilder.OngoingReadingAndReturn returning(boolean distinct, Expression ... expressions) {
        DefaultStatementWithReturnBuilder ongoingMatchAndReturn = new DefaultStatementWithReturnBuilder(distinct);
        ongoingMatchAndReturn.addExpressions(expressions);
        return ongoingMatchAndReturn;
    }

    @Override
    public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(String ... variables) {
        return this.with(false, Expressions.createSymbolicNames(variables));
    }

    @Override
    public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Named ... variables) {
        return this.with(false, Expressions.createSymbolicNames(variables));
    }

    @Override
    public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
        return this.with(false, expressions);
    }

    @Override
    public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... expressions) {
        return this.with(true, expressions);
    }

    private StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(boolean distinct, Expression ... expressions) {
        DefaultStatementWithWithBuilder ongoingMatchAndWith = new DefaultStatementWithWithBuilder(distinct);
        ongoingMatchAndWith.addExpressions(expressions);
        return ongoingMatchAndWith;
    }

    @Override
    public StatementBuilder.OngoingUpdate delete(Expression ... expressions) {
        return this.update(UpdateType.DELETE, expressions);
    }

    @Override
    public StatementBuilder.OngoingUpdate detachDelete(Expression ... expressions) {
        return this.update(UpdateType.DETACH_DELETE, expressions);
    }

    @Override
    public StatementBuilder.BuildableMatchAndUpdate set(Expression ... expressions) {
        this.closeCurrentOngoingUpdate();
        return new DefaultStatementWithUpdateBuilder(UpdateType.SET, expressions);
    }

    @Override
    public StatementBuilder.BuildableMatchAndUpdate set(Node named, String ... labels) {
        return new DefaultStatementWithUpdateBuilder(UpdateType.SET, Operations.set(named, labels));
    }

    @Override
    public StatementBuilder.BuildableMatchAndUpdate mutate(Expression target, Expression properties) {
        this.closeCurrentOngoingUpdate();
        return new DefaultStatementWithUpdateBuilder(UpdateType.MUTATE, Operations.mutate(target, properties));
    }

    @Override
    public StatementBuilder.BuildableMatchAndUpdate remove(Property ... properties) {
        return new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, properties);
    }

    @Override
    public StatementBuilder.BuildableMatchAndUpdate remove(Node named, String ... labels) {
        return new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, Operations.remove(named, labels));
    }

    @Override
    public StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
        this.currentOngoingMatch.conditionBuilder.where(newCondition);
        return this;
    }

    @Override
    public StatementBuilder.OngoingReadingWithWhere and(Condition additionalCondition) {
        this.currentOngoingMatch.conditionBuilder.and(additionalCondition);
        return this;
    }

    @Override
    public StatementBuilder.OngoingReadingWithWhere or(Condition additionalCondition) {
        this.currentOngoingMatch.conditionBuilder.or(additionalCondition);
        return this;
    }

    @Override
    public Statement build() {
        return this.buildImpl(false, null);
    }

    protected Statement buildImpl(boolean clearCurrentBuildSteps, Return returning) {
        SinglePartQuery singlePartQuery = SinglePartQuery.create(this.buildListOfVisitables(clearCurrentBuildSteps), returning);
        if (this.multiPartElements.isEmpty()) {
            return singlePartQuery;
        }
        return new MultiPartQuery(this.multiPartElements, singlePartQuery);
    }

    protected final List<Visitable> buildListOfVisitables(boolean clearAfter) {
        ArrayList<Visitable> visitables = new ArrayList<Visitable>(this.currentSinglePartElements);
        if (this.currentOngoingMatch != null) {
            visitables.add(this.currentOngoingMatch.buildMatch());
        }
        if (this.currentOngoingUpdate != null) {
            visitables.add(this.currentOngoingUpdate.builder.build());
        }
        if (this.currentOngoingCall != null) {
            visitables.add(this.currentOngoingCall.build());
        }
        if (clearAfter) {
            this.currentOngoingMatch = null;
            this.currentOngoingUpdate = null;
            this.currentOngoingCall = null;
            this.currentSinglePartElements.clear();
        }
        return visitables;
    }

    protected final DefaultStatementBuilder addWith(Optional<With> optionalWith) {
        optionalWith.ifPresent(with -> this.multiPartElements.add(new MultiPartElement(this.buildListOfVisitables(true), (With)with)));
        return this;
    }

    protected final DefaultStatementBuilder addUpdatingClause(UpdatingClause updatingClause) {
        this.closeCurrentOngoingMatch();
        this.currentSinglePartElements.add(updatingClause);
        return this;
    }

    @Override
    public StatementBuilder.OngoingReadingWithoutWhere call(Statement statement) {
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingCall();
        this.closeCurrentOngoingUpdate();
        this.currentSinglePartElements.add(Subquery.call(statement));
        return this;
    }

    private void closeCurrentOngoingMatch() {
        if (this.currentOngoingMatch == null) {
            return;
        }
        this.currentSinglePartElements.add(this.currentOngoingMatch.buildMatch());
        this.currentOngoingMatch = null;
    }

    private void closeCurrentOngoingCall() {
        if (this.currentOngoingCall == null) {
            return;
        }
        this.currentSinglePartElements.add(this.currentOngoingCall.build());
        this.currentOngoingCall = null;
    }

    private void closeCurrentOngoingUpdate() {
        if (this.currentOngoingUpdate == null) {
            return;
        }
        this.currentSinglePartElements.add(this.currentOngoingUpdate.builder.build());
        this.currentOngoingUpdate = null;
    }

    @Override
    public Condition asCondition() {
        if (this.currentOngoingMatch == null || !this.currentSinglePartElements.isEmpty()) {
            throw new IllegalArgumentException("Only simple MATCH statements can be used as existential subqueries.");
        }
        return ExistentialSubquery.exists(this.currentOngoingMatch.buildMatch());
    }

    @Override
    public StatementBuilder.OngoingReadingWithoutWhere usingIndex(Property ... properties) {
        this.currentOngoingMatch.hints.add(Hint.useIndexFor(false, properties));
        return this;
    }

    @Override
    public StatementBuilder.OngoingReadingWithoutWhere usingIndexSeek(Property ... properties) {
        this.currentOngoingMatch.hints.add(Hint.useIndexFor(true, properties));
        return this;
    }

    @Override
    public StatementBuilder.OngoingReadingWithoutWhere usingScan(Node node) {
        this.currentOngoingMatch.hints.add(Hint.useScanFor(node));
        return this;
    }

    @Override
    public StatementBuilder.OngoingReadingWithoutWhere usingJoinOn(SymbolicName ... names) {
        this.currentOngoingMatch.hints.add(Hint.useJoinOn(names));
        return this;
    }

    @SafeVarargs
    private static <T extends Visitable> UpdatingClauseBuilder getUpdatingClauseBuilder(UpdateType updateType, T ... patternOrExpressions) {
        boolean mergeOrCreate = MERGE_OR_CREATE.contains((Object)updateType);
        String message = mergeOrCreate ? "At least one pattern is required." : "At least one modifying expressions is required.";
        Assertions.notNull(patternOrExpressions, message);
        Assertions.notEmpty(patternOrExpressions, message);
        if (mergeOrCreate) {
            List<PatternElement> patternElements = Arrays.stream(patternOrExpressions).map(PatternElement.class::cast).collect(Collectors.toList());
            if (updateType == UpdateType.CREATE) {
                return new AbstractUpdatingClauseBuilder.CreateBuilder(patternElements);
            }
            return new AbstractUpdatingClauseBuilder.MergeBuilder(patternElements);
        }
        List<Expression> expressions = Arrays.stream(patternOrExpressions).map(Expression.class::cast).collect(Collectors.toList());
        ExpressionList expressionList = new ExpressionList(SET.contains((Object)updateType) ? DefaultStatementBuilder.prepareSetExpressions(updateType, expressions) : expressions);
        switch (updateType) {
            case DETACH_DELETE: {
                return () -> new Delete(expressionList, true);
            }
            case DELETE: {
                return () -> new Delete(expressionList, false);
            }
            case SET: 
            case MUTATE: {
                return () -> new Set(expressionList);
            }
            case REMOVE: {
                return () -> new Remove(expressionList);
            }
        }
        throw new IllegalArgumentException("Unsupported update type " + (Object)((Object)updateType));
    }

    private static List<Expression> prepareSetExpressions(UpdateType updateType, List<Expression> possibleSetOperations) {
        ArrayList<Expression> propertyOperations;
        block10: {
            ArrayList<Expression> listOfExpressions;
            block11: {
                block9: {
                    propertyOperations = new ArrayList<Expression>();
                    listOfExpressions = new ArrayList<Expression>();
                    for (Expression possibleSetOperation : possibleSetOperations) {
                        if (possibleSetOperation instanceof Operation) {
                            propertyOperations.add(possibleSetOperation);
                            continue;
                        }
                        listOfExpressions.add(possibleSetOperation);
                    }
                    if (listOfExpressions.size() % 2 != 0) {
                        throw new IllegalArgumentException("The list of expression to set must be even.");
                    }
                    if (updateType != UpdateType.SET) break block9;
                    for (int i = 0; i < listOfExpressions.size(); i += 2) {
                        propertyOperations.add(Operations.set((Expression)listOfExpressions.get(i), (Expression)listOfExpressions.get(i + 1)));
                    }
                    break block10;
                }
                if (updateType != UpdateType.MUTATE) break block10;
                if (!listOfExpressions.isEmpty() && !propertyOperations.isEmpty()) {
                    throw new IllegalArgumentException("A mutating SET must be build through a single operation or through a pair of expression, not both.");
                }
                if (!listOfExpressions.isEmpty()) break block11;
                for (Expression operation : propertyOperations) {
                    if (((Operation)operation).getOperator() == Operator.MUTATE) continue;
                    throw new IllegalArgumentException("Only property operations based on the " + Operator.MUTATE + " are supported inside a mutating SET.");
                }
                break block10;
            }
            if (!propertyOperations.isEmpty()) break block10;
            for (int i = 0; i < listOfExpressions.size(); i += 2) {
                Expression rhs = (Expression)listOfExpressions.get(i + 1);
                if (rhs instanceof Parameter) {
                    propertyOperations.add(Operations.mutate((Expression)listOfExpressions.get(i), (Parameter)rhs));
                    continue;
                }
                if (rhs instanceof MapExpression) {
                    propertyOperations.add(Operations.mutate((Expression)listOfExpressions.get(i), (MapExpression)rhs));
                    continue;
                }
                throw new IllegalArgumentException("A mutating SET operation can only be used with a named parameter or a map expression.");
            }
        }
        return propertyOperations;
    }

    @Override
    public InQueryCallBuilder call(String ... namespaceAndProcedure) {
        Assertions.notEmpty(namespaceAndProcedure, "The procedure namespace and name must not be null or empty.");
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingCall();
        InQueryCallBuilder inQueryCallBuilder = new InQueryCallBuilder(ProcedureName.from(namespaceAndProcedure));
        this.currentOngoingCall = inQueryCallBuilder;
        return inQueryCallBuilder;
    }

    static final class OrderBuilder {
        protected final List<SortItem> sortItemList = new ArrayList<SortItem>();
        protected SortItem lastSortItem;
        protected Skip skip;
        protected Limit limit;

        OrderBuilder() {
        }

        protected void reset() {
            this.sortItemList.clear();
            this.lastSortItem = null;
            this.skip = null;
            this.limit = null;
        }

        protected void orderBy(SortItem ... sortItem) {
            Arrays.stream(sortItem).forEach(this.sortItemList::add);
        }

        protected void orderBy(Expression expression) {
            this.lastSortItem = Cypher.sort(expression);
        }

        protected void and(Expression expression) {
            this.orderBy(expression);
        }

        protected void descending() {
            this.sortItemList.add(this.lastSortItem.descending());
            this.lastSortItem = null;
        }

        protected void ascending() {
            this.sortItemList.add(this.lastSortItem.ascending());
            this.lastSortItem = null;
        }

        protected void skip(Expression expression) {
            if (expression != null) {
                this.skip = Skip.create(expression);
            }
        }

        protected void limit(Expression expression) {
            if (expression != null) {
                this.limit = Limit.create(expression);
            }
        }

        protected Optional<Order> buildOrder() {
            if (this.lastSortItem != null) {
                this.sortItemList.add(this.lastSortItem);
            }
            Optional<Order> result = this.sortItemList.size() > 0 ? Optional.of(new Order(this.sortItemList)) : Optional.empty();
            this.sortItemList.clear();
            this.lastSortItem = null;
            return result;
        }

        protected Skip getSkip() {
            return this.skip;
        }

        protected Limit getLimit() {
            return this.limit;
        }
    }

    static final class ConditionBuilder {
        protected Condition condition;

        ConditionBuilder() {
        }

        void where(Condition newCondition) {
            Assertions.notNull(newCondition, "The new condition must not be null.");
            this.condition = newCondition;
        }

        void and(Condition additionalCondition) {
            this.condition = this.condition.and(additionalCondition);
        }

        void or(Condition additionalCondition) {
            this.condition = this.condition.or(additionalCondition);
        }

        private boolean hasCondition() {
            return this.condition != null && (!(this.condition instanceof CompoundCondition) || ((CompoundCondition)this.condition).hasConditions());
        }

        Optional<Condition> buildCondition() {
            return this.hasCondition() ? Optional.of(this.condition) : Optional.empty();
        }
    }

    private final class InQueryCallBuilder
    extends ProcedureCall.Builder
    implements ProcedureCall.OngoingInQueryCallWithoutArguments,
    ProcedureCall.OngoingInQueryCallWithArguments,
    ProcedureCall.OngoingInQueryCallWithReturnFields {
        InQueryCallBuilder(ProcedureName procedureName) {
            super(procedureName);
        }

        @Override
        public InQueryCallBuilder withArgs(Expression ... arguments) {
            this.arguments = arguments;
            return this;
        }

        @Override
        public InQueryCallBuilder yield(SymbolicName ... resultFields) {
            this.yieldItems = YieldItems.yieldAllOf(resultFields);
            return this;
        }

        @Override
        public InQueryCallBuilder yield(AliasedExpression ... aliasedResultFields) {
            this.yieldItems = YieldItems.yieldAllOf(aliasedResultFields);
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            DefaultStatementBuilder.this.currentOngoingCall = this;
            return DefaultStatementBuilder.this;
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
            DefaultStatementBuilder.this.currentOngoingCall = this;
            return DefaultStatementBuilder.this.returning(expressions);
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
            DefaultStatementBuilder.this.currentOngoingCall = this;
            return DefaultStatementBuilder.this.returningDistinct(expressions);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
            DefaultStatementBuilder.this.currentOngoingCall = this;
            return DefaultStatementBuilder.this.with(expressions);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... expressions) {
            DefaultStatementBuilder.this.currentOngoingCall = this;
            return DefaultStatementBuilder.this.withDistinct(expressions);
        }

        @Override
        public StatementBuilder.OngoingReadingWithoutWhere call(Statement statement) {
            DefaultStatementBuilder.this.currentOngoingCall = this;
            return DefaultStatementBuilder.this.call(statement);
        }
    }

    final class DefaultOngoingUnwind
    implements StatementBuilder.OngoingUnwind {
        private final Expression expressionToUnwind;

        DefaultOngoingUnwind(Expression expressionToUnwind) {
            this.expressionToUnwind = expressionToUnwind;
        }

        @Override
        public StatementBuilder.OngoingReading as(String variable) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(new Unwind(this.expressionToUnwind, variable));
            return DefaultStatementBuilder.this;
        }
    }

    static final class MatchBuilder {
        private final List<PatternElement> patternList = new ArrayList<PatternElement>();
        private final List<Hint> hints = new ArrayList<Hint>();
        private final ConditionBuilder conditionBuilder = new ConditionBuilder();
        private final boolean optional;

        MatchBuilder(boolean optional) {
            this.optional = optional;
        }

        Match buildMatch() {
            Pattern pattern = new Pattern(this.patternList);
            return new Match(this.optional, pattern, this.conditionBuilder.buildCondition().map(Where::new).orElse(null), this.hints);
        }
    }

    protected final class DefaultStatementWithUpdateBuilder
    extends DefaultStatementWithReturnBuilder
    implements StatementBuilder.BuildableMatchAndUpdate {
        final UpdatingClauseBuilder builder;

        protected DefaultStatementWithUpdateBuilder(UpdateType updateType, PatternElement ... pattern) {
            super(false);
            this.builder = DefaultStatementBuilder.getUpdatingClauseBuilder((UpdateType)updateType, (Visitable[])pattern);
        }

        protected DefaultStatementWithUpdateBuilder(UpdateType updateType, Expression ... expressions) {
            super(false);
            this.builder = DefaultStatementBuilder.getUpdatingClauseBuilder((UpdateType)updateType, (Visitable[])expressions);
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... returnedExpressions) {
            Assertions.notNull(returnedExpressions, "Expressions to return are required.");
            Assertions.notEmpty(returnedExpressions, "At least one expressions to return is required.");
            this.returnList.addAll(Arrays.asList(returnedExpressions));
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... returnedExpressions) {
            this.returning(returnedExpressions);
            this.distinct = true;
            return this;
        }

        @Override
        public StatementBuilder.OngoingUpdate delete(Expression ... deletedExpressions) {
            return this.delete(false, deletedExpressions);
        }

        @Override
        public StatementBuilder.OngoingUpdate detachDelete(Expression ... deletedExpressions) {
            return this.delete(true, deletedExpressions);
        }

        @Override
        public StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.merge(pattern);
        }

        private StatementBuilder.OngoingUpdate delete(boolean nextDetach, Expression ... deletedExpressions) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.update(nextDetach ? UpdateType.DETACH_DELETE : UpdateType.DELETE, deletedExpressions);
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate set(Expression ... keyValuePairs) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.SET, keyValuePairs);
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, String ... labels) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.SET, Operations.set(node, labels));
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate mutate(Expression target, Expression properties) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.MUTATE, Operations.mutate(target, properties));
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, String ... labels) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, Operations.set(node, labels));
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate remove(Property ... properties) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, properties);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... returnedExpressions) {
            return this.with(false, returnedExpressions);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... returnedExpressions) {
            return this.with(true, returnedExpressions);
        }

        @Override
        public StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.create(pattern);
        }

        private StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(boolean distinct, Expression ... returnedExpressions) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.with(distinct, returnedExpressions);
        }

        @Override
        public Statement build() {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return super.build();
        }
    }

    private static abstract class AbstractUpdatingClauseBuilder<T extends UpdatingClause>
    implements UpdatingClauseBuilder {
        protected final List<PatternElement> patternElements;

        AbstractUpdatingClauseBuilder(List<PatternElement> patternElements) {
            this.patternElements = patternElements;
        }

        abstract Function<Pattern, T> getUpdatingClauseProvider();

        public T build() {
            return (T)((UpdatingClause)this.getUpdatingClauseProvider().apply(new Pattern(this.patternElements)));
        }

        static class MergeBuilder
        extends AbstractUpdatingClauseBuilder<Merge>
        implements SupportsActionsOnTheUpdatingClause {
            private List<MergeAction> mergeActions = new ArrayList<MergeAction>();

            MergeBuilder(List<PatternElement> patternElements) {
                super(patternElements);
            }

            @Override
            Function<Pattern, Merge> getUpdatingClauseProvider() {
                return pattern -> new Merge((Pattern)pattern, this.mergeActions);
            }

            @Override
            public SupportsActionsOnTheUpdatingClause on(MergeAction.Type type, UpdateType updateType, Expression ... expressions) {
                ExpressionList expressionList = new ExpressionList(DefaultStatementBuilder.prepareSetExpressions(updateType, Arrays.asList(expressions)));
                this.mergeActions.add(new MergeAction(type, new Set(expressionList)));
                return this;
            }
        }

        static class CreateBuilder
        extends AbstractUpdatingClauseBuilder<Create> {
            CreateBuilder(List<PatternElement> patternElements) {
                super(patternElements);
            }

            @Override
            Function<Pattern, Create> getUpdatingClauseProvider() {
                return Create::new;
            }
        }
    }

    static interface SupportsActionsOnTheUpdatingClause {
        public SupportsActionsOnTheUpdatingClause on(MergeAction.Type var1, UpdateType var2, Expression ... var3);
    }

    private static interface UpdatingClauseBuilder {
        public UpdatingClause build();
    }

    static enum UpdateType {
        DELETE,
        DETACH_DELETE,
        SET,
        MUTATE,
        REMOVE,
        CREATE,
        MERGE;

    }

    protected final class DefaultStatementWithWithBuilder
    implements StatementBuilder.OngoingOrderDefinition,
    StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere,
    StatementBuilder.OrderableOngoingReadingAndWithWithWhere,
    StatementBuilder.OngoingReadingAndWithWithWhereAndOrder,
    StatementBuilder.OngoingReadingAndWithWithSkip {
        protected final ConditionBuilder conditionBuilder = new ConditionBuilder();
        protected final List<Expression> returnList = new ArrayList<Expression>();
        protected final OrderBuilder orderBuilder = new OrderBuilder();
        protected boolean distinct;

        protected DefaultStatementWithWithBuilder(boolean distinct) {
            this.distinct = distinct;
        }

        protected Optional<With> buildWith() {
            if (this.returnList.isEmpty()) {
                return Optional.empty();
            }
            ExpressionList returnItems = new ExpressionList(this.returnList);
            Where where = this.conditionBuilder.buildCondition().map(Where::new).orElse(null);
            Optional<With> returnedWith = Optional.of(new With(this.distinct, returnItems, this.orderBuilder.buildOrder().orElse(null), this.orderBuilder.getSkip(), this.orderBuilder.getLimit(), where));
            this.returnList.clear();
            this.orderBuilder.reset();
            return returnedWith;
        }

        protected void addExpressions(Expression ... expressions) {
            Assertions.notNull(expressions, "Expressions to return are required.");
            Assertions.notEmpty(expressions, "At least one expressions to return is required.");
            this.returnList.addAll(Arrays.asList(expressions));
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returning(expressions);
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returningDistinct(expressions);
        }

        @Override
        public StatementBuilder.OngoingUpdate delete(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).delete(expressions);
        }

        @Override
        public StatementBuilder.OngoingUpdate detachDelete(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).detachDelete(expressions);
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate set(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).set(expressions);
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, String ... labels) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).set(node, labels);
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate mutate(Expression target, Expression properties) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).mutate(target, properties);
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, String ... labels) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).remove(node, labels);
        }

        @Override
        public StatementBuilder.BuildableMatchAndUpdate remove(Property ... properties) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).remove(properties);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).with(expressions);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).withDistinct(expressions);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere where(Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            return this;
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere and(Condition additionalCondition) {
            this.conditionBuilder.and(additionalCondition);
            return this;
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere or(Condition additionalCondition) {
            this.conditionBuilder.or(additionalCondition);
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).match(optional, pattern);
        }

        @Override
        public StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).create(pattern);
        }

        @Override
        public StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).merge(pattern);
        }

        @Override
        public StatementBuilder.OngoingUnwind unwind(Expression expression) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).unwind(expression);
        }

        @Override
        public StatementBuilder.OngoingReadingWithoutWhere call(Statement statement) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).call(statement);
        }

        @Override
        public InQueryCallBuilder call(String ... namespaceAndProcedure) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).call(namespaceAndProcedure);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderBy(SortItem ... sortItem) {
            this.orderBuilder.orderBy(sortItem);
            return this;
        }

        @Override
        public StatementBuilder.OngoingOrderDefinition orderBy(Expression expression) {
            this.orderBuilder.orderBy(expression);
            return this;
        }

        @Override
        public StatementBuilder.OngoingOrderDefinition and(Expression expression) {
            this.orderBuilder.and(expression);
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingAndWithWithWhereAndOrder descending() {
            this.orderBuilder.descending();
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingAndWithWithWhereAndOrder ascending() {
            this.orderBuilder.ascending();
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingAndWithWithSkip skip(Number number) {
            return this.skip(number == null ? null : new NumberLiteral(number));
        }

        @Override
        public StatementBuilder.OngoingReadingAndWithWithSkip skip(Expression expression) {
            this.orderBuilder.skip(expression);
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingAndWith limit(Number number) {
            return this.limit(number == null ? null : new NumberLiteral(number));
        }

        @Override
        public StatementBuilder.OngoingReadingAndWith limit(Expression expression) {
            this.orderBuilder.limit(expression);
            return this;
        }
    }

    protected class DefaultStatementWithReturnBuilder
    implements StatementBuilder.OngoingReadingAndReturn,
    StatementBuilder.TerminalOngoingOrderDefinition,
    StatementBuilder.OngoingMatchAndReturnWithOrder {
        protected final List<Expression> returnList = new ArrayList<Expression>();
        protected final OrderBuilder orderBuilder = new OrderBuilder();
        protected boolean distinct;

        protected DefaultStatementWithReturnBuilder(boolean distinct) {
            this.distinct = distinct;
        }

        @Override
        public final StatementBuilder.OngoingMatchAndReturnWithOrder orderBy(SortItem ... sortItem) {
            this.orderBuilder.orderBy(sortItem);
            return this;
        }

        @Override
        public final StatementBuilder.TerminalOngoingOrderDefinition orderBy(Expression expression) {
            this.orderBuilder.orderBy(expression);
            return this;
        }

        @Override
        public final StatementBuilder.TerminalOngoingOrderDefinition and(Expression expression) {
            this.orderBuilder.and(expression);
            return this;
        }

        @Override
        public final DefaultStatementWithReturnBuilder descending() {
            this.orderBuilder.descending();
            return this;
        }

        @Override
        public final DefaultStatementWithReturnBuilder ascending() {
            this.orderBuilder.ascending();
            return this;
        }

        @Override
        public final StatementBuilder.OngoingReadingAndReturn skip(Number number) {
            return this.skip(number == null ? null : new NumberLiteral(number));
        }

        @Override
        public final StatementBuilder.OngoingReadingAndReturn skip(Expression expression) {
            this.orderBuilder.skip(expression);
            return this;
        }

        @Override
        public final StatementBuilder.OngoingReadingAndReturn limit(Number number) {
            return this.limit(number == null ? null : new NumberLiteral(number));
        }

        @Override
        public final StatementBuilder.OngoingReadingAndReturn limit(Expression expression) {
            this.orderBuilder.limit(expression);
            return this;
        }

        @Override
        public Statement build() {
            Return returning = null;
            if (!this.returnList.isEmpty()) {
                ExpressionList returnItems = new ExpressionList(this.returnList);
                returning = new Return(this.distinct, returnItems, this.orderBuilder.buildOrder().orElse(null), this.orderBuilder.getSkip(), this.orderBuilder.getLimit());
            }
            return DefaultStatementBuilder.this.buildImpl(false, returning);
        }

        protected final void addExpressions(Expression ... expressions) {
            Assertions.notNull(expressions, "Expressions to return are required.");
            Assertions.notEmpty(expressions, "At least one expressions to return is required.");
            this.returnList.addAll(Arrays.asList(expressions));
        }
    }
}

