/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractStatement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.INTERNAL, since="2020.1.2")
class DecoratedQuery
extends AbstractStatement
implements Statement {
    private final Decoration decoration;
    private final Statement target;

    static DecoratedQuery explain(Statement target) {
        return DecoratedQuery.decorate(target, Decoration.EXPLAIN);
    }

    static DecoratedQuery profile(Statement target) {
        return DecoratedQuery.decorate(target, Decoration.PROFILE);
    }

    private static DecoratedQuery decorate(Statement target, Decoration decoration) {
        if (target instanceof DecoratedQuery) {
            throw new IllegalArgumentException("Cannot explain an already explained or profiled query.");
        }
        return new DecoratedQuery(target, decoration);
    }

    private DecoratedQuery(Statement target, Decoration decoration) {
        this.decoration = decoration;
        this.target = target;
    }

    @Override
    public void accept(Visitor visitor) {
        this.decoration.accept(visitor);
        this.target.accept(visitor);
    }

    private static enum Decoration implements Visitable
    {
        EXPLAIN,
        PROFILE;

    }
}

