/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.NodeBase;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class InternalNodeImpl
extends NodeBase<InternalNodeImpl> {
    InternalNodeImpl(String primaryLabel, String ... additionalLabels) {
        super(primaryLabel, additionalLabels);
    }

    InternalNodeImpl(SymbolicName symbolicName, List<NodeLabel> labels, Properties properties) {
        super(symbolicName, labels, properties);
    }

    InternalNodeImpl() {
    }

    InternalNodeImpl(SymbolicName symbolicName, String primaryLabel, MapExpression properties, String ... additionalLabels) {
        super(symbolicName, primaryLabel, properties, additionalLabels);
    }

    @Override
    public InternalNodeImpl named(SymbolicName newSymbolicName) {
        Assertions.notNull(newSymbolicName, "Symbolic name is required.");
        return new InternalNodeImpl(newSymbolicName, this.labels, this.properties);
    }

    @Override
    public InternalNodeImpl withProperties(MapExpression newProperties) {
        return new InternalNodeImpl(this.getSymbolicName().orElse(null), this.labels, Properties.create(newProperties));
    }
}

