/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.LinkedList;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.RelationshipPatternCondition;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class RelationshipChain
implements RelationshipPattern {
    private final LinkedList<Relationship> relationships = new LinkedList();

    static RelationshipChain create(Relationship firstElement) {
        return new RelationshipChain().add(firstElement);
    }

    RelationshipChain add(Relationship element) {
        Assertions.notNull(element, "Elements of a relationship chain must not be null.");
        this.relationships.add(element);
        return this;
    }

    @Override
    public RelationshipChain relationshipTo(Node other, String ... types) {
        return this.add((Relationship)this.relationships.getLast().getRight().relationshipTo(other, types));
    }

    @Override
    public RelationshipChain relationshipFrom(Node other, String ... types) {
        return this.add((Relationship)this.relationships.getLast().getRight().relationshipFrom(other, types));
    }

    @Override
    public RelationshipChain relationshipBetween(Node other, String ... types) {
        return this.add((Relationship)this.relationships.getLast().getRight().relationshipBetween(other, types));
    }

    public RelationshipChain named(String newSymbolicName) {
        Relationship lastElement = this.relationships.removeLast();
        return this.add(lastElement.named(newSymbolicName));
    }

    public RelationshipChain unbounded() {
        Relationship lastElement = this.relationships.removeLast();
        return this.add(lastElement.unbounded());
    }

    public RelationshipChain min(Integer minimum) {
        Relationship lastElement = this.relationships.removeLast();
        return this.add(lastElement.min(minimum));
    }

    public RelationshipChain max(Integer maximum) {
        Relationship lastElement = this.relationships.removeLast();
        return this.add(lastElement.max(maximum));
    }

    public RelationshipChain length(Integer minimum, Integer maximum) {
        Relationship lastElement = this.relationships.removeLast();
        return this.add(lastElement.length(minimum, maximum));
    }

    public RelationshipChain properties(MapExpression newProperties) {
        Relationship lastElement = this.relationships.removeLast();
        return this.add((Relationship)lastElement.withProperties(newProperties));
    }

    public RelationshipChain properties(Object ... keysAndValues) {
        Relationship lastElement = this.relationships.removeLast();
        return this.add((Relationship)lastElement.withProperties(keysAndValues));
    }

    @Override
    public Condition asCondition() {
        return new RelationshipPatternCondition(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Node lastNode = null;
        for (Relationship relationship : this.relationships) {
            relationship.getLeft().accept(visitor);
            relationship.getDetails().accept(visitor);
            lastNode = relationship.getRight();
        }
        Visitable.visitIfNotNull(lastNode, visitor);
        visitor.leave(this);
    }
}

