/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.ExposesProperties;
import org.neo4j.cypherdsl.core.ExposesRelationships;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.HasLabelCondition;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Node
implements PatternElement,
PropertyContainer,
ExposesRelationships<Relationship>,
ExposesProperties<Node> {
    private volatile SymbolicName symbolicName;
    private final List<NodeLabel> labels;
    private final Properties properties;

    static Node create(String primaryLabel, String ... additionalLabels) {
        return Node.create(primaryLabel, null, additionalLabels);
    }

    static Node create(String primaryLabel, MapExpression properties, String ... additionalLabels) {
        Assertions.hasText(primaryLabel, "A primary label is required.");
        for (String additionalLabel : additionalLabels) {
            Assertions.hasText(additionalLabel, "An empty label is not allowed.");
        }
        return new Node(primaryLabel, properties == null ? null : new Properties(properties), additionalLabels);
    }

    static Node create() {
        return new Node(null, null, new String[0]);
    }

    private Node(String primaryLabel, Properties properties, String ... additionalLabels) {
        this.symbolicName = null;
        this.labels = new ArrayList<NodeLabel>();
        if (primaryLabel != null && !primaryLabel.isEmpty()) {
            this.labels.add(new NodeLabel(primaryLabel));
        }
        this.labels.addAll(Arrays.stream(additionalLabels).map(NodeLabel::new).collect(Collectors.toList()));
        this.properties = properties;
    }

    private Node(SymbolicName symbolicName, Properties properties, List<NodeLabel> labels) {
        this.symbolicName = symbolicName;
        this.labels = new ArrayList<NodeLabel>(labels);
        this.properties = properties;
    }

    @API(status=API.Status.INTERNAL)
    List<NodeLabel> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public Node named(String newSymbolicName) {
        Assertions.hasText(newSymbolicName, "Symbolic name is required.");
        return new Node(SymbolicName.of(newSymbolicName), this.properties, this.labels);
    }

    public Node named(SymbolicName newSymbolicName) {
        Assertions.notNull(newSymbolicName, "Symbolic name is required.");
        return new Node(newSymbolicName, this.properties, this.labels);
    }

    @Override
    public Node withProperties(MapExpression newProperties) {
        return new Node(this.symbolicName, newProperties == null ? null : new Properties(newProperties), this.labels);
    }

    @Override
    public Node withProperties(Object ... keysAndValues) {
        MapExpression newProperties = null;
        if (keysAndValues != null && keysAndValues.length != 0) {
            newProperties = MapExpression.create(keysAndValues);
        }
        return this.withProperties(newProperties);
    }

    @Override
    public Optional<SymbolicName> getSymbolicName() {
        return Optional.ofNullable(this.symbolicName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymbolicName getRequiredSymbolicName() {
        SymbolicName requiredSymbolicName = this.symbolicName;
        if (requiredSymbolicName == null) {
            Node node = this;
            synchronized (node) {
                requiredSymbolicName = this.symbolicName;
                if (requiredSymbolicName == null) {
                    requiredSymbolicName = this.symbolicName = SymbolicName.unresolved();
                }
            }
        }
        return requiredSymbolicName;
    }

    public FunctionInvocation internalId() {
        return Functions.id(this);
    }

    public FunctionInvocation labels() {
        return Functions.labels(this);
    }

    @Override
    public Relationship relationshipTo(Node other, String ... types) {
        return Relationship.create(this, Relationship.Direction.LTR, other, types);
    }

    @Override
    public Relationship relationshipFrom(Node other, String ... types) {
        return Relationship.create(this, Relationship.Direction.RTL, other, types);
    }

    @Override
    public Relationship relationshipBetween(Node other, String ... types) {
        return Relationship.create(this, Relationship.Direction.UNI, other, types);
    }

    public Condition hasLabels(String ... labelsToQuery) {
        return HasLabelCondition.create(this.getSymbolicName().orElseThrow(() -> new IllegalStateException("Cannot query a node without a symbolic name.")), labelsToQuery);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Visitable.visitIfNotNull(this.symbolicName, visitor);
        this.labels.forEach(label -> label.accept(visitor));
        Visitable.visitIfNotNull(this.properties, visitor);
        visitor.leave(this);
    }

    public String toString() {
        return "Node{symbolicName=" + this.symbolicName + ", labels=" + this.labels + '}';
    }

    public Condition isEqualTo(Node otherNode) {
        return this.getRequiredSymbolicName().isEqualTo(otherNode.getRequiredSymbolicName());
    }

    public Condition isNotEqualTo(Node otherNode) {
        return this.getRequiredSymbolicName().isNotEqualTo(otherNode.getRequiredSymbolicName());
    }

    public Condition isNull() {
        return this.getRequiredSymbolicName().isNull();
    }

    public Condition isNotNull() {
        return this.getRequiredSymbolicName().isNotNull();
    }

    public SortItem descending() {
        return this.getRequiredSymbolicName().descending();
    }

    public SortItem ascending() {
        return this.getRequiredSymbolicName().ascending();
    }

    public AliasedExpression as(String alias) {
        return this.getRequiredSymbolicName().as(alias);
    }
}

