/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Map;
import java.util.Set;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.ParameterCollectingVisitor;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.renderer.Renderer;

@API(status=API.Status.INTERNAL, since="2021.0.0")
abstract class AbstractStatement
implements Statement {
    private volatile ParameterCollectingVisitor.ParameterInformation parameterInformation;
    private volatile String cypher;

    AbstractStatement() {
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.getParameterInformation().values;
    }

    public Set<String> getParameterNames() {
        return this.getParameterInformation().names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCypher() {
        String result = this.cypher;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.cypher;
                if (result == null) {
                    result = this.cypher = Renderer.getDefaultRenderer().render(this);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParameterCollectingVisitor.ParameterInformation getParameterInformation() {
        ParameterCollectingVisitor.ParameterInformation result = this.parameterInformation;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.parameterInformation;
                if (result == null) {
                    result = this.parameterInformation = AbstractStatement.collectParameters(this);
                }
            }
        }
        return result;
    }

    private static ParameterCollectingVisitor.ParameterInformation collectParameters(Statement statement) {
        ParameterCollectingVisitor parameterCollectingVisitor = new ParameterCollectingVisitor();
        statement.accept(parameterCollectingVisitor);
        return parameterCollectingVisitor.getResult();
    }
}

