/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipLength;
import org.neo4j.cypherdsl.core.RelationshipTypes;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.INTERNAL, since="1.0")
public final class RelationshipDetail
implements Visitable {
    private final Relationship.Direction direction;
    private final SymbolicName symbolicName;
    private final RelationshipTypes types;
    private final RelationshipLength length;
    private final Properties properties;

    static RelationshipDetail create(Relationship.Direction direction, SymbolicName symbolicName, RelationshipTypes types) {
        return new RelationshipDetail(direction, symbolicName, types, null, null);
    }

    private RelationshipDetail(Relationship.Direction direction, SymbolicName symbolicName, RelationshipTypes types, RelationshipLength length, Properties properties) {
        this.direction = direction;
        this.symbolicName = symbolicName;
        this.types = types;
        this.length = length;
        this.properties = properties;
    }

    public boolean hasContent() {
        return this.symbolicName != null || this.types != null || this.length != null || this.properties != null;
    }

    RelationshipDetail named(String newSymbolicName) {
        Assert.hasText(newSymbolicName, "Symbolic name is required.");
        return this.named(SymbolicName.create(newSymbolicName));
    }

    RelationshipDetail named(SymbolicName newSymbolicName) {
        Assert.notNull(newSymbolicName, "Symbolic name is required.");
        return new RelationshipDetail(this.direction, newSymbolicName, this.types, this.length, this.properties);
    }

    RelationshipDetail with(Properties newProperties) {
        return new RelationshipDetail(this.direction, this.symbolicName, this.types, this.length, newProperties);
    }

    RelationshipDetail unbounded() {
        return new RelationshipDetail(this.direction, this.symbolicName, this.types, new RelationshipLength(), this.properties);
    }

    RelationshipDetail min(Integer minimum) {
        if (minimum == null && (this.length == null || this.length.getMinimum() == null)) {
            return this;
        }
        RelationshipLength newLength = Optional.ofNullable(this.length).map(l -> new RelationshipLength(minimum, l.getMaximum())).orElseGet(() -> new RelationshipLength(minimum, null));
        return new RelationshipDetail(this.direction, this.symbolicName, this.types, newLength, this.properties);
    }

    RelationshipDetail max(Integer maximum) {
        if (maximum == null && (this.length == null || this.length.getMaximum() == null)) {
            return this;
        }
        RelationshipLength newLength = Optional.ofNullable(this.length).map(l -> new RelationshipLength(l.getMinimum(), maximum)).orElseGet(() -> new RelationshipLength(null, maximum));
        return new RelationshipDetail(this.direction, this.symbolicName, this.types, newLength, this.properties);
    }

    public Relationship.Direction getDirection() {
        return this.direction;
    }

    Optional<SymbolicName> getSymbolicName() {
        return Optional.ofNullable(this.symbolicName);
    }

    public RelationshipTypes getTypes() {
        return this.types;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Visitable.visitIfNotNull(this.symbolicName, visitor);
        Visitable.visitIfNotNull(this.types, visitor);
        Visitable.visitIfNotNull(this.length, visitor);
        Visitable.visitIfNotNull(this.properties, visitor);
        visitor.leave(this);
    }
}

