/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Arguments;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.DefaultStatementBuilder;
import org.neo4j.cypherdsl.core.ExposesCall;
import org.neo4j.cypherdsl.core.ExposesReturning;
import org.neo4j.cypherdsl.core.ExposesWhere;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ProcedureName;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.YieldItems;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;

public final class ProcedureCall
implements Visitable,
Statement {
    private final ProcedureName name;
    private final Arguments arguments;
    private final YieldItems yieldItems;
    private final Where optionalWhere;

    ProcedureCall(ProcedureName name, Arguments arguments, YieldItems yieldItems) {
        this(name, arguments, yieldItems, null);
    }

    ProcedureCall(ProcedureName name, Arguments arguments, YieldItems yieldItems, Where optionalWhere) {
        this.name = name;
        this.arguments = arguments == null ? new Arguments(new Expression[0]) : arguments;
        this.yieldItems = yieldItems;
        this.optionalWhere = optionalWhere;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.name.accept(visitor);
        Visitable.visitIfNotNull(this.arguments, visitor);
        Visitable.visitIfNotNull(this.yieldItems, visitor);
        Visitable.visitIfNotNull(this.optionalWhere, visitor);
        visitor.leave(this);
    }

    protected static final class StandaloneCallBuilder
    extends Builder
    implements OngoingStandaloneCallWithoutArguments,
    OngoingStandaloneCallWithArguments,
    OngoingStandaloneCallWithReturnFields {
        StandaloneCallBuilder(ProcedureName procedureName) {
            super(procedureName);
        }

        @Override
        public StandaloneCallBuilder withArgs(Expression ... arguments) {
            this.arguments = arguments;
            return this;
        }

        @Override
        public StandaloneCallBuilder yield(SymbolicName ... resultFields) {
            this.yieldItems = YieldItems.yieldAllOf((Expression[])resultFields);
            return this;
        }

        @Override
        public StandaloneCallBuilder yield(AliasedExpression ... aliasedResultFields) {
            this.yieldItems = YieldItems.yieldAllOf((Expression[])aliasedResultFields);
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            return new DefaultStatementBuilder(this);
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
            return new DefaultStatementBuilder(this).returning(expressions);
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
            return new DefaultStatementBuilder(this).returningDistinct(expressions);
        }
    }

    protected static abstract class Builder
    implements ExposesWhere,
    ExposesReturning,
    StatementBuilder.BuildableStatement {
        protected final ProcedureName procedureName;
        protected Expression[] arguments;
        protected YieldItems<?, ?> yieldItems;
        protected final DefaultStatementBuilder.ConditionBuilder conditionBuilder = new DefaultStatementBuilder.ConditionBuilder();

        Builder(ProcedureName procedureName) {
            this.procedureName = procedureName;
        }

        @Override
        public Statement build() {
            Arguments argumentsList = null;
            if (this.arguments != null && this.arguments.length > 0) {
                argumentsList = new Arguments(this.arguments);
            }
            return new ProcedureCall(this.procedureName, argumentsList, this.yieldItems, this.conditionBuilder.buildCondition().map(Where::new).orElse(null));
        }
    }

    static interface OngoingInQueryCallWithReturnFields
    extends ExposesWhere,
    ExposesReturning {
    }

    static interface OngoingInQueryCallWithArguments
    extends ExposesCall.ExposesYield<OngoingInQueryCallWithReturnFields> {
    }

    static interface OngoingInQueryCallWithoutArguments
    extends ExposesCall.ExposesWithArgs<OngoingInQueryCallWithArguments>,
    ExposesCall.ExposesYield<OngoingInQueryCallWithReturnFields> {
    }

    static interface OngoingStandaloneCallWithReturnFields
    extends StatementBuilder.BuildableStatement,
    ExposesWhere,
    ExposesReturning {
    }

    static interface OngoingStandaloneCallWithArguments
    extends StatementBuilder.BuildableStatement,
    ExposesCall.ExposesYield<OngoingStandaloneCallWithReturnFields> {
    }

    static interface OngoingStandaloneCallWithoutArguments
    extends StatementBuilder.BuildableStatement,
    ExposesCall.ExposesWithArgs<OngoingStandaloneCallWithArguments>,
    ExposesCall.ExposesYield<OngoingStandaloneCallWithReturnFields> {
    }
}

