/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.ExposesProperties;
import org.neo4j.cypherdsl.core.ExposesRelationships;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.HasLabelCondition;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Node
implements PatternElement,
PropertyContainer,
ExposesRelationships<Relationship>,
ExposesProperties<Node> {
    private final SymbolicName symbolicName;
    private final List<NodeLabel> labels;
    private final Properties properties;

    static Node create(String primaryLabel, String ... additionalLabels) {
        return Node.create(primaryLabel, null, additionalLabels);
    }

    static Node create(String primaryLabel, MapExpression properties, String ... additionalLabels) {
        Assert.hasText(primaryLabel, "A primary label is required.");
        for (String additionalLabel : additionalLabels) {
            Assert.hasText(additionalLabel, "An empty label is not allowed.");
        }
        return new Node(primaryLabel, properties == null ? null : new Properties(properties), additionalLabels);
    }

    static Node create() {
        return new Node(null, null, new String[0]);
    }

    private Node(String primaryLabel, Properties properties, String ... additionalLabels) {
        this.symbolicName = null;
        this.labels = new ArrayList<NodeLabel>();
        if (primaryLabel != null && !primaryLabel.isEmpty()) {
            this.labels.add(new NodeLabel(primaryLabel));
        }
        this.labels.addAll(Arrays.stream(additionalLabels).map(NodeLabel::new).collect(Collectors.toList()));
        this.properties = properties;
    }

    private Node(SymbolicName symbolicName, Properties properties, List<NodeLabel> labels) {
        this.symbolicName = symbolicName;
        this.labels = new ArrayList<NodeLabel>(labels);
        this.properties = properties;
    }

    public Node named(String newSymbolicName) {
        Assert.hasText(newSymbolicName, "Symbolic name is required.");
        return new Node(SymbolicName.create(newSymbolicName), this.properties, this.labels);
    }

    public Node named(SymbolicName newSymbolicName) {
        Assert.notNull(newSymbolicName, "Symbolic name is required.");
        return new Node(newSymbolicName, this.properties, this.labels);
    }

    @Override
    public Node withProperties(MapExpression<?> newProperties) {
        return new Node(this.symbolicName, newProperties == null ? null : new Properties(newProperties), this.labels);
    }

    @Override
    public Node withProperties(Object ... keysAndValues) {
        MapExpression<?> newProperties = null;
        if (keysAndValues != null && keysAndValues.length != 0) {
            newProperties = MapExpression.create(keysAndValues);
        }
        return this.withProperties((MapExpression)newProperties);
    }

    @Override
    public Property property(String name) {
        return Property.create(this, name);
    }

    public MapProjection project(List<Object> entries) {
        return this.project(entries.toArray());
    }

    public MapProjection project(Object ... entries) {
        return MapProjection.create(this.getRequiredSymbolicName(), entries);
    }

    @Override
    public Optional<SymbolicName> getSymbolicName() {
        return Optional.ofNullable(this.symbolicName);
    }

    public FunctionInvocation internalId() {
        return Functions.id(this);
    }

    public FunctionInvocation labels() {
        return Functions.labels(this);
    }

    @Override
    public Relationship relationshipTo(Node other, String ... types) {
        return Relationship.create(this, Relationship.Direction.LTR, other, types);
    }

    @Override
    public Relationship relationshipFrom(Node other, String ... types) {
        return Relationship.create(this, Relationship.Direction.RTL, other, types);
    }

    @Override
    public Relationship relationshipBetween(Node other, String ... types) {
        return Relationship.create(this, Relationship.Direction.UNI, other, types);
    }

    public Condition hasLabels(String ... labelsToQuery) {
        return HasLabelCondition.create(this.getSymbolicName().orElseThrow(() -> new IllegalStateException("Cannot query a node without a symbolic name.")), labelsToQuery);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Visitable.visitIfNotNull(this.symbolicName, visitor);
        this.labels.forEach(label -> label.accept(visitor));
        Visitable.visitIfNotNull(this.properties, visitor);
        visitor.leave(this);
    }

    public String toString() {
        return "Node{symbolicName=" + this.symbolicName + ", labels=" + this.labels + '}';
    }

    public Condition isEqualTo(Node otherNode) {
        return this.getRequiredSymbolicName().isEqualTo(otherNode.getRequiredSymbolicName());
    }

    public Condition isNotEqualTo(Node otherNode) {
        return this.getRequiredSymbolicName().isNotEqualTo(otherNode.getRequiredSymbolicName());
    }

    public Condition isNull() {
        return this.getRequiredSymbolicName().isNull();
    }

    public Condition isNotNull() {
        return this.getRequiredSymbolicName().isNotNull();
    }

    public SortItem descending() {
        return this.getRequiredSymbolicName().descending();
    }

    public SortItem ascending() {
        return this.getRequiredSymbolicName().ascending();
    }

    public AliasedExpression as(String alias) {
        return this.getRequiredSymbolicName().as(alias);
    }
}

