/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class ListExpression
implements Expression {
    private final ExpressionList<?> content;

    static Expression listOrSingleExpression(Expression ... expressions) {
        Assert.notNull(expressions, "Expressions are required.");
        Assert.notEmpty(expressions, "At least one expression is required.");
        if (expressions.length == 1) {
            return expressions[0];
        }
        return ListExpression.create(expressions);
    }

    static ListExpression create(Expression ... expressions) {
        return new ListExpression(new ExpressionList(expressions));
    }

    private ListExpression(ExpressionList<?> content) {
        this.content = content;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.content.accept(visitor);
        visitor.leave(this);
    }
}

