/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

final class Assert {
    public static void hasText(String text, String message) {
        if (!Assert.hasText(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message) {
        Assert.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (Assert.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    private static boolean hasText(String str) {
        return str != null && !str.isEmpty() && Assert.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private Assert() {
    }
}

