/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import org.neo4j.cypherdsl.query.AsString;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.Identifier;
import org.neo4j.cypherdsl.query.Literal;

public abstract class StartExpression
extends Expression
implements AsString,
Serializable,
Cloneable {
    public Identifier name;

    public static class StartRelationshipsIndex
    extends StartExpression {
        public Identifier index;
        public Identifier key;
        public Literal value;

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=relationship:");
            this.index.asString(builder);
            builder.append('(');
            this.key.asString(builder);
            builder.append('=');
            this.value.asString(builder);
            builder.append(')');
        }
    }

    public static class StartRelationshipsParameters
    extends StartExpression {
        public String parameter;

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=relationship({").append(this.parameter).append("})");
        }
    }

    public static class StartRelationships
    extends StartExpression {
        public Expression[] relationships;

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=relationship(");
            for (int i = 0; i < this.relationships.length; ++i) {
                Expression rel = this.relationships[i];
                if (i > 0) {
                    builder.append(',');
                }
                rel.asString(builder);
            }
            builder.append(')');
        }
    }

    public static class StartNodesQuery
    extends StartExpression {
        public Identifier index;
        public String query;

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=node:");
            this.index.asString(builder);
            builder.append("(\"").append(this.query).append("\")");
        }
    }

    public static class StartNodesLookup
    extends StartExpression {
        public Identifier index;
        public Identifier key;
        public Expression value;

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=node:");
            this.index.asString(builder);
            builder.append('(');
            this.key.asString(builder);
            builder.append("=");
            this.value.asString(builder);
            builder.append(')');
        }
    }

    public static class StartNodes
    extends StartExpression {
        public Expression[] nodes;

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=node(");
            for (int i = 0; i < this.nodes.length; ++i) {
                Expression node = this.nodes[i];
                if (i > 0) {
                    builder.append(',');
                }
                node.asString(builder);
            }
            builder.append(')');
        }
    }

    public static class AllNodes
    extends Expression {
        @Override
        public void asString(StringBuilder builder) {
            builder.append("*");
        }
    }
}

