/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.cypherdsl.query.AsString;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.Literal;
import org.neo4j.cypherdsl.query.MatchExpression;
import org.neo4j.cypherdsl.query.OrderByExpression;
import org.neo4j.cypherdsl.query.PredicateExpression;
import org.neo4j.cypherdsl.query.ReturnExpression;
import org.neo4j.cypherdsl.query.StartExpression;

public class Query
implements AsString,
Serializable,
Cloneable {
    public ArrayList<StartExpression> startExpressions = new ArrayList();
    public ArrayList<MatchExpression> matchExpressions = new ArrayList();
    public ArrayList<PredicateExpression> whereExpressions = new ArrayList();
    public ArrayList<ReturnExpression> returnExpressions = new ArrayList();
    public ArrayList<OrderByExpression> orderByExpressions = new ArrayList();
    public Integer skip;
    public Integer limit;

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static void checkNull(Object object, String name) {
        if (object.getClass().isArray()) {
            Object[] array;
            for (Object obj : array = (Object[])object) {
                if (obj != null) continue;
                throw new IllegalArgumentException(name + " may not be null");
            }
        } else if (object == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
    }

    public static void checkEmpty(String string, String name) {
        if (Query.isEmpty(string)) {
            throw new IllegalArgumentException(name + " may not be null or empty string");
        }
    }

    public static void checkEmpty(Expression value, String name) {
        if (value instanceof Literal && Query.isEmpty((String)((Literal)value).value)) {
            throw new IllegalArgumentException(name + " may not be null or empty string");
        }
    }

    public static void checkEmpty(String[] strings, String name) {
        for (String string : strings) {
            if (!Query.isEmpty(string)) continue;
            throw new IllegalArgumentException(name + " may not be null or empty string");
        }
    }

    @Override
    public void asString(StringBuilder builder) {
        builder.append("CYPHER 1.7");
        this.clause(builder, "START", this.startExpressions, ",");
        this.clause(builder, "MATCH", this.matchExpressions, ",");
        this.clause(builder, "WHERE", this.whereExpressions, " AND ");
        this.clause(builder, "RETURN", this.returnExpressions, ",");
        this.clause(builder, "ORDER BY", this.orderByExpressions, ",");
        if (this.skip != null) {
            builder.append(" SKIP ").append(this.skip);
        }
        if (this.limit != null) {
            builder.append(" LIMIT ").append(this.limit);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Query query = (Query)super.clone();
        query.startExpressions = (ArrayList)query.startExpressions.clone();
        query.matchExpressions = (ArrayList)query.matchExpressions.clone();
        query.whereExpressions = (ArrayList)query.whereExpressions.clone();
        query.returnExpressions = (ArrayList)query.returnExpressions.clone();
        query.orderByExpressions = (ArrayList)query.orderByExpressions.clone();
        return query;
    }

    private void clause(StringBuilder builder, String name, List<? extends AsString> asStringList, String separator) {
        if (!asStringList.isEmpty()) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(name).append(' ');
            for (int i = 0; i < asStringList.size(); ++i) {
                AsString asString = asStringList.get(i);
                if (i > 0) {
                    builder.append(separator);
                }
                asString.asString(builder);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.asString(builder);
        return builder.toString();
    }
}

