/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.util.regex.Pattern;
import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.query.CommonProperty;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.IsNotNull;
import org.neo4j.cypherdsl.query.IsNull;
import org.neo4j.cypherdsl.query.NumberProperty;
import org.neo4j.cypherdsl.query.Query;
import org.neo4j.cypherdsl.query.StringProperty;

public class Identifier
extends Expression {
    private static Pattern simpleName = Pattern.compile("\\w*");
    public String name;

    public CommonProperty property(String name) {
        return this.property(CypherQuery.identifier(name));
    }

    public CommonProperty property(Identifier name) {
        Query.checkNull(name, "Name");
        CommonProperty property = new CommonProperty();
        property.owner = this;
        property.name = name;
        return property;
    }

    public StringProperty string(String name) {
        return this.string(CypherQuery.identifier(name));
    }

    public StringProperty string(Identifier name) {
        Query.checkNull(name, "Name");
        StringProperty stringProperty = new StringProperty();
        stringProperty.owner = this;
        stringProperty.name = name;
        return stringProperty;
    }

    public NumberProperty number(String name) {
        return this.number(CypherQuery.identifier(name));
    }

    public NumberProperty number(Identifier name) {
        Query.checkNull(name, "Name");
        NumberProperty numberProperty = new NumberProperty();
        numberProperty.owner = this;
        numberProperty.name = name;
        return numberProperty;
    }

    public IsNull isNull() {
        IsNull isNull = new IsNull();
        isNull.expression = this;
        return isNull;
    }

    public IsNotNull isNotNull() {
        IsNotNull isNotNull = new IsNotNull();
        isNotNull.expression = this;
        return isNotNull;
    }

    @Override
    public void asString(StringBuilder builder) {
        if (simpleName.matcher(this.name).matches()) {
            builder.append(this.name);
        } else {
            builder.append('`').append(this.name).append('`');
        }
    }
}

