/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import org.neo4j.cypherdsl.query.PredicateExpression;

public abstract class BooleanExpression
extends PredicateExpression {

    public static class Not
    extends BooleanExpression {
        public PredicateExpression expression;

        @Override
        public void asString(StringBuilder builder) {
            builder.append("not(");
            this.expression.asString(builder);
            builder.append(')');
        }
    }

    public static class Or
    extends BooleanExpression {
        public PredicateExpression[] expressions;

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.expressions.length; ++i) {
                PredicateExpression expression = this.expressions[i];
                if (i > 0) {
                    builder.append(" or ");
                }
                if (expression instanceof And) {
                    builder.append('(');
                    expression.asString(builder);
                    builder.append(')');
                    continue;
                }
                expression.asString(builder);
            }
        }
    }

    public static class And
    extends BooleanExpression {
        public PredicateExpression[] expressions;

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.expressions.length; ++i) {
                PredicateExpression expression = this.expressions[i];
                if (i > 0) {
                    builder.append(" and ");
                }
                if (expression instanceof And || expression instanceof Or) {
                    builder.append('(');
                    expression.asString(builder);
                    builder.append(')');
                    continue;
                }
                expression.asString(builder);
            }
        }
    }
}

