/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import org.neo4j.cypherdsl.query.AsString;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.Query;

public abstract class StartExpression
extends Expression
implements AsString,
Serializable,
Cloneable {
    public String name;

    public static StartNodes node(String name, long ... id) {
        Query.checkEmpty(name, "Name");
        for (long i : id) {
            if (i >= 0L) continue;
            throw new IllegalArgumentException("Id may not be below zero");
        }
        StartNodes startNodes = new StartNodes();
        startNodes.name = name;
        startNodes.nodes = StartExpression.literals(id);
        return startNodes;
    }

    public static StartNodes node(String name, String parameter) {
        Query.checkEmpty(name, "Name");
        Query.checkEmpty(parameter, "Parameters");
        StartNodes startNodes = new StartNodes();
        startNodes.name = name;
        startNodes.nodes = StartExpression.parameters(new String[]{parameter});
        return startNodes;
    }

    public static StartNodesLookup lookup(String name, String indexName, String key, String value) {
        Query.checkEmpty(key, "Key");
        Query.checkEmpty(value, "Value");
        return StartExpression.lookup(name, indexName, StartExpression.identifier(key), StartExpression.literal(value));
    }

    public static StartNodesLookup lookup(String name, String indexName, Expression.Identifier key, Expression.Value value) {
        Query.checkEmpty(name, "Name");
        Query.checkEmpty(indexName, "Index");
        StartNodesLookup startNodesLookup = new StartNodesLookup();
        startNodesLookup.name = name;
        startNodesLookup.index = indexName;
        startNodesLookup.key = key;
        startNodesLookup.value = value;
        return startNodesLookup;
    }

    public static StartNodesQuery query(String name, String indexName, String query) {
        Query.checkEmpty(name, "Name");
        Query.checkEmpty(indexName, "Index");
        Query.checkEmpty(query, "Query");
        StartNodesQuery startNodesQuery = new StartNodesQuery();
        startNodesQuery.name = name;
        startNodesQuery.index = indexName;
        startNodesQuery.query = query;
        return startNodesQuery;
    }

    public static StartRelationships relationship(String name, long ... id) {
        Query.checkEmpty(name, "Name");
        for (long i : id) {
            if (i >= 0L) continue;
            throw new IllegalArgumentException("Id may not be below zero");
        }
        StartRelationships startRelationships = new StartRelationships();
        startRelationships.name = name;
        startRelationships.relationships = StartExpression.literals(id);
        return startRelationships;
    }

    public static StartRelationshipsParameters relationship(String name, String parameter) {
        Query.checkEmpty(name, "Name");
        Query.checkEmpty(parameter, "Parameter");
        StartRelationshipsParameters startRelationships = new StartRelationshipsParameters();
        startRelationships.name = name;
        startRelationships.parameter = parameter;
        return startRelationships;
    }

    public static StartRelationshipsIndex relationshipLookup(String name, String indexName, String key, String value) {
        Query.checkEmpty(key, "Key");
        Query.checkEmpty(value, "Value");
        return StartExpression.relationshipLookup(name, indexName, StartExpression.identifier(key), StartExpression.literal(value));
    }

    public static StartRelationshipsIndex relationshipLookup(String name, String indexName, Expression.Identifier key, Expression.Value value) {
        Query.checkEmpty(name, "Name");
        Query.checkEmpty(indexName, "Index");
        Query.checkNull(key, "Key");
        Query.checkEmpty(value, "Value");
        StartRelationshipsIndex startRelationshipsIndex = new StartRelationshipsIndex();
        startRelationshipsIndex.name = name;
        startRelationshipsIndex.index = indexName;
        startRelationshipsIndex.key = key;
        startRelationshipsIndex.value = value;
        return startRelationshipsIndex;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class StartRelationshipsIndex
    extends StartExpression {
        public String index;
        public Expression.Identifier key;
        public Expression.Value value;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.name).append("=relationship:").append(this.index).append('(');
            this.key.asString(builder);
            builder.append('=');
            this.value.asString(builder);
            builder.append(')');
        }
    }

    public static class StartRelationshipsParameters
    extends StartExpression {
        public String parameter;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.name).append("=relationship({").append(this.parameter).append("})");
        }
    }

    public static class StartRelationships
    extends StartExpression {
        public Expression.Value[] relationships;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.name).append("=relationship(");
            for (int i = 0; i < this.relationships.length; ++i) {
                Expression.Value rel = this.relationships[i];
                if (i > 0) {
                    builder.append(',');
                }
                rel.asString(builder);
            }
            builder.append(')');
        }
    }

    public static class StartNodesQuery
    extends StartExpression {
        public String index;
        public String query;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.name).append("=node:").append(this.index).append("(\"").append(this.query).append("\")");
        }
    }

    public static class StartNodesLookup
    extends StartExpression {
        public String index;
        public Expression.Identifier key;
        public Expression.Value value;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.name).append("=node:").append(this.index).append('(');
            this.key.asString(builder);
            builder.append("=");
            this.value.asString(builder);
            builder.append(')');
        }
    }

    public static class StartNodes
    extends StartExpression {
        public Expression.Value[] nodes;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.name).append("=node(");
            for (int i = 0; i < this.nodes.length; ++i) {
                Expression.Value node = this.nodes[i];
                if (i > 0) {
                    builder.append(',');
                }
                node.asString(builder);
            }
            builder.append(')');
        }
    }
}

