/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import org.neo4j.cypherdsl.query.AsString;
import org.neo4j.cypherdsl.query.Query;

public abstract class ReturnExpression<T extends ReturnExpression>
implements AsString,
Serializable,
Cloneable {
    public boolean distinct;
    public String[] as;

    public static ReturnNodes nodes(String ... names) {
        Query.checkEmpty(names, "Names");
        ReturnNodes returnNode = new ReturnNodes();
        returnNode.names = names;
        return returnNode;
    }

    public static ReturnRelationships relationships(String ... names) {
        Query.checkEmpty(names, "Names");
        ReturnRelationships returnRelationship = new ReturnRelationships();
        returnRelationship.names = names;
        return returnRelationship;
    }

    public static ReturnProperties properties(String ... names) {
        Query.checkEmpty(names, "Names");
        ReturnProperties returnProperty = new ReturnProperties();
        returnProperty.names = names;
        return returnProperty;
    }

    public static ReturnPaths paths(String ... names) {
        Query.checkEmpty(names, "Names");
        ReturnPaths returnPath = new ReturnPaths();
        returnPath.names = names;
        return returnPath;
    }

    public static ReturnAggregate count() {
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "count";
        return returnAggregate;
    }

    public static ReturnAggregate count(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "count";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate sum(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "sum";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate avg(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "avg";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate max(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "max";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate min(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "min";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate collect(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "collect";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnNameFunction length(String name) {
        Query.checkEmpty(name, "Name");
        ReturnNameFunction returnFunction = new ReturnNameFunction();
        returnFunction.function = "length";
        returnFunction.name = name;
        return returnFunction;
    }

    public static ReturnNameFunction type(String name) {
        Query.checkEmpty(name, "Name");
        ReturnNameFunction returnFunction = new ReturnNameFunction();
        returnFunction.function = "type";
        returnFunction.name = name;
        return returnFunction;
    }

    public static ReturnNameFunction id(String name) {
        Query.checkEmpty(name, "Name");
        ReturnNameFunction returnFunction = new ReturnNameFunction();
        returnFunction.function = "id";
        returnFunction.name = name;
        return returnFunction;
    }

    public static ReturnExpressionsFunction coalesce(ReturnExpression ... expressions) {
        if (expressions.length < 1) {
            throw new IllegalArgumentException("At least one expression must be provided to coalesce function");
        }
        ReturnExpressionsFunction returnFunction = new ReturnExpressionsFunction();
        returnFunction.function = "coalesce";
        returnFunction.expressions = expressions;
        return returnFunction;
    }

    public static ReturnNameFunction nodesOf(String name) {
        Query.checkEmpty(name, "Name");
        ReturnNameFunction returnFunction = new ReturnNameFunction();
        returnFunction.function = "nodes";
        returnFunction.name = name;
        return returnFunction;
    }

    public static ReturnNameFunction relationshipsOf(String name) {
        Query.checkEmpty(name, "Name");
        ReturnNameFunction returnFunction = new ReturnNameFunction();
        returnFunction.function = "relationships";
        returnFunction.name = name;
        return returnFunction;
    }

    public T distinct() {
        this.distinct = true;
        return (T)this;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class ReturnAggregate
    extends ReturnExpression<ReturnAggregate> {
        public String function;
        public String name;
        public boolean optional;

        public ReturnAggregate optional() {
            this.optional = true;
            return this;
        }

        public ReturnAggregate as(String name) {
            this.as = new String[]{name};
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.function).append('(');
            if (this.distinct) {
                builder.append("distinct ");
            }
            if (this.name == null) {
                builder.append("*");
            } else {
                builder.append(this.name);
                if (this.optional) {
                    builder.append('?');
                }
            }
            builder.append(')');
            if (this.as != null) {
                builder.append(" AS ").append(this.as[0]);
            }
        }
    }

    public static class ReturnExpressionsFunction
    extends ReturnFunction<ReturnExpressionsFunction> {
        public ReturnExpression[] expressions;

        @Override
        public ReturnExpressionsFunction as(String name) {
            this.as = new String[]{name};
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.function).append('(');
            for (int i = 0; i < this.expressions.length; ++i) {
                ReturnExpression expression = this.expressions[i];
                if (i > 0) {
                    builder.append(',');
                }
                expression.asString(builder);
            }
            builder.append(')');
            if (this.as != null) {
                builder.append(" AS ").append(this.as[0]);
            }
        }
    }

    public static class ReturnNameFunction
    extends ReturnFunction<ReturnNameFunction> {
        public String name;

        @Override
        public ReturnNameFunction as(String name) {
            this.as = new String[]{name};
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.function).append('(').append(this.name).append(')');
            if (this.as != null) {
                builder.append(" AS ").append(this.as[0]);
            }
        }
    }

    public static abstract class ReturnFunction<T extends ReturnFunction>
    extends ReturnExpression<T> {
        public String function;

        public T as(String name) {
            this.as = new String[]{name};
            return (T)this;
        }
    }

    public static class ReturnProperties
    extends ReturnExpression<ReturnProperties> {
        public boolean optional;
        public String[] names;

        public ReturnProperties optional() {
            this.optional = true;
            return this;
        }

        public ReturnProperties as(String ... names) {
            if (names.length != names.length) {
                throw new IllegalArgumentException("Number of aliases does not match number of properties specified");
            }
            this.as = names;
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if (i > 0) {
                    builder.append(',');
                }
                if (this.distinct) {
                    builder.append("distinct ");
                }
                builder.append(name);
                if (this.optional) {
                    builder.append('?');
                }
                if (this.as == null) continue;
                builder.append(" AS ").append(this.as[i]);
            }
        }
    }

    public static class ReturnPaths
    extends ReturnExpression<ReturnPaths> {
        public String[] names;

        public ReturnPaths as(String ... names) {
            if (names.length != names.length) {
                throw new IllegalArgumentException("Number of aliases does not match number of paths specified");
            }
            this.as = names;
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if (i > 0) {
                    builder.append(',');
                }
                if (this.distinct) {
                    builder.append("distinct ");
                }
                builder.append(name);
                if (this.as == null) continue;
                builder.append(" AS ").append(this.as[i]);
            }
        }
    }

    public static class ReturnRelationships
    extends ReturnExpression<ReturnRelationships> {
        public String[] names;

        public ReturnRelationships as(String ... names) {
            if (names.length != names.length) {
                throw new IllegalArgumentException("Number of aliases does not match number of relationships specified");
            }
            this.as = names;
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if (i > 0) {
                    builder.append(',');
                }
                if (this.distinct) {
                    builder.append("distinct ");
                }
                builder.append(name);
                if (this.as == null) continue;
                builder.append(" AS ").append(this.as[i]);
            }
        }
    }

    public static class ReturnNodes
    extends ReturnExpression<ReturnNodes> {
        public String[] names;

        public ReturnNodes as(String ... names) {
            if (names.length != names.length) {
                throw new IllegalArgumentException("Number of aliases does not match number of nodes specified");
            }
            this.as = names;
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if (i > 0) {
                    builder.append(',');
                }
                if (this.distinct) {
                    builder.append("distinct ");
                }
                builder.append(name);
                if (this.as == null) continue;
                builder.append(" AS ").append(this.as[i]);
            }
        }
    }
}

