/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import org.neo4j.cypherdsl.query.AsString;
import org.neo4j.cypherdsl.query.Query;

public class OrderByExpression
implements AsString,
Serializable,
Cloneable {
    public String name;
    public Order order;
    public boolean optional;

    public static OrderByExpression property(String name) {
        Query.checkEmpty(name, "Name");
        OrderByExpression orderBy = new OrderByExpression();
        orderBy.name = name;
        return orderBy;
    }

    public static OrderByExpression property(String name, Order order) {
        Query.checkEmpty(name, "Name");
        Query.checkNull((Object)order, "Order");
        OrderByExpression orderBy = new OrderByExpression();
        orderBy.name = name;
        orderBy.order = order;
        return orderBy;
    }

    public OrderByExpression optional() {
        this.optional = true;
        return this;
    }

    public OrderByExpression order(Order order) {
        this.order = order;
        return this;
    }

    @Override
    public void asString(StringBuilder builder) {
        builder.append(this.name);
        if (this.order != null) {
            builder.append(' ').append(this.order.name());
        }
        if (this.optional) {
            builder.append('?');
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static enum Order {
        ASCENDING,
        DESCENDING;

    }
}

