/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypherdsl.Execute;
import org.neo4j.cypherdsl.ExecuteWithParameters;
import org.neo4j.cypherdsl.Limit;
import org.neo4j.cypherdsl.Match;
import org.neo4j.cypherdsl.OrderBy;
import org.neo4j.cypherdsl.Return;
import org.neo4j.cypherdsl.ReturnNext;
import org.neo4j.cypherdsl.Skip;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.MatchExpression;
import org.neo4j.cypherdsl.query.OrderByExpression;
import org.neo4j.cypherdsl.query.Query;
import org.neo4j.cypherdsl.query.ReturnExpression;
import org.neo4j.cypherdsl.query.StartExpression;
import org.neo4j.cypherdsl.query.WhereExpression;

public class CypherQuery {
    protected Query query;

    public static Match start(StartExpression ... startExpressions) {
        CypherQuery query = new CypherQuery();
        return query.starts(startExpressions);
    }

    public static CypherQuery newQuery(Query query) {
        return new CypherQuery(query);
    }

    public CypherQuery() {
        this.query = new Query();
    }

    private CypherQuery(Query query) {
        try {
            this.query = (Query)query.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Query was not cloneable");
        }
    }

    protected Match starts(StartExpression ... startExpression) {
        for (StartExpression expression : startExpression) {
            this.query.startExpressions.add(expression);
        }
        return new Grammar();
    }

    protected StartExpression.StartNodes node(String name, long ... id) {
        return StartExpression.node(name, id);
    }

    protected StartExpression.StartNodes node(String name, String parameter) {
        return StartExpression.node(name, parameter);
    }

    protected StartExpression.StartNodesLookup lookup(String name, String indexName, String key, String value) {
        return StartExpression.lookup(name, indexName, key, value);
    }

    protected StartExpression.StartNodesLookup lookup(String name, String indexName, Expression.Identifier key, Expression.Value value) {
        return StartExpression.lookup(name, indexName, key, value);
    }

    protected StartExpression.StartNodesQuery query(String name, String indexName, String query) {
        return StartExpression.query(name, indexName, query);
    }

    protected StartExpression.StartRelationships relationship(String name, long ... id) {
        return StartExpression.relationship(name, id);
    }

    protected StartExpression.StartRelationshipsParameters relationship(String name, String parameter) {
        return StartExpression.relationship(name, parameter);
    }

    protected StartExpression.StartRelationshipsIndex relationshipLookup(String name, String indexName, String key, String value) {
        return StartExpression.relationshipLookup(name, indexName, key, value);
    }

    protected StartExpression.StartRelationshipsIndex relationshipLookup(String name, String indexName, Expression.Identifier key, Expression.Value value) {
        return StartExpression.relationshipLookup(name, indexName, key, value);
    }

    protected MatchExpression.Path path() {
        return MatchExpression.path();
    }

    protected MatchExpression.Path path(String name) {
        return MatchExpression.path(name);
    }

    protected MatchExpression.FunctionPath shortestPath(String name) {
        return MatchExpression.shortestPath(name);
    }

    protected WhereExpression.CommonType prop(String name) {
        return WhereExpression.prop(name);
    }

    protected WhereExpression.StringType string(String name) {
        return WhereExpression.string(name);
    }

    protected WhereExpression.NumberType number(String name) {
        return WhereExpression.number(name);
    }

    protected WhereExpression.Not not(WhereExpression.PredicateExpression expr) {
        return WhereExpression.not(expr);
    }

    protected ReturnExpression.ReturnNodes nodes(String ... names) {
        return ReturnExpression.nodes(names);
    }

    protected ReturnExpression.ReturnRelationships relationships(String ... names) {
        return ReturnExpression.relationships(names);
    }

    protected ReturnExpression.ReturnProperties properties(String ... names) {
        return ReturnExpression.properties(names);
    }

    protected ReturnExpression.ReturnPaths paths(String ... names) {
        return ReturnExpression.paths(names);
    }

    protected ReturnExpression.ReturnAggregate count() {
        return ReturnExpression.count();
    }

    protected ReturnExpression.ReturnAggregate count(String name) {
        return ReturnExpression.count(name);
    }

    protected ReturnExpression.ReturnAggregate sum(String name) {
        return ReturnExpression.sum(name);
    }

    protected ReturnExpression.ReturnAggregate avg(String name) {
        return ReturnExpression.avg(name);
    }

    protected ReturnExpression.ReturnAggregate max(String name) {
        return ReturnExpression.max(name);
    }

    protected ReturnExpression.ReturnAggregate min(String name) {
        return ReturnExpression.min(name);
    }

    protected ReturnExpression.ReturnAggregate collect(String name) {
        return ReturnExpression.collect(name);
    }

    protected ReturnExpression.ReturnNameFunction length(String name) {
        return ReturnExpression.length(name);
    }

    protected ReturnExpression.ReturnNameFunction type(String name) {
        return ReturnExpression.type(name);
    }

    protected ReturnExpression.ReturnNameFunction id(String name) {
        return ReturnExpression.id(name);
    }

    protected ReturnExpression.ReturnExpressionsFunction coalesce(ReturnExpression ... expressions) {
        return ReturnExpression.coalesce(expressions);
    }

    protected ReturnExpression.ReturnNameFunction nodesOf(String name) {
        return ReturnExpression.nodesOf(name);
    }

    protected ReturnExpression.ReturnNameFunction relationshipsOf(String name) {
        return ReturnExpression.relationshipsOf(name);
    }

    protected OrderByExpression property(String name) {
        return OrderByExpression.property(name);
    }

    protected OrderByExpression property(String name, OrderByExpression.Order order) {
        return OrderByExpression.property(name, order);
    }

    public String toString() {
        return this.query.toString();
    }

    protected class ExecuteWithParams
    implements ExecuteWithParameters {
        private Query query;
        private Map<String, Object> parameters = new HashMap<String, Object>();

        public ExecuteWithParams(Query query) {
            this.query = query;
        }

        @Override
        public Query toQuery() {
            return this.query;
        }

        @Override
        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        @Override
        public ExecuteWithParameters parameter(String name, Object value) {
            this.parameters.put(name, value);
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.query.asString(builder);
        }

        public String toString() {
            return this.query.toString();
        }
    }

    protected class Grammar
    implements Match,
    ReturnNext,
    OrderBy,
    Skip,
    Limit,
    Execute {
        protected Grammar() {
        }

        @Override
        public Match match(MatchExpression ... expression) {
            for (MatchExpression matchExpression : expression) {
                CypherQuery.this.query.matchExpressions.add(matchExpression);
            }
            return this;
        }

        @Override
        public Return where(WhereExpression expression) {
            Query.checkNull(expression, "Expression");
            CypherQuery.this.query.whereExpression = expression;
            return this;
        }

        @Override
        public ReturnNext returns(ReturnExpression ... returnExpression) {
            for (ReturnExpression expression : returnExpression) {
                CypherQuery.this.query.returnExpressions.add(expression);
            }
            return this;
        }

        @Override
        public OrderBy orderBy(OrderByExpression ... orderByExpression) {
            for (OrderByExpression expression : orderByExpression) {
                CypherQuery.this.query.orderByExpressions.add(expression);
            }
            return this;
        }

        @Override
        public Limit skip(int skip) {
            if (skip < 0) {
                throw new IllegalArgumentException("Skip may not be below zero");
            }
            CypherQuery.this.query.skip = skip;
            return this;
        }

        @Override
        public Execute limit(int limit) {
            if (limit < 0) {
                throw new IllegalArgumentException("Limit may not be below zero");
            }
            CypherQuery.this.query.limit = limit;
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            CypherQuery.this.query.asString(builder);
        }

        @Override
        public Query toQuery() {
            return CypherQuery.this.query;
        }

        @Override
        public ExecuteWithParameters parameter(String name, Object value) {
            ExecuteWithParams withParams = new ExecuteWithParams(CypherQuery.this.query);
            return withParams.parameter(name, value);
        }

        public String toString() {
            return CypherQuery.this.toString();
        }
    }
}

