/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.result;

import java.util.Map;
import org.neo4j.graphdb.Path;

public class JSONSerializer {
    public String toJSON(Iterable<Map<String, Object>> result) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean firstItem = true;
        for (Map<String, Object> stringObjectMap : result) {
            if (!firstItem) {
                builder.append(',');
            }
            firstItem = false;
            builder.append("{");
            boolean firstValue = true;
            for (Map.Entry<String, Object> stringObjectEntry : stringObjectMap.entrySet()) {
                if (!firstValue) {
                    builder.append(',');
                }
                firstValue = false;
                builder.append('\"').append(stringObjectEntry.getKey()).append("\":");
                if (stringObjectEntry.getValue() instanceof String) {
                    builder.append("\"").append(stringObjectEntry.getValue()).append("\"");
                    continue;
                }
                if (stringObjectEntry.getValue() instanceof Path) {
                    builder.append("\"").append(stringObjectEntry.getValue()).append("\"");
                    continue;
                }
                builder.append(stringObjectEntry.getValue());
            }
            builder.append("}");
        }
        builder.append("]");
        return builder.toString();
    }
}

