/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import org.neo4j.cypherdsl.query.AsString;
import org.neo4j.cypherdsl.query.Query;

public abstract class ReturnExpression<T extends ReturnExpression>
implements AsString,
Serializable,
Cloneable {
    public boolean distinct;

    public static ReturnNode nodes(String ... names) {
        Query.checkEmpty(names, "Names");
        ReturnNode returnNode = new ReturnNode();
        returnNode.names = names;
        return returnNode;
    }

    public static ReturnRelationship relationships(String ... names) {
        Query.checkEmpty(names, "Names");
        ReturnRelationship returnRelationship = new ReturnRelationship();
        returnRelationship.names = names;
        return returnRelationship;
    }

    public static ReturnProperty properties(String ... names) {
        Query.checkEmpty(names, "Names");
        ReturnProperty returnProperty = new ReturnProperty();
        returnProperty.names = names;
        return returnProperty;
    }

    public static ReturnPath paths(String ... names) {
        Query.checkEmpty(names, "Names");
        ReturnPath returnPath = new ReturnPath();
        returnPath.names = names;
        return returnPath;
    }

    public static ReturnAggregate count() {
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "count";
        return returnAggregate;
    }

    public static ReturnAggregate count(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "count";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate sum(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "sum";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate avg(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "avg";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate max(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "max";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate min(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "min";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnAggregate collect(String name) {
        Query.checkEmpty(name, "Name");
        ReturnAggregate returnAggregate = new ReturnAggregate();
        returnAggregate.function = "collect";
        returnAggregate.name = name;
        return returnAggregate;
    }

    public static ReturnExpression length(String name) {
        Query.checkEmpty(name, "Name");
        ReturnFunction returnFunction = new ReturnFunction();
        returnFunction.function = "length";
        returnFunction.name = name;
        return returnFunction;
    }

    public static ReturnFunction type(String name) {
        Query.checkEmpty(name, "Name");
        ReturnFunction returnFunction = new ReturnFunction();
        returnFunction.function = "type";
        returnFunction.name = name;
        return returnFunction;
    }

    public static ReturnFunction id(String name) {
        Query.checkEmpty(name, "Name");
        ReturnFunction returnFunction = new ReturnFunction();
        returnFunction.function = "id";
        returnFunction.name = name;
        return returnFunction;
    }

    public static ReturnFunction nodesOf(String name) {
        Query.checkEmpty(name, "Name");
        ReturnFunction returnFunction = new ReturnFunction();
        returnFunction.function = "nodes";
        returnFunction.name = name;
        return returnFunction;
    }

    public static ReturnFunction relationshipsOf(String name) {
        Query.checkEmpty(name, "Name");
        ReturnFunction returnFunction = new ReturnFunction();
        returnFunction.function = "relationships";
        returnFunction.name = name;
        return returnFunction;
    }

    public T distinct() {
        this.distinct = true;
        return (T)this;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class ReturnAggregate
    extends ReturnExpression<ReturnAggregate> {
        public String function;
        public String name;
        public boolean optional;

        public ReturnAggregate optional() {
            this.optional = true;
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.function).append('(');
            if (this.distinct) {
                builder.append("distinct ");
            }
            if (this.name == null) {
                builder.append("*");
            } else {
                builder.append(this.name);
                if (this.optional) {
                    builder.append('?');
                }
            }
            builder.append(')');
        }
    }

    public static class ReturnFunction
    extends ReturnExpression<ReturnFunction> {
        public String function;
        public String name;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.function).append('(').append(this.name).append(')');
        }
    }

    public static class ReturnProperty
    extends ReturnExpression<ReturnProperty> {
        public boolean optional;
        public String[] names;

        public ReturnProperty optional() {
            this.optional = true;
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(name);
                if (!this.optional) continue;
                builder.append('?');
            }
        }
    }

    public static class ReturnPath
    extends ReturnExpression<ReturnPath> {
        public String[] names;

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(name);
            }
        }
    }

    public static class ReturnRelationship
    extends ReturnExpression<ReturnRelationship> {
        public String[] names;

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(name);
            }
        }
    }

    public static class ReturnNode
    extends ReturnExpression<ReturnNode> {
        public String[] names;

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if (i > 0) {
                    builder.append(',');
                }
                if (this.distinct) {
                    builder.append("distinct ");
                }
                builder.append(name);
            }
        }
    }
}

