/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.config;

import java.time.Duration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.config.StatsDivergenceCalculatorConfig;

public final class CypherConfiguration$ {
    public static CypherConfiguration$ MODULE$;

    static {
        new CypherConfiguration$();
    }

    public CypherConfiguration fromConfig(Config config) {
        return new CypherConfiguration(config);
    }

    public StatsDivergenceCalculatorConfig statsDivergenceFromConfig(Config config) {
        double divergenceThreshold = (Double)config.get(GraphDatabaseSettings.query_statistics_divergence_threshold);
        double targetThreshold = (Double)config.get(GraphDatabaseInternalSettings.query_statistics_divergence_target);
        long minReplanTime = ((Duration)config.get(GraphDatabaseSettings.cypher_min_replan_interval)).toMillis();
        long targetReplanTime = ((Duration)config.get(GraphDatabaseInternalSettings.cypher_replan_interval_target)).toMillis();
        String divergenceAlgorithm = ((Enum)config.get(GraphDatabaseInternalSettings.cypher_replan_algorithm)).toString();
        return new StatsDivergenceCalculatorConfig(divergenceAlgorithm, divergenceThreshold, targetThreshold, minReplanTime, targetReplanTime);
    }

    private CypherConfiguration$() {
        MODULE$ = this;
    }
}

