/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.config;

import java.io.File;
import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.config.ConfigMemoryTrackingController;
import org.neo4j.cypher.internal.config.CypherConfiguration$;
import org.neo4j.cypher.internal.config.MemoryTrackingController;
import org.neo4j.cypher.internal.config.StatsDivergenceCalculatorConfig;
import org.neo4j.cypher.internal.options.CypherExpressionEngineOption;
import org.neo4j.cypher.internal.options.CypherExpressionEngineOption$;
import org.neo4j.cypher.internal.options.CypherInterpretedPipesFallbackOption;
import org.neo4j.cypher.internal.options.CypherInterpretedPipesFallbackOption$;
import org.neo4j.cypher.internal.options.CypherOperatorEngineOption;
import org.neo4j.cypher.internal.options.CypherOperatorEngineOption$;
import org.neo4j.cypher.internal.options.CypherPlannerOption;
import org.neo4j.cypher.internal.options.CypherPlannerOption$;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.options.CypherRuntimeOption$;
import org.neo4j.cypher.internal.options.CypherVersion;
import org.neo4j.cypher.internal.options.CypherVersion$;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-w!B\"E\u0011\u0003ye!B)E\u0011\u0003\u0011\u0006\"B-\u0002\t\u0003Q\u0006\"B.\u0002\t\u0003a\u0006bBAc\u0003\u0011\u0005\u0011q\u0019\u0004\u0005#\u0012\u0003a\f\u0003\u0005F\u000b\t\u0015\r\u0011\"\u0001`\u0011!1WA!A!\u0002\u0013\u0001\u0007\"B-\u0006\t\u00139\u0007bB5\u0006\u0005\u0004%\tA\u001b\u0005\u0007c\u0016\u0001\u000b\u0011B6\t\u000fI,!\u0019!C\u0001g\"1q/\u0002Q\u0001\nQDq\u0001_\u0003C\u0002\u0013\u0005\u0011\u0010\u0003\u0004~\u000b\u0001\u0006IA\u001f\u0005\b}\u0016\u0011\r\u0011\"\u0001\u0000\u0011!\t9!\u0002Q\u0001\n\u0005\u0005\u0001\"CA\u0005\u000b\t\u0007I\u0011AA\u0006\u0011!\t\u0019\"\u0002Q\u0001\n\u00055\u0001\"CA\u000b\u000b\t\u0007I\u0011AA\f\u0011!\ty\"\u0002Q\u0001\n\u0005e\u0001\u0002CA\u0011\u000b\t\u0007I\u0011A@\t\u0011\u0005\rR\u0001)A\u0005\u0003\u0003A\u0011\"!\n\u0006\u0005\u0004%\t!a\n\t\u0011\u0005=R\u0001)A\u0005\u0003SA\u0011\"!\r\u0006\u0005\u0004%\t!a\u0006\t\u0011\u0005MR\u0001)A\u0005\u00033A\u0011\"!\u000e\u0006\u0005\u0004%\t!a\u0006\t\u0011\u0005]R\u0001)A\u0005\u00033A\u0011\"!\u000f\u0006\u0005\u0004%\t!a\u0006\t\u0011\u0005mR\u0001)A\u0005\u00033A\u0001\"!\u0010\u0006\u0005\u0004%\ta \u0005\t\u0003\u007f)\u0001\u0015!\u0003\u0002\u0002!I\u0011\u0011I\u0003C\u0002\u0013\u0005\u00111\t\u0005\t\u0003\u0017*\u0001\u0015!\u0003\u0002F!I\u0011QJ\u0003C\u0002\u0013\u0005\u0011q\u0003\u0005\t\u0003\u001f*\u0001\u0015!\u0003\u0002\u001a!A\u0011\u0011K\u0003C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002T\u0015\u0001\u000b\u0011BA\u0001\u0011!\t)&\u0002b\u0001\n\u0003y\b\u0002CA,\u000b\u0001\u0006I!!\u0001\t\u0013\u0005eSA1A\u0005\u0002\u0005]\u0001\u0002CA.\u000b\u0001\u0006I!!\u0007\t\u0013\u0005uSA1A\u0005\u0002\u0005}\u0003\u0002CA9\u000b\u0001\u0006I!!\u0019\t\u0011\u0005MTA1A\u0005\u0002}D\u0001\"!\u001e\u0006A\u0003%\u0011\u0011\u0001\u0005\n\u0003o*!\u0019!C\u0001\u0003sB\u0001\"!!\u0006A\u0003%\u00111\u0010\u0005\n\u0003\u0007+!\u0019!C\u0001\u0003\u000bC\u0001\"!$\u0006A\u0003%\u0011q\u0011\u0005\t\u0003\u001f+!\u0019!C\u0001\u007f\"A\u0011\u0011S\u0003!\u0002\u0013\t\t\u0001C\u0005\u0002\u0014\u0016\u0011\r\u0011\"\u0001\u0002\u0016\"A\u0011QT\u0003!\u0002\u0013\t9\nC\u0005\u0002 \u0016\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011\u0011U\u0003!\u0002\u0013\tI\u0002C\u0005\u0002$\u0016\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011QU\u0003!\u0002\u0013\tI\u0002C\u0005\u0002(\u0016\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011\u0011V\u0003!\u0002\u0013\tI\u0002C\u0005\u0002,\u0016\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011QV\u0003!\u0002\u0013\tI\u0002C\u0005\u00020\u0016\u0001\r\u0011\"\u0003\u0002\u0018!I\u0011\u0011W\u0003A\u0002\u0013%\u00111\u0017\u0005\t\u0003\u007f+\u0001\u0015)\u0003\u0002\u001a!9\u0011\u0011Y\u0003\u0005\u0002\u0005]\u0011aE\"za\",'oQ8oM&<WO]1uS>t'BA#G\u0003\u0019\u0019wN\u001c4jO*\u0011q\tS\u0001\tS:$XM\u001d8bY*\u0011\u0011JS\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005-c\u0015!\u00028f_RR'\"A'\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005A\u000bQ\"\u0001#\u0003'\rK\b\u000f[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0014\u0005\u0005\u0019\u0006C\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f\u0006QaM]8n\u0007>tg-[4\u0015\u0007u\u000b\u0019\r\u0005\u0002Q\u000bM\u0011QaU\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111MS\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005\u0015\u0014'AB\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0015\u0005uC\u0007\"B#\t\u0001\u0004\u0001\u0017a\u0002<feNLwN\\\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011aNR\u0001\b_B$\u0018n\u001c8t\u0013\t\u0001XNA\u0007DsBDWM\u001d,feNLwN\\\u0001\tm\u0016\u00148/[8oA\u00059\u0001\u000f\\1o]\u0016\u0014X#\u0001;\u0011\u00051,\u0018B\u0001<n\u0005M\u0019\u0015\u0010\u001d5feBc\u0017M\u001c8fe>\u0003H/[8o\u0003!\u0001H.\u00198oKJ\u0004\u0013a\u0002:v]RLW.Z\u000b\u0002uB\u0011An_\u0005\u0003y6\u00141cQ=qQ\u0016\u0014(+\u001e8uS6,w\n\u001d;j_:\f\u0001B];oi&lW\rI\u0001\u000fcV,'/_\"bG\",7+\u001b>f+\t\t\t\u0001E\u0002U\u0003\u0007I1!!\u0002V\u0005\rIe\u000e^\u0001\u0010cV,'/_\"bG\",7+\u001b>fA\u0005I2\u000f^1ug\u0012Kg/\u001a:hK:\u001cWmQ1mGVd\u0017\r^8s+\t\ti\u0001E\u0002Q\u0003\u001fI1!!\u0005E\u0005}\u0019F/\u0019;t\t&4XM]4f]\u000e,7)\u00197dk2\fGo\u001c:D_:4\u0017nZ\u0001\u001bgR\fGo\u001d#jm\u0016\u0014x-\u001a8dK\u000e\u000bGnY;mCR|'\u000fI\u0001\u0016kN,WI\u001d:peN|e/\u001a:XCJt\u0017N\\4t+\t\tI\u0002E\u0002U\u00037I1!!\bV\u0005\u001d\u0011un\u001c7fC:\fa#^:f\u000bJ\u0014xN]:Pm\u0016\u0014x+\u0019:oS:<7\u000fI\u0001\u0010S\u0012\u0004X*\u0019=UC\ndWmU5{K\u0006\u0001\u0012\u000e\u001a9NCb$\u0016M\u00197f'&TX\rI\u0001\u0015S\u0012\u0004\u0018\n^3sCRLwN\u001c#ve\u0006$\u0018n\u001c8\u0016\u0005\u0005%\u0002c\u0001+\u0002,%\u0019\u0011QF+\u0003\t1{gnZ\u0001\u0016S\u0012\u0004\u0018\n^3sCRLwN\u001c#ve\u0006$\u0018n\u001c8!\u0003!*'O]8s\u0013\u001a\u001c\u0006n\u001c:uKN$\b+\u0019;i\r\u0006dGNY1dWV\u001bX\rZ!u%VtG/[7f\u0003%*'O]8s\u0013\u001a\u001c\u0006n\u001c:uKN$\b+\u0019;i\r\u0006dGNY1dWV\u001bX\rZ!u%VtG/[7fA\u0005QSM\u001d:pe&37\u000b[8si\u0016\u001cH\u000fU1uQ\"\u000b7oQ8n[>tgj\u001c3fg\u0006#(+\u001e8uS6,\u0017aK3se>\u0014\u0018JZ*i_J$Xm\u001d;QCRD\u0007*Y:D_6lwN\u001c(pI\u0016\u001c\u0018\t\u001e*v]RLW.\u001a\u0011\u0002-1,w-Y2z\u0007N4\u0018+^8uK\u0016\u001b8-\u00199j]\u001e\fq\u0003\\3hC\u000eL8i\u001d<Rk>$X-R:dCBLgn\u001a\u0011\u0002\u001b\r\u001chOQ;gM\u0016\u00148+\u001b>f\u00039\u00197O\u001e\"vM\u001a,'oU5{K\u0002\na#\u001a=qe\u0016\u001c8/[8o\u000b:<\u0017N\\3PaRLwN\\\u000b\u0003\u0003\u000b\u00022\u0001\\A$\u0013\r\tI%\u001c\u0002\u001d\u0007f\u0004\b.\u001a:FqB\u0014Xm]:j_:,enZ5oK>\u0003H/[8o\u0003])\u0007\u0010\u001d:fgNLwN\\#oO&tWm\u00149uS>t\u0007%A\rmK:LWM\u001c;De\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004\u0018A\u00077f]&,g\u000e^\"sK\u0006$XMU3mCRLwN\\:iSB\u0004\u0013a\u00069ja\u0016d\u0017N\\3e\u0005\u0006$8\r[*ju\u0016\u001cV.\u00197m\u0003a\u0001\u0018\u000e]3mS:,GMQ1uG\"\u001c\u0016N_3T[\u0006dG\u000eI\u0001\u0016a&\u0004X\r\\5oK\u0012\u0014\u0015\r^2i'&TXMQ5h\u0003Y\u0001\u0018\u000e]3mS:,GMQ1uG\"\u001c\u0016N_3CS\u001e\u0004\u0013A\u00053p'\u000eDW\rZ;mKJ$&/Y2j]\u001e\f1\u0003Z8TG\",G-\u001e7feR\u0013\u0018mY5oO\u0002\nAc]2iK\u0012,H.\u001a:Ue\u0006\u001c\u0017N\\4GS2,WCAA1!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\n!![8\u000b\u0005\u0005-\u0014\u0001\u00026bm\u0006LA!a\u001c\u0002f\t!a)\u001b7f\u0003U\u00198\r[3ek2,'\u000f\u0016:bG&twMR5mK\u0002\n!C]3d_6\u0004\u0018\u000e\\1uS>tG*[7ji\u0006\u0019\"/Z2p[BLG.\u0019;j_:d\u0015.\\5uA\u0005qq\u000e]3sCR|'/\u00128hS:,WCAA>!\ra\u0017QP\u0005\u0004\u0003\u007fj'AG\"za\",'o\u00149fe\u0006$xN]#oO&tWm\u00149uS>t\u0017aD8qKJ\fGo\u001c:F]\u001eLg.\u001a\u0011\u00021%tG/\u001a:qe\u0016$X\r\u001a)ja\u0016\u001ch)\u00197mE\u0006\u001c7.\u0006\u0002\u0002\bB\u0019A.!#\n\u0007\u0005-UN\u0001\u0013DsBDWM]%oi\u0016\u0014\bO]3uK\u0012\u0004\u0016\u000e]3t\r\u0006dGNY1dW>\u0003H/[8o\u0003eIg\u000e^3saJ,G/\u001a3QSB,7OR1mY\n\f7m\u001b\u0011\u0002?=\u0004XM]1u_J4Uo]5p]>3XM\u001d)ja\u0016d\u0017N\\3MS6LG/\u0001\u0011pa\u0016\u0014\u0018\r^8s\rV\u001c\u0018n\u001c8Pm\u0016\u0014\b+\u001b9fY&tW\rT5nSR\u0004\u0013\u0001G7f[>\u0014\u0018\u0010\u0016:bG.LgnZ\"p]R\u0014x\u000e\u001c7feV\u0011\u0011q\u0013\t\u0004!\u0006e\u0015bAAN\t\nAR*Z7pef$&/Y2lS:<7i\u001c8ue>dG.\u001a:\u000235,Wn\u001c:z)J\f7m[5oO\u000e{g\u000e\u001e:pY2,'\u000fI\u0001\u000fK:\f'\r\\3N_:LGo\u001c:t\u0003=)g.\u00192mK6{g.\u001b;peN\u0004\u0013aD;tK*\u000bg/Y\"D!\u0006\u00148/\u001a:\u0002!U\u001cXMS1wC\u000e\u001b\u0005+\u0019:tKJ\u0004\u0013\u0001\u00063jg\u0006dGn\\<Ta2LG\u000f^5oOR{\u0007/A\u000beSN\fG\u000e\\8x'Bd\u0017\u000e\u001e;j]\u001e$v\u000e\u001d\u0011\u0002C\u0015t\u0017M\u00197f!2\fgN\\5oOJ+G.\u0019;j_:\u001c\b.\u001b9J]\u0012,\u00070Z:\u0002E\u0015t\u0017M\u00197f!2\fgN\\5oOJ+G.\u0019;j_:\u001c\b.\u001b9J]\u0012,\u00070Z:!\u0003IyvN\u00194vg\u000e\fG/\u001a'ji\u0016\u0014\u0018\r\\:\u0002-}{'MZ;tG\u0006$X\rT5uKJ\fGn]0%KF$B!!.\u0002<B\u0019A+a.\n\u0007\u0005eVK\u0001\u0003V]&$\b\"CA_\u0001\u0006\u0005\t\u0019AA\r\u0003\rAH%M\u0001\u0014?>\u0014g-^:dCR,G*\u001b;fe\u0006d7\u000fI\u0001\u0012_\n4Wo]2bi\u0016d\u0015\u000e^3sC2\u001c\b\"B#\u0004\u0001\u0004\u0001\u0017!G:uCR\u001cH)\u001b<fe\u001e,gnY3Ge>l7i\u001c8gS\u001e$B!!\u0004\u0002J\")Q\t\u0002a\u0001A\u0002")
public class CypherConfiguration {
    private final Config config;
    private final CypherVersion version;
    private final CypherPlannerOption planner;
    private final CypherRuntimeOption runtime;
    private final int queryCacheSize;
    private final StatsDivergenceCalculatorConfig statsDivergenceCalculator;
    private final boolean useErrorsOverWarnings;
    private final int idpMaxTableSize;
    private final long idpIterationDuration;
    private final boolean errorIfShortestPathFallbackUsedAtRuntime;
    private final boolean errorIfShortestPathHasCommonNodesAtRuntime;
    private final boolean legacyCsvQuoteEscaping;
    private final int csvBufferSize;
    private final CypherExpressionEngineOption expressionEngineOption;
    private final boolean lenientCreateRelationship;
    private final int pipelinedBatchSizeSmall;
    private final int pipelinedBatchSizeBig;
    private final boolean doSchedulerTracing;
    private final File schedulerTracingFile;
    private final int recompilationLimit;
    private final CypherOperatorEngineOption operatorEngine;
    private final CypherInterpretedPipesFallbackOption interpretedPipesFallback;
    private final int operatorFusionOverPipelineLimit;
    private final MemoryTrackingController memoryTrackingController;
    private final boolean enableMonitors;
    private final boolean useJavaCCParser;
    private final boolean disallowSplittingTop;
    private final boolean enablePlanningRelationshipIndexes;
    private boolean _obfuscateLiterals;

    public static StatsDivergenceCalculatorConfig statsDivergenceFromConfig(Config config) {
        return CypherConfiguration$.MODULE$.statsDivergenceFromConfig(config);
    }

    public static CypherConfiguration fromConfig(Config config) {
        return CypherConfiguration$.MODULE$.fromConfig(config);
    }

    public Config config() {
        return this.config;
    }

    public CypherVersion version() {
        return this.version;
    }

    public CypherPlannerOption planner() {
        return this.planner;
    }

    public CypherRuntimeOption runtime() {
        return this.runtime;
    }

    public int queryCacheSize() {
        return this.queryCacheSize;
    }

    public StatsDivergenceCalculatorConfig statsDivergenceCalculator() {
        return this.statsDivergenceCalculator;
    }

    public boolean useErrorsOverWarnings() {
        return this.useErrorsOverWarnings;
    }

    public int idpMaxTableSize() {
        return this.idpMaxTableSize;
    }

    public long idpIterationDuration() {
        return this.idpIterationDuration;
    }

    public boolean errorIfShortestPathFallbackUsedAtRuntime() {
        return this.errorIfShortestPathFallbackUsedAtRuntime;
    }

    public boolean errorIfShortestPathHasCommonNodesAtRuntime() {
        return this.errorIfShortestPathHasCommonNodesAtRuntime;
    }

    public boolean legacyCsvQuoteEscaping() {
        return this.legacyCsvQuoteEscaping;
    }

    public int csvBufferSize() {
        return this.csvBufferSize;
    }

    public CypherExpressionEngineOption expressionEngineOption() {
        return this.expressionEngineOption;
    }

    public boolean lenientCreateRelationship() {
        return this.lenientCreateRelationship;
    }

    public int pipelinedBatchSizeSmall() {
        return this.pipelinedBatchSizeSmall;
    }

    public int pipelinedBatchSizeBig() {
        return this.pipelinedBatchSizeBig;
    }

    public boolean doSchedulerTracing() {
        return this.doSchedulerTracing;
    }

    public File schedulerTracingFile() {
        return this.schedulerTracingFile;
    }

    public int recompilationLimit() {
        return this.recompilationLimit;
    }

    public CypherOperatorEngineOption operatorEngine() {
        return this.operatorEngine;
    }

    public CypherInterpretedPipesFallbackOption interpretedPipesFallback() {
        return this.interpretedPipesFallback;
    }

    public int operatorFusionOverPipelineLimit() {
        return this.operatorFusionOverPipelineLimit;
    }

    public MemoryTrackingController memoryTrackingController() {
        return this.memoryTrackingController;
    }

    public boolean enableMonitors() {
        return this.enableMonitors;
    }

    public boolean useJavaCCParser() {
        return this.useJavaCCParser;
    }

    public boolean disallowSplittingTop() {
        return this.disallowSplittingTop;
    }

    public boolean enablePlanningRelationshipIndexes() {
        return this.enablePlanningRelationshipIndexes;
    }

    private boolean _obfuscateLiterals() {
        return this._obfuscateLiterals;
    }

    private void _obfuscateLiterals_$eq(boolean x$1) {
        this._obfuscateLiterals = x$1;
    }

    public boolean obfuscateLiterals() {
        return this._obfuscateLiterals();
    }

    public CypherConfiguration(Config config) {
        this.config = config;
        this.version = (CypherVersion)CypherVersion$.MODULE$.fromConfig(config);
        this.planner = (CypherPlannerOption)CypherPlannerOption$.MODULE$.fromConfig(config);
        this.runtime = (CypherRuntimeOption)CypherRuntimeOption$.MODULE$.fromConfig(config);
        this.queryCacheSize = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseSettings.query_cache_size));
        this.statsDivergenceCalculator = CypherConfiguration$.MODULE$.statsDivergenceFromConfig(config);
        this.useErrorsOverWarnings = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.cypher_hints_error));
        this.idpMaxTableSize = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold));
        this.idpIterationDuration = Predef$.MODULE$.Long2long((Long)config.get(GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold));
        this.errorIfShortestPathFallbackUsedAtRuntime = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.forbid_exhaustive_shortestpath));
        this.errorIfShortestPathHasCommonNodesAtRuntime = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.forbid_shortestpath_common_nodes));
        this.legacyCsvQuoteEscaping = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.csv_legacy_quote_escaping));
        this.csvBufferSize = ((Long)config.get(GraphDatabaseSettings.csv_buffer_size)).intValue();
        this.expressionEngineOption = (CypherExpressionEngineOption)CypherExpressionEngineOption$.MODULE$.fromConfig(config);
        this.lenientCreateRelationship = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.cypher_lenient_create_relationship));
        this.pipelinedBatchSizeSmall = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_pipelined_batch_size_small));
        this.pipelinedBatchSizeBig = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_pipelined_batch_size_big));
        this.doSchedulerTracing = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseInternalSettings.enable_pipelined_runtime_trace));
        this.schedulerTracingFile = ((Path)config.get(GraphDatabaseInternalSettings.pipelined_scheduler_trace_filename)).toFile();
        this.recompilationLimit = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_expression_recompilation_limit));
        this.operatorEngine = (CypherOperatorEngineOption)CypherOperatorEngineOption$.MODULE$.fromConfig(config);
        this.interpretedPipesFallback = (CypherInterpretedPipesFallbackOption)CypherInterpretedPipesFallbackOption$.MODULE$.fromConfig(config);
        this.operatorFusionOverPipelineLimit = (Integer)config.get(GraphDatabaseInternalSettings.cypher_pipelined_operator_fusion_over_pipeline_limit);
        this.memoryTrackingController = new ConfigMemoryTrackingController(config);
        this.enableMonitors = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseInternalSettings.cypher_enable_runtime_monitors));
        Object object = config.get(GraphDatabaseInternalSettings.cypher_parser);
        GraphDatabaseInternalSettings.CypherParser cypherParser = GraphDatabaseInternalSettings.CypherParser.PARBOILED;
        this.useJavaCCParser = object == null ? cypherParser != null : !object.equals(cypherParser);
        Object object2 = config.get(GraphDatabaseInternalSettings.cypher_splitting_top_behavior);
        GraphDatabaseInternalSettings.SplittingTopBehavior splittingTopBehavior = GraphDatabaseInternalSettings.SplittingTopBehavior.DISALLOW;
        this.disallowSplittingTop = !(object2 != null ? !object2.equals(splittingTopBehavior) : splittingTopBehavior != null);
        this.enablePlanningRelationshipIndexes = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseInternalSettings.cypher_enable_planning_relationship_indexes));
        this._obfuscateLiterals = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.log_queries_obfuscate_literals));
        config.addListener(GraphDatabaseSettings.log_queries_obfuscate_literals, (x$1, newValue) -> this._obfuscateLiterals_$eq(Predef$.MODULE$.Boolean2boolean(newValue)));
    }
}

