/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.CharBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Extractors {
    private final Map<String, Extractor<?>> instances = new HashMap();
    private final StringExtractor string;
    private final LongExtractor long_;
    private final IntExtractor int_;
    private final CharExtractor char_;
    private final ShortExtractor short_;
    private final ByteExtractor byte_;
    private final BooleanExtractor boolean_;
    private final FloatExtractor float_;
    private final DoubleExtractor double_;
    private final StringArrayExtractor stringArray;
    private final BooleanArrayExtractor booleanArray;
    private final ByteArrayExtractor byteArray;
    private final ShortArrayExtractor shortArray;
    private final IntArrayExtractor intArray;
    private final LongArrayExtractor longArray;
    private final FloatArrayExtractor floatArray;
    private final DoubleArrayExtractor doubleArray;
    private final PointExtractor point;
    private final PointArrayExtractor pointArray;
    private final DateExtractor date;
    private final DateArrayExtractor dateArray;
    private final TimeExtractor time;
    private final TimeArrayExtractor timeArray;
    private final DateTimeExtractor dateTime;
    private final DateTimeArrayExtractor dateTimeArray;
    private final LocalTimeExtractor localTime;
    private final LocalTimeArrayExtractor localTimeArray;
    private final LocalDateTimeExtractor localDateTime;
    private final LocalDateTimeArrayExtractor localDateTimeArray;
    private final DurationExtractor duration;
    private final TextValueExtractor textValue;
    private final DurationArrayExtractor durationArray;
    private static final char[] BOOLEAN_MATCH = new char[Boolean.TRUE.toString().length()];
    private static final Supplier<ZoneId> inUTC;
    private static final char[] BOOLEAN_TRUE_CHARACTERS;

    public Extractors() {
        this(';');
    }

    public Extractors(char arrayDelimiter) {
        this(arrayDelimiter, Configuration.COMMAS.emptyQuotedStringsAsNull(), Configuration.COMMAS.trimStrings(), inUTC);
    }

    public Extractors(char arrayDelimiter, boolean emptyStringsAsNull) {
        this(arrayDelimiter, emptyStringsAsNull, Configuration.COMMAS.trimStrings(), inUTC);
    }

    public Extractors(char arrayDelimiter, boolean emptyStringsAsNull, boolean trimStrings) {
        this(arrayDelimiter, emptyStringsAsNull, trimStrings, inUTC);
    }

    public Extractors(char arrayDelimiter, boolean emptyStringsAsNull, boolean trimStrings, Supplier<ZoneId> defaultTimeZone) {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                Object value;
                if (!Modifier.isStatic(field.getModifiers()) || !((value = field.get(null)) instanceof Extractor)) continue;
                this.instances.put(field.getName(), (Extractor)value);
            }
            this.string = new StringExtractor(emptyStringsAsNull);
            this.add(this.string);
            this.long_ = new LongExtractor();
            this.add(this.long_);
            this.int_ = new IntExtractor(this.long_);
            this.add(this.int_);
            this.char_ = new CharExtractor(this.string);
            this.add(this.char_);
            this.short_ = new ShortExtractor(this.long_);
            this.add(this.short_);
            this.byte_ = new ByteExtractor(this.long_);
            this.add(this.byte_);
            this.boolean_ = new BooleanExtractor();
            this.add(this.boolean_);
            this.double_ = new DoubleExtractor();
            this.add(this.double_);
            this.float_ = new FloatExtractor(this.double_);
            this.add(this.float_);
            this.stringArray = new StringArrayExtractor(arrayDelimiter, trimStrings);
            this.add(this.stringArray);
            this.booleanArray = new BooleanArrayExtractor(arrayDelimiter);
            this.add(this.booleanArray);
            this.longArray = new LongArrayExtractor(arrayDelimiter);
            this.add(this.longArray);
            this.byteArray = new ByteArrayExtractor(arrayDelimiter, this.longArray);
            this.add(this.byteArray);
            this.shortArray = new ShortArrayExtractor(arrayDelimiter, this.longArray);
            this.add(this.shortArray);
            this.intArray = new IntArrayExtractor(arrayDelimiter, this.longArray);
            this.add(this.intArray);
            this.doubleArray = new DoubleArrayExtractor(arrayDelimiter);
            this.add(this.doubleArray);
            this.floatArray = new FloatArrayExtractor(arrayDelimiter, this.doubleArray);
            this.add(this.floatArray);
            this.point = new PointExtractor();
            this.add(this.point);
            this.pointArray = new PointArrayExtractor(arrayDelimiter);
            this.add(this.pointArray);
            this.date = new DateExtractor();
            this.add(this.date);
            this.dateArray = new DateArrayExtractor(arrayDelimiter);
            this.add(this.dateArray);
            this.time = new TimeExtractor(defaultTimeZone);
            this.add(this.time);
            this.timeArray = new TimeArrayExtractor(arrayDelimiter, defaultTimeZone);
            this.add(this.timeArray);
            this.dateTime = new DateTimeExtractor(defaultTimeZone);
            this.add(this.dateTime);
            this.dateTimeArray = new DateTimeArrayExtractor(arrayDelimiter, defaultTimeZone);
            this.add(this.dateTimeArray);
            this.localTime = new LocalTimeExtractor();
            this.add(this.localTime);
            this.localTimeArray = new LocalTimeArrayExtractor(arrayDelimiter);
            this.add(this.localTimeArray);
            this.localDateTime = new LocalDateTimeExtractor();
            this.add(this.localDateTime);
            this.localDateTimeArray = new LocalDateTimeArrayExtractor(arrayDelimiter);
            this.add(this.localDateTimeArray);
            this.duration = new DurationExtractor();
            this.add(this.duration);
            this.textValue = new TextValueExtractor(emptyStringsAsNull);
            this.add(this.textValue);
            this.durationArray = new DurationArrayExtractor(arrayDelimiter);
            this.add(this.durationArray);
        }
        catch (IllegalAccessException e) {
            throw new Error("Bug in reflection code gathering all extractors");
        }
    }

    public void add(Extractor<?> extractor) {
        this.instances.put(extractor.name().toUpperCase(Locale.ROOT), extractor);
    }

    public Extractor<?> valueOf(String name) {
        Extractor<?> instance = this.instances.get(name.toUpperCase(Locale.ROOT));
        if (instance == null) {
            throw new IllegalArgumentException("'" + name + "'");
        }
        return instance;
    }

    public Extractor<String> string() {
        return this.string;
    }

    public LongExtractor long_() {
        return this.long_;
    }

    public IntExtractor int_() {
        return this.int_;
    }

    public CharExtractor char_() {
        return this.char_;
    }

    public ShortExtractor short_() {
        return this.short_;
    }

    public ByteExtractor byte_() {
        return this.byte_;
    }

    public BooleanExtractor boolean_() {
        return this.boolean_;
    }

    public FloatExtractor float_() {
        return this.float_;
    }

    public DoubleExtractor double_() {
        return this.double_;
    }

    public Extractor<String[]> stringArray() {
        return this.stringArray;
    }

    public Extractor<boolean[]> booleanArray() {
        return this.booleanArray;
    }

    public Extractor<byte[]> byteArray() {
        return this.byteArray;
    }

    public Extractor<short[]> shortArray() {
        return this.shortArray;
    }

    public Extractor<int[]> intArray() {
        return this.intArray;
    }

    public Extractor<long[]> longArray() {
        return this.longArray;
    }

    public Extractor<float[]> floatArray() {
        return this.floatArray;
    }

    public Extractor<double[]> doubleArray() {
        return this.doubleArray;
    }

    public PointExtractor point() {
        return this.point;
    }

    public PointArrayExtractor pointArray() {
        return this.pointArray;
    }

    public DateExtractor date() {
        return this.date;
    }

    public DateArrayExtractor dateArray() {
        return this.dateArray;
    }

    public TimeExtractor time() {
        return this.time;
    }

    public TimeArrayExtractor timeArray() {
        return this.timeArray;
    }

    public DateTimeExtractor dateTime() {
        return this.dateTime;
    }

    public DateTimeArrayExtractor dateTimeArray() {
        return this.dateTimeArray;
    }

    public LocalTimeExtractor localTime() {
        return this.localTime;
    }

    public LocalTimeArrayExtractor localTimeArray() {
        return this.localTimeArray;
    }

    public LocalDateTimeExtractor localDateTime() {
        return this.localDateTime;
    }

    public LocalDateTimeArrayExtractor localDateTimeArray() {
        return this.localDateTimeArray;
    }

    public DurationExtractor duration() {
        return this.duration;
    }

    public TextValueExtractor textValue() {
        return this.textValue;
    }

    public DurationArrayExtractor durationArray() {
        return this.durationArray;
    }

    private static long extractLong(char[] data, int originalOffset, int fullLength) {
        int length;
        long result = 0L;
        boolean negate = false;
        int offset = originalOffset;
        for (length = fullLength; length > 0 && Character.isWhitespace(data[offset]); --length) {
            ++offset;
        }
        while (length > 0 && Character.isWhitespace(data[offset + length - 1])) {
            --length;
        }
        if (length > 0 && data[offset] == '-') {
            negate = true;
            ++offset;
            --length;
        }
        if (length < 1) {
            throw new NumberFormatException("Not an integer: \"" + String.valueOf(data, originalOffset, fullLength) + "\"");
        }
        try {
            for (int i = 0; i < length; ++i) {
                result = result * 10L + (long)Extractors.digit(data[offset + i]);
            }
        }
        catch (NumberFormatException ignored) {
            throw new NumberFormatException("Not an integer: \"" + String.valueOf(data, originalOffset, fullLength) + "\"");
        }
        return negate ? -result : result;
    }

    private static int digit(char ch) {
        int digit = ch - 48;
        if (digit < 0 || digit > 9) {
            throw new NumberFormatException();
        }
        return digit;
    }

    private static boolean extractBoolean(char[] data, int originalOffset, int fullLength) {
        int length;
        int offset = originalOffset;
        for (length = fullLength; length > 0 && Character.isWhitespace(data[offset]); --length) {
            ++offset;
        }
        while (length > 0 && Character.isWhitespace(data[offset + length - 1])) {
            --length;
        }
        if (length != BOOLEAN_TRUE_CHARACTERS.length) {
            return false;
        }
        for (int i = 0; i < BOOLEAN_TRUE_CHARACTERS.length && i < length; ++i) {
            if (data[offset + i] == BOOLEAN_TRUE_CHARACTERS[i]) continue;
            return false;
        }
        return true;
    }

    static {
        Boolean.TRUE.toString().getChars(0, BOOLEAN_MATCH.length, BOOLEAN_MATCH, 0);
        inUTC = () -> ZoneOffset.UTC;
        BOOLEAN_TRUE_CHARACTERS = new char[Boolean.TRUE.toString().length()];
        Boolean.TRUE.toString().getChars(0, BOOLEAN_TRUE_CHARACTERS.length, BOOLEAN_TRUE_CHARACTERS, 0);
    }

    public static class StringExtractor
    extends AbstractExtractor<String> {
        private final boolean emptyStringsAsNull;

        public StringExtractor(boolean emptyStringsAsNull) {
            super(String.class.getSimpleName());
            this.emptyStringsAsNull = emptyStringsAsNull;
        }

        @Override
        public String extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0 && (!hadQuotes || this.emptyStringsAsNull)) {
                return null;
            }
            return new String(data, offset, length);
        }
    }

    public static class LongExtractor
    extends AbstractExtractor<Long> {
        LongExtractor() {
            super(Long.TYPE.getSimpleName());
        }

        @Override
        public Long extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Long.valueOf(Extractors.extractLong(data, offset, length));
        }
    }

    public static class IntExtractor
    extends AbstractExtractor<Integer> {
        IntExtractor(LongExtractor longExtractor) {
            super(Integer.TYPE.toString(), longExtractor);
        }

        @Override
        public Integer extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Integer.valueOf(Numbers.safeCastLongToInt((long)Extractors.extractLong(data, offset, length)));
        }
    }

    public static class CharExtractor
    extends AbstractExtractor<Character> {
        CharExtractor(StringExtractor stringExtractor) {
            super(Character.TYPE.getSimpleName(), stringExtractor);
        }

        @Override
        public Character extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length > 1) {
                throw new IllegalStateException("Was told to extract a character, but length:" + length);
            }
            return length == 0 ? null : Character.valueOf(data[offset]);
        }
    }

    public static class ShortExtractor
    extends AbstractExtractor<Short> {
        ShortExtractor(LongExtractor longExtractor) {
            super(Short.TYPE.getSimpleName(), longExtractor);
        }

        @Override
        public Short extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Short.valueOf(Numbers.safeCastLongToShort((long)Extractors.extractLong(data, offset, length)));
        }
    }

    public static class ByteExtractor
    extends AbstractExtractor<Byte> {
        ByteExtractor(LongExtractor longExtractor) {
            super(Byte.TYPE.getSimpleName(), longExtractor);
        }

        @Override
        public Byte extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Byte.valueOf(Numbers.safeCastLongToByte((long)Extractors.extractLong(data, offset, length)));
        }
    }

    public static class BooleanExtractor
    extends AbstractExtractor<Boolean> {
        BooleanExtractor() {
            super(Boolean.TYPE.getSimpleName());
        }

        @Override
        public Boolean extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Boolean.valueOf(Extractors.extractBoolean(data, offset, length));
        }
    }

    public static class DoubleExtractor
    extends AbstractExtractor<Double> {
        DoubleExtractor() {
            super(Double.TYPE.getSimpleName());
        }

        @Override
        public Double extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            try {
                return Double.parseDouble(String.valueOf(data, offset, length));
            }
            catch (NumberFormatException ignored) {
                throw new NumberFormatException("Not a number: \"" + String.valueOf(data, offset, length) + "\"");
            }
        }
    }

    public static class FloatExtractor
    extends AbstractExtractor<Float> {
        FloatExtractor(DoubleExtractor doubleExtractor) {
            super(Float.TYPE.getSimpleName(), doubleExtractor);
        }

        @Override
        public Float extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            try {
                return Float.valueOf(Float.parseFloat(String.valueOf(data, offset, length)));
            }
            catch (NumberFormatException ignored) {
                throw new NumberFormatException("Not a number: \"" + String.valueOf(data, offset, length) + "\"");
            }
        }
    }

    private static class StringArrayExtractor
    extends ArrayExtractor<String[]> {
        private final boolean trimStrings;

        StringArrayExtractor(char arrayDelimiter, boolean trimStrings) {
            super(arrayDelimiter, String.class.getSimpleName());
            this.trimStrings = trimStrings;
        }

        @Override
        public String[] extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            String[] value = numberOfValues > 0 ? new String[numberOfValues] : ArrayUtils.EMPTY_STRING_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                value[arrayIndex] = new String(data, offset + charIndex, numberOfChars);
                if (this.trimStrings) {
                    value[arrayIndex] = value[arrayIndex].trim();
                }
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return value;
        }
    }

    private static class BooleanArrayExtractor
    extends ArrayExtractor<boolean[]> {
        BooleanArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Boolean.TYPE.getSimpleName());
        }

        @Override
        public boolean[] extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            boolean[] value = numberOfValues > 0 ? new boolean[numberOfValues] : ArrayUtils.EMPTY_BOOLEAN_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                value[arrayIndex] = Extractors.extractBoolean(data, offset + charIndex, numberOfChars);
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return value;
        }
    }

    private static class LongArrayExtractor
    extends ArrayExtractor<long[]> {
        LongArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Long.TYPE.getSimpleName());
        }

        @Override
        public long[] extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            long[] value = numberOfValues > 0 ? new long[numberOfValues] : ArrayUtils.EMPTY_LONG_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                value[arrayIndex] = Extractors.extractLong(data, offset + charIndex, numberOfChars);
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return value;
        }
    }

    private static class ByteArrayExtractor
    extends ArrayExtractor<byte[]> {
        ByteArrayExtractor(char arrayDelimiter, LongArrayExtractor longArrayExtractor) {
            super(arrayDelimiter, Byte.TYPE.getSimpleName(), longArrayExtractor);
        }

        @Override
        public byte[] extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            byte[] value = numberOfValues > 0 ? new byte[numberOfValues] : ArrayUtils.EMPTY_BYTE_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                value[arrayIndex] = Numbers.safeCastLongToByte((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return value;
        }
    }

    private static class ShortArrayExtractor
    extends ArrayExtractor<short[]> {
        ShortArrayExtractor(char arrayDelimiter, LongArrayExtractor longArrayExtractor) {
            super(arrayDelimiter, Short.TYPE.getSimpleName(), longArrayExtractor);
        }

        @Override
        public short[] extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            short[] value = numberOfValues > 0 ? new short[numberOfValues] : ArrayUtils.EMPTY_SHORT_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                value[arrayIndex] = Numbers.safeCastLongToShort((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return value;
        }
    }

    private static class IntArrayExtractor
    extends ArrayExtractor<int[]> {
        IntArrayExtractor(char arrayDelimiter, LongArrayExtractor longArrayExtractor) {
            super(arrayDelimiter, Integer.TYPE.getSimpleName(), longArrayExtractor);
        }

        @Override
        public int[] extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            int[] value = numberOfValues > 0 ? new int[numberOfValues] : ArrayUtils.EMPTY_INT_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                value[arrayIndex] = Numbers.safeCastLongToInt((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return value;
        }
    }

    private static class DoubleArrayExtractor
    extends ArrayExtractor<double[]> {
        DoubleArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Double.TYPE.getSimpleName());
        }

        @Override
        public double[] extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            double[] value = numberOfValues > 0 ? new double[numberOfValues] : ArrayUtils.EMPTY_DOUBLE_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                value[arrayIndex] = Double.parseDouble(String.valueOf(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return value;
        }
    }

    private static class FloatArrayExtractor
    extends ArrayExtractor<float[]> {
        FloatArrayExtractor(char arrayDelimiter, DoubleArrayExtractor doubleArrayExtractor) {
            super(arrayDelimiter, Float.TYPE.getSimpleName(), doubleArrayExtractor);
        }

        @Override
        public float[] extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            float[] value = numberOfValues > 0 ? new float[numberOfValues] : ArrayUtils.EMPTY_FLOAT_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                value[arrayIndex] = Float.parseFloat(String.valueOf(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return value;
        }
    }

    public static class PointExtractor
    extends AbstractExtractor<PointValue> {
        public static final String NAME = "Point";

        PointExtractor() {
            super(NAME);
        }

        @Override
        public PointValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return PointValue.parse((CharSequence)CharBuffer.wrap(data, offset, length), (CSVHeaderInformation)optionalData);
        }
    }

    public static class PointArrayExtractor
    extends ArrayAnyValueExtractor<PointArray> {
        private static final PointArray EMPTY = Values.pointArray((Point[])new Point[0]);

        PointArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "Point");
        }

        @Override
        public PointArray extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                return EMPTY;
            }
            PointValue[] localValue = new PointValue[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = PointValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars), (CSVHeaderInformation)optionalData);
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return Values.pointArray((PointValue[])localValue);
        }
    }

    public static class DateExtractor
    extends AbstractExtractor<DateValue> {
        public static final String NAME = "Date";

        DateExtractor() {
            super(NAME);
        }

        @Override
        public DateValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return DateValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
        }
    }

    public static class DateArrayExtractor
    extends ArrayAnyValueExtractor<DateArray> {
        private static final DateArray EMPTY = Values.dateArray((LocalDate[])new LocalDate[0]);

        DateArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "Date");
        }

        @Override
        public DateArray extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                return EMPTY;
            }
            LocalDate[] localValue = new LocalDate[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (LocalDate)DateValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars)).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return Values.dateArray((LocalDate[])localValue);
        }
    }

    public static class TimeExtractor
    extends AbstractExtractor<TimeValue> {
        public static final String NAME = "Time";
        private final Supplier<ZoneId> defaultTimeZone;

        TimeExtractor(Supplier<ZoneId> defaultTimeZone) {
            super(NAME);
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        public TimeValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return TimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length), this.defaultTimeZone, (CSVHeaderInformation)optionalData);
        }
    }

    public static class TimeArrayExtractor
    extends ArrayAnyValueExtractor<TimeArray> {
        private static final TimeArray EMPTY = Values.timeArray((OffsetTime[])new OffsetTime[0]);
        private final Supplier<ZoneId> defaultTimeZone;

        TimeArrayExtractor(char arrayDelimiter, Supplier<ZoneId> defaultTimeZone) {
            super(arrayDelimiter, "Time");
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        public TimeArray extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                return EMPTY;
            }
            OffsetTime[] localValue = new OffsetTime[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (OffsetTime)TimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars), this.defaultTimeZone, (CSVHeaderInformation)optionalData).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return Values.timeArray((OffsetTime[])localValue);
        }
    }

    public static class DateTimeExtractor
    extends AbstractExtractor<DateTimeValue> {
        public static final String NAME = "DateTime";
        private final Supplier<ZoneId> defaultTimeZone;

        DateTimeExtractor(Supplier<ZoneId> defaultTimeZone) {
            super(NAME);
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        public DateTimeValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return DateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length), this.defaultTimeZone, (CSVHeaderInformation)optionalData);
        }
    }

    public static class DateTimeArrayExtractor
    extends ArrayAnyValueExtractor<DateTimeArray> {
        private static final DateTimeArray EMPTY = Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[0]);
        private final Supplier<ZoneId> defaultTimeZone;

        DateTimeArrayExtractor(char arrayDelimiter, Supplier<ZoneId> defaultTimeZone) {
            super(arrayDelimiter, "DateTime");
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        public DateTimeArray extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                return EMPTY;
            }
            ZonedDateTime[] localValue = new ZonedDateTime[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (ZonedDateTime)DateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars), this.defaultTimeZone, (CSVHeaderInformation)optionalData).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return Values.dateTimeArray((ZonedDateTime[])localValue);
        }
    }

    public static class LocalTimeExtractor
    extends AbstractExtractor<LocalTimeValue> {
        public static final String NAME = "LocalTime";

        LocalTimeExtractor() {
            super(NAME);
        }

        @Override
        public LocalTimeValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return LocalTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
        }
    }

    public static class LocalTimeArrayExtractor
    extends ArrayAnyValueExtractor<LocalTimeArray> {
        private static final LocalTimeArray EMPTY = Values.localTimeArray((LocalTime[])new LocalTime[0]);

        LocalTimeArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "LocalTime");
        }

        @Override
        public LocalTimeArray extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                return EMPTY;
            }
            LocalTime[] localValue = new LocalTime[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (LocalTime)LocalTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars)).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return Values.localTimeArray((LocalTime[])localValue);
        }
    }

    public static class LocalDateTimeExtractor
    extends AbstractExtractor<LocalDateTimeValue> {
        public static final String NAME = "LocalDateTime";

        LocalDateTimeExtractor() {
            super(NAME);
        }

        @Override
        public LocalDateTimeValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return LocalDateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
        }
    }

    public static class LocalDateTimeArrayExtractor
    extends ArrayAnyValueExtractor<LocalDateTimeArray> {
        private static final LocalDateTimeArray EMPTY = Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[0]);

        LocalDateTimeArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "LocalDateTime");
        }

        @Override
        public LocalDateTimeArray extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                return EMPTY;
            }
            LocalDateTime[] localValue = new LocalDateTime[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (LocalDateTime)LocalDateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars)).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return Values.localDateTimeArray((LocalDateTime[])localValue);
        }
    }

    public static class DurationExtractor
    extends AbstractExtractor<DurationValue> {
        public static final String NAME = "Duration";

        DurationExtractor() {
            super(NAME);
        }

        @Override
        public DurationValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return DurationValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
        }
    }

    public static class TextValueExtractor
    extends AbstractExtractor<Value> {
        public static final String NAME = "TextValue";
        private final boolean emptyStringsAsNull;

        TextValueExtractor(boolean emptyStringsAsNull) {
            super(NAME);
            this.emptyStringsAsNull = emptyStringsAsNull;
        }

        @Override
        public Value extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0 && (!hadQuotes || this.emptyStringsAsNull)) {
                return Values.NO_VALUE;
            }
            return Values.utf8Value((String)new String(data, offset, length));
        }
    }

    public static class DurationArrayExtractor
    extends ArrayAnyValueExtractor<DurationArray> {
        private static final DurationArray EMPTY = Values.durationArray((DurationValue[])new DurationValue[0]);

        DurationArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "Duration");
        }

        @Override
        public DurationArray extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                return EMPTY;
            }
            DurationValue[] localValue = new DurationValue[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = DurationValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return Values.durationArray((DurationValue[])localValue);
        }
    }

    private static abstract class ArrayAnyValueExtractor<T extends ArrayValue>
    extends ArrayExtractor<T> {
        ArrayAnyValueExtractor(char arrayDelimiter, String componentTypeName) {
            super(arrayDelimiter, componentTypeName);
        }

        @Override
        public boolean isEmpty(Object value) {
            return super.isEmpty(value) || ((ArrayValue)value).isEmpty();
        }
    }

    private static abstract class ArrayExtractor<T>
    extends AbstractExtractor<T> {
        protected final char arrayDelimiter;

        ArrayExtractor(char arrayDelimiter, String componentTypeName) {
            this(arrayDelimiter, componentTypeName, null);
        }

        ArrayExtractor(char arrayDelimiter, String componentTypeName, Extractor<?> normalizedExtractor) {
            super(componentTypeName + "[]", normalizedExtractor);
            this.arrayDelimiter = arrayDelimiter;
        }

        protected int charsToNextDelimiter(char[] data, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                if (data[offset + i] != this.arrayDelimiter) continue;
                return i;
            }
            return length;
        }

        protected int numberOfValues(char[] data, int offset, int length) {
            int count = length > 0 ? 1 : 0;
            for (int i = 0; i < length; ++i) {
                if (data[offset + i] != this.arrayDelimiter) continue;
                ++count;
            }
            return count;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }

        @Override
        public boolean isEmpty(Object value) {
            return super.isEmpty(value) || value.getClass().isArray() && Array.getLength(value) == 0;
        }
    }

    private static abstract class AbstractExtractor<T>
    implements Extractor<T> {
        private final String name;
        private final Extractor<?> normalizedExtractor;

        AbstractExtractor(String name) {
            this(name, null);
        }

        AbstractExtractor(String name, Extractor<?> normalizedExtractor) {
            this.name = name;
            this.normalizedExtractor = normalizedExtractor;
        }

        @Override
        public T extract(char[] data, int offset, int length, boolean hadQuotes) {
            return this.extract(data, offset, length, hadQuotes, null);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Extractor<?> normalize() {
            return this.normalizedExtractor != null ? this.normalizedExtractor : this;
        }

        @Override
        public boolean isEmpty(Object value) {
            return value == null || value == Values.NO_VALUE;
        }

        public boolean equals(Object o) {
            return this == o || this.getClass().equals(o.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }
    }
}

