/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.function.LongSupplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Magic;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.csv.reader.WrappedCharReadable;
import org.neo4j.function.IOFunction;
import org.neo4j.function.ThrowingFunction;

public class Readables {
    private Readables() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static CharReadable wrap(InputStream stream, String sourceName, Charset charset) throws IOException {
        return Readables.wrap(stream, sourceName, charset, 0L);
    }

    public static CharReadable wrap(InputStream stream, final String sourceName, Charset charset, long length) throws IOException {
        byte[] bytes = new byte[Magic.longest()];
        PushbackInputStream pushbackStream = new PushbackInputStream(stream, bytes.length);
        Charset usedCharset = charset;
        int read = stream.read(bytes);
        if (read >= 0) {
            bytes = read < bytes.length ? Arrays.copyOf(bytes, read) : bytes;
            Magic magic = Magic.of(bytes);
            int excessiveBytes = read;
            if (magic.impliesEncoding()) {
                excessiveBytes -= magic.length();
                usedCharset = magic.encoding();
            }
            pushbackStream.unread(bytes, read - excessiveBytes, excessiveBytes);
        }
        return Readables.wrap(new InputStreamReader(pushbackStream, usedCharset){

            public String toString() {
                return sourceName;
            }
        }, length);
    }

    public static CharReadable wrap(String sourceDescription, String data) {
        return Readables.wrap(sourceDescription, new StringReader(data), data.length());
    }

    public static CharReadable wrap(String data) {
        return Readables.wrap(new StringReader(data), data.length());
    }

    public static CharReadable wrap(Reader reader, long length) {
        return Readables.wrap(reader.toString(), reader, length);
    }

    public static CharReadable wrap(String sourceDescription, Reader reader, long length) {
        return new WrappedCharReadable(length, reader, sourceDescription);
    }

    private static boolean invalidZipEntry(String name) {
        return name.contains("__MACOSX") || name.startsWith(".") || name.contains("/.");
    }

    public static RawIterator<CharReadable, IOException> individualFiles(Charset charset, Path ... files) {
        return Readables.iterator(new FromFile(charset), files);
    }

    public static CharReadable files(Charset charset, Path ... files) throws IOException {
        FromFile opener = new FromFile(charset);
        switch (files.length) {
            case 0: {
                return CharReadable.EMPTY;
            }
            case 1: {
                return (CharReadable)opener.apply(files[0]);
            }
        }
        return new MultiReadable(Readables.iterator(opener, files));
    }

    @SafeVarargs
    public static <IN, OUT> RawIterator<OUT, IOException> iterator(final ThrowingFunction<IN, OUT, IOException> converter, final IN ... items) {
        if (items.length == 0) {
            throw new IllegalStateException("No source items specified");
        }
        return new RawIterator<OUT, IOException>(){
            private int cursor;

            public boolean hasNext() {
                return this.cursor < items.length;
            }

            public OUT next() throws IOException {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                return converter.apply(items[this.cursor++]);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static char[] extractFirstLineFrom(CharReadable source) throws IOException {
        int read;
        char[] result = new char[100];
        int cursor = 0;
        boolean foundEol = false;
        do {
            if (cursor >= result.length) {
                result = Arrays.copyOf(result, cursor * 2);
            }
            if ((read = source.read(result, cursor, 1)) <= 0 || (foundEol = BufferedCharSeeker.isEolChar(result[cursor]))) continue;
            ++cursor;
        } while (read > 0 && !foundEol);
        return Arrays.copyOf(result, cursor);
    }

    private static class FromFile
    implements IOFunction<Path, CharReadable> {
        private final Charset charset;

        FromFile(Charset charset) {
            this.charset = charset;
        }

        public CharReadable apply(final Path path) throws IOException {
            Magic magic = Magic.of(path);
            if (magic == Magic.ZIP) {
                ZipFile zipFile = new ZipFile(path.toFile());
                ZipEntry entry = FromFile.getSingleSuitableEntry(zipFile);
                return Readables.wrap(new InputStreamReader(zipFile.getInputStream(entry), this.charset){

                    public String toString() {
                        return path.toAbsolutePath().toString();
                    }
                }, entry.getSize());
            }
            if (magic == Magic.GZIP) {
                final LongSupplier[] bytesReadFromCompressedSource = new LongSupplier[1];
                GZIPInputStream zipStream = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])){
                    {
                        super(in);
                        bytesReadFromCompressedSource[0] = this.inf::getBytesRead;
                    }
                };
                InputStreamReader reader = new InputStreamReader(zipStream, this.charset){

                    public String toString() {
                        return path.toAbsolutePath().toString();
                    }
                };
                long compressedFileLength = Files.size(path);
                return new WrappedCharReadable(compressedFileLength, reader, path.toAbsolutePath().toString()){

                    @Override
                    public float compressionRatio() {
                        long decompressedPosition = this.position();
                        long compressedPosition = bytesReadFromCompressedSource[0].getAsLong();
                        return (float)((double)compressedPosition / (double)decompressedPosition);
                    }
                };
            }
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            Charset usedCharset = this.charset;
            if (magic.impliesEncoding()) {
                long skip = in.skip(magic.length());
                if (skip != (long)magic.length()) {
                    throw new IOException("Unable to skip " + magic.length() + " bytes, only able to skip " + skip + " bytes.");
                }
                usedCharset = magic.encoding();
            }
            return Readables.wrap(new InputStreamReader(in, usedCharset){

                public String toString() {
                    return path.toAbsolutePath().toString();
                }
            }, Files.size(path));
        }

        private static ZipEntry getSingleSuitableEntry(ZipFile zipFile) throws IOException {
            ArrayList<String> unsuitableEntries = new ArrayList<String>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ZipEntry found = null;
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                if (entry.isDirectory() || Readables.invalidZipEntry(entry.getName())) {
                    unsuitableEntries.add(entry.getName());
                    continue;
                }
                if (found != null) {
                    throw new IOException("Multiple suitable files found in zip file " + zipFile.getName() + ", at least " + found.getName() + " and " + entry.getName() + ". Only a single file per zip file is supported");
                }
                found = entry;
            }
            if (found == null) {
                throw new IOException("No suitable file found in zip file " + zipFile.getName() + "." + (String)(!unsuitableEntries.isEmpty() ? " Although found these unsuitable entries " + unsuitableEntries : ""));
            }
            return found;
        }
    }
}

