/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.DataAfterQuoteException;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.IllegalMultilineFieldException;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.MissingEndQuoteException;
import org.neo4j.csv.reader.Source;
import org.neo4j.values.AnyValue;

public class BufferedCharSeeker
implements CharSeeker {
    private static final char EOL_CHAR = '\n';
    private static final char EOL_CHAR_2 = '\r';
    private static final char EOF_CHAR = '\uffff';
    private static final char BACK_SLASH = '\\';
    private static final char WHITESPACE = ' ';
    private char[] buffer;
    private int dataLength;
    private int dataCapacity;
    private int bufferPos;
    private int bufferStartPos;
    private int bufferEnd;
    private int lineStartPos;
    private int seekStartPos;
    private int lineNumber;
    private boolean eof;
    private final char quoteChar;
    private long absoluteBufferStartPosition;
    private String sourceDescription;
    private final boolean multilineFields;
    private final boolean legacyStyleQuoting;
    private final Source source;
    private Source.Chunk currentChunk;
    private final boolean trim;

    public BufferedCharSeeker(Source source, Configuration config) {
        this.source = source;
        this.quoteChar = config.quotationCharacter();
        this.lineStartPos = this.bufferPos;
        this.multilineFields = config.multilineFields();
        this.legacyStyleQuoting = config.legacyStyleQuoting();
        this.trim = BufferedCharSeeker.getTrimStringIgnoreErrors(config);
    }

    @Override
    public boolean seek(Mark mark, int untilChar) throws IOException {
        if (this.eof) {
            return this.eof(mark);
        }
        this.seekStartPos = this.bufferPos;
        int endOffset = 1;
        int skippedChars = 0;
        int quoteDepth = 0;
        int quoteStartLine = 0;
        boolean isQuoted = false;
        while (!this.eof) {
            int nextCh;
            int ch = this.nextChar(skippedChars);
            if (quoteDepth == 0) {
                if (this.isWhitespace(ch) && this.trim) {
                    if (this.seekStartPos != this.bufferPos - 1) continue;
                    ++this.seekStartPos;
                    continue;
                }
                if (ch == this.quoteChar && this.seekStartPos == this.bufferPos - 1) {
                    ++quoteDepth;
                    isQuoted = true;
                    ++this.seekStartPos;
                    quoteStartLine = this.lineNumber;
                    continue;
                }
                if (this.isNewLine(ch)) {
                    if (this.bufferPos - 1 != this.lineStartPos) break;
                    ++this.seekStartPos;
                    ++this.lineStartPos;
                    continue;
                }
                if (ch == untilChar) {
                    return this.setMark(mark, endOffset, skippedChars, ch, isQuoted);
                }
                if (!isQuoted) continue;
                throw new DataAfterQuoteException(this, new String(this.buffer, this.seekStartPos, this.bufferPos - this.seekStartPos));
            }
            if (ch == this.quoteChar) {
                nextCh = this.peekChar(skippedChars);
                if (nextCh == this.quoteChar) {
                    this.repositionChar(this.bufferPos++, ++skippedChars);
                    continue;
                }
                ++endOffset;
                --quoteDepth;
                continue;
            }
            if (this.isNewLine(ch)) {
                if (!this.multilineFields) {
                    throw new IllegalMultilineFieldException(this);
                }
                if (ch != 10) continue;
                ++this.lineNumber;
                continue;
            }
            if (ch == 92 && this.legacyStyleQuoting) {
                nextCh = this.peekChar(skippedChars);
                if (nextCh != this.quoteChar && nextCh != 92) continue;
                this.repositionChar(this.bufferPos++, ++skippedChars);
                continue;
            }
            if (!this.eof) continue;
            throw new MissingEndQuoteException(this, quoteStartLine, this.quoteChar);
        }
        int valueLength = this.bufferPos - this.seekStartPos - 1;
        if (this.eof && valueLength == 0 && this.seekStartPos == this.lineStartPos) {
            return this.eof(mark);
        }
        ++this.lineNumber;
        this.lineStartPos = this.bufferPos;
        return this.setMark(mark, endOffset, skippedChars, -1, isQuoted);
    }

    @Override
    public <EXTRACTOR extends Extractor<?>> EXTRACTOR extract(Mark mark, EXTRACTOR extractor) {
        return this.extract(mark, extractor, null);
    }

    private boolean setMark(Mark mark, int endOffset, int skippedChars, int ch, boolean isQuoted) {
        int pos = (this.trim ? this.rtrim(this.bufferPos) : this.bufferPos) - endOffset - skippedChars;
        mark.set(this.seekStartPos, pos, ch, isQuoted);
        return true;
    }

    private int rtrim(int start) {
        int index = start;
        while (this.isWhitespace(this.buffer[index - 1 - 1])) {
            --index;
        }
        return index;
    }

    private boolean isWhitespace(int ch) {
        return ch == 32;
    }

    private void repositionChar(int offset, int stepsBack) {
        this.buffer[offset - stepsBack] = this.buffer[offset];
    }

    private boolean isNewLine(int ch) {
        return ch == 10 || ch == 13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int peekChar(int skippedChars) throws IOException {
        int ch = this.nextChar(skippedChars);
        try {
            int n = ch;
            return n;
        }
        finally {
            if (ch != 65535) {
                --this.bufferPos;
            }
        }
    }

    private boolean eof(Mark mark) {
        mark.set(-1, -1, -1, false);
        return false;
    }

    private static boolean getTrimStringIgnoreErrors(Configuration config) {
        try {
            return config.trimStrings();
        }
        catch (Throwable t) {
            return Configuration.DEFAULT.trimStrings();
        }
    }

    @Override
    public <EXTRACTOR extends Extractor<?>> EXTRACTOR extract(Mark mark, EXTRACTOR extractor, AnyValue[] optionalData) {
        if (!this.tryExtract(mark, extractor, optionalData)) {
            throw new IllegalStateException(extractor + " didn't extract value for " + mark + ". For values which are optional please use tryExtract method instead");
        }
        return extractor;
    }

    @Override
    public boolean tryExtract(Mark mark, Extractor<?> extractor, AnyValue[] optionalData) {
        int from = mark.startPosition();
        int to = mark.position();
        return extractor.extract(this.buffer, from, to - from, mark.isQuoted(), optionalData);
    }

    @Override
    public boolean tryExtract(Mark mark, Extractor<?> extractor) {
        return this.tryExtract(mark, extractor, null);
    }

    private int nextChar(int skippedChars) throws IOException {
        int ch;
        if (this.bufferPos < this.bufferEnd || this.fillBuffer()) {
            ch = this.buffer[this.bufferPos];
        } else {
            ch = 65535;
            this.eof = true;
        }
        if (skippedChars > 0) {
            this.repositionChar(this.bufferPos, skippedChars);
        }
        ++this.bufferPos;
        return ch;
    }

    private boolean fillBuffer() throws IOException {
        boolean first;
        boolean bl = first = this.currentChunk == null;
        if (!first && this.bufferPos - this.seekStartPos >= this.dataCapacity) {
            throw new IllegalStateException("Tried to read a field larger than buffer size " + this.dataLength + ". A common cause of this is that a field has an unterminated quote and so will try to seek until the next quote, which ever line it may be on. This should not happen if multi-line fields are disabled, given that the fields contains no new-line characters. This field started at " + this.sourceDescription() + ":" + this.lineNumber());
        }
        this.absoluteBufferStartPosition += (long)this.dataLength;
        Source.Chunk nextChunk = this.source.nextChunk(first ? -1 : this.seekStartPos);
        if (nextChunk == Source.EMPTY_CHUNK) {
            return false;
        }
        this.buffer = nextChunk.data();
        this.dataLength = nextChunk.length();
        this.dataCapacity = nextChunk.maxFieldSize();
        this.bufferStartPos = this.bufferPos = nextChunk.startPosition();
        this.bufferEnd = this.bufferPos + this.dataLength;
        int shift = this.seekStartPos - nextChunk.backPosition();
        this.seekStartPos = nextChunk.backPosition();
        this.lineStartPos = first ? this.seekStartPos : (this.lineStartPos -= shift);
        String sourceDescriptionAfterRead = nextChunk.sourceDescription();
        if (!sourceDescriptionAfterRead.equals(this.sourceDescription)) {
            this.lineNumber = 0;
            this.sourceDescription = sourceDescriptionAfterRead;
        }
        this.currentChunk = nextChunk;
        return this.dataLength > 0;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public long position() {
        return this.absoluteBufferStartPosition + (long)(this.bufferPos - this.bufferStartPos);
    }

    @Override
    public String sourceDescription() {
        return this.sourceDescription;
    }

    public long lineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        return String.format("%s[source:%s, position:%d, line:%d]", this.getClass().getSimpleName(), this.sourceDescription(), this.position(), this.lineNumber());
    }

    public static boolean isEolChar(char c) {
        return c == '\n' || c == '\r';
    }
}

