/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;

public interface Source
extends Closeable {
    public static final Chunk EMPTY_CHUNK = new Chunk(){

        @Override
        public int startPosition() {
            return 0;
        }

        @Override
        public String sourceDescription() {
            return "EMPTY";
        }

        @Override
        public int maxFieldSize() {
            return 0;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public char[] data() {
            return null;
        }

        @Override
        public int backPosition() {
            return 0;
        }
    };

    public Chunk nextChunk(int var1) throws IOException;

    public static Source singleChunk(final Chunk chunk) {
        return new Source(){
            private boolean returned;

            @Override
            public void close() throws IOException {
            }

            @Override
            public Chunk nextChunk(int seekStartPos) throws IOException {
                if (!this.returned) {
                    this.returned = true;
                    return chunk;
                }
                return EMPTY_CHUNK;
            }
        };
    }

    public static interface Chunk {
        public char[] data();

        public int length();

        public int maxFieldSize();

        public String sourceDescription();

        public int startPosition();

        public int backPosition();
    }
}

