/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.SectionedCharBuffer;

public class MultiReadable
implements CharReadable {
    private final RawIterator<CharReadable, IOException> actual;
    private CharReadable current = CharReadable.EMPTY;
    private boolean requiresNewLine;
    private long previousPosition;

    public MultiReadable(RawIterator<CharReadable, IOException> readers) {
        this.actual = readers;
    }

    @Override
    public void close() throws IOException {
        this.closeCurrent();
    }

    private void closeCurrent() throws IOException {
        if (this.current != null) {
            this.current.close();
        }
    }

    @Override
    public String sourceDescription() {
        return this.current.sourceDescription();
    }

    @Override
    public long lineNumber() {
        return this.current.lineNumber();
    }

    @Override
    public long position() {
        return this.previousPosition + this.current.position();
    }

    private boolean goToNextSource() throws IOException {
        if (this.actual.hasNext()) {
            if (this.current != null) {
                this.previousPosition += this.current.position();
            }
            this.closeCurrent();
            this.current = (CharReadable)this.actual.next();
            return true;
        }
        return false;
    }

    @Override
    public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
        while (true) {
            this.current.read(buffer, from);
            if (buffer.hasAvailable()) {
                this.checkNewLineRequirement(buffer.array(), buffer.front() - 1);
                return buffer;
            }
            if (this.requiresNewLine) {
                buffer.append('\n');
                this.requiresNewLine = false;
                return buffer;
            }
            if (!this.goToNextSource()) break;
            from = buffer.pivot();
        }
        return buffer;
    }

    private void checkNewLineRequirement(char[] array, int lastIndex) {
        char lastChar = array[lastIndex];
        this.requiresNewLine = lastChar != '\n' && lastChar != '\r';
    }

    @Override
    public int read(char[] into, int offset, int length) throws IOException {
        int totalRead = 0;
        while (totalRead < length) {
            int read = this.current.read(into, offset + totalRead, length - totalRead);
            if (read == -1) {
                if (totalRead > 0) {
                    return totalRead;
                }
                if (!this.goToNextSource()) break;
                if (!this.requiresNewLine) continue;
                into[offset + totalRead] = 10;
                ++totalRead;
                this.requiresNewLine = false;
                continue;
            }
            if (read <= 0) continue;
            this.checkNewLineRequirement(into, offset + (totalRead += read) - 1);
        }
        return totalRead;
    }

    @Override
    public long length() {
        return this.current.length();
    }
}

