/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SectionedCharBuffer;

public class MultiReadable
extends CharReadable.Adapter
implements Closeable {
    private final RawIterator<Reader, IOException> actual;
    private Reader current;
    private boolean requiresNewLine;
    private long position;
    private String currentSourceDescription = Readables.EMPTY.sourceDescription();

    public MultiReadable(RawIterator<Reader, IOException> actual) throws IOException {
        this.actual = actual;
        this.goToNextSource();
    }

    private boolean goToNextSource() throws IOException {
        if (this.actual.hasNext()) {
            this.closeCurrent();
            this.current = (Reader)this.actual.next();
            this.currentSourceDescription = this.current.toString();
            return true;
        }
        return false;
    }

    @Override
    public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
        buffer.compact(buffer, from);
        while (this.current != null) {
            buffer.readFrom(this.current);
            if (buffer.hasAvailable()) {
                this.position += (long)buffer.available();
                this.checkNewLineRequirement(buffer.array(), buffer.front() - 1);
                return buffer;
            }
            if (this.requiresNewLine) {
                buffer.append('\n');
                ++this.position;
                this.requiresNewLine = false;
                return buffer;
            }
            if (this.goToNextSource()) continue;
            break;
        }
        return buffer;
    }

    private void checkNewLineRequirement(char[] array, int lastIndex) {
        char lastChar = array[lastIndex];
        this.requiresNewLine = lastChar != '\n' && lastChar != '\r';
    }

    @Override
    public int read(char[] into, int offset, int length) throws IOException {
        int totalRead = 0;
        while (totalRead < length && this.current != null) {
            int read = this.current.read(into, offset + totalRead, length - totalRead);
            if (read == -1) {
                if (this.goToNextSource()) continue;
                break;
            }
            this.checkNewLineRequirement(into, offset + (totalRead += read) - 1);
            return totalRead;
        }
        return totalRead;
    }

    private void closeCurrent() throws IOException {
        if (this.current != null) {
            this.current.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closeCurrent();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public String sourceDescription() {
        return this.currentSourceDescription;
    }
}

