/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

public interface Configuration {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final Configuration DEFAULT = new Default();

    public char quotationCharacter();

    public int bufferSize();

    public boolean multilineFields();

    public boolean trimStrings();

    public boolean emptyQuotedStringsAsNull();

    public static class Overridden
    implements Configuration {
        private final Configuration defaults;

        public Overridden(Configuration defaults) {
            this.defaults = defaults;
        }

        @Override
        public char quotationCharacter() {
            return this.defaults.quotationCharacter();
        }

        @Override
        public int bufferSize() {
            return this.defaults.bufferSize();
        }

        @Override
        public boolean multilineFields() {
            return this.defaults.multilineFields();
        }

        @Override
        public boolean emptyQuotedStringsAsNull() {
            return this.defaults.emptyQuotedStringsAsNull();
        }

        @Override
        public boolean trimStrings() {
            return this.defaults.trimStrings();
        }
    }

    public static class Default
    implements Configuration {
        @Override
        public char quotationCharacter() {
            return '\"';
        }

        @Override
        public int bufferSize() {
            return 0x400000;
        }

        @Override
        public boolean multilineFields() {
            return false;
        }

        @Override
        public boolean emptyQuotedStringsAsNull() {
            return false;
        }

        @Override
        public boolean trimStrings() {
            return false;
        }
    }
}

