/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.neo4j.csv.reader.Magic;
import org.neo4j.io.IOUtils;

public class MagicInputStream
extends InputStream {
    private final Path path;
    private final Magic magic;
    private final InputStream delegate;

    private MagicInputStream(Path path, Magic magic, InputStream delegate) {
        this.path = path;
        this.magic = magic;
        this.delegate = delegate;
    }

    public static MagicInputStream create(Path path) throws IOException {
        InputStream in = null;
        try {
            int read;
            in = Files.newInputStream(path, new OpenOption[0]);
            byte[] bytes = new byte[Magic.longest()];
            if (in.markSupported()) {
                in.mark(bytes.length);
            }
            if ((read = in.read(bytes)) > 0) {
                return MagicInputStream.wrap(path, Magic.of(Arrays.copyOf(bytes, read)), in);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{in});
        return MagicInputStream.wrap(path, Magic.NONE, null);
    }

    public Path path() {
        return this.path;
    }

    public Magic magic() {
        return this.magic;
    }

    public boolean isDefaultFileSystemBased() {
        return this.path.getFileSystem().equals(FileSystems.getDefault());
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.delegate.readAllBytes();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.delegate.readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.delegate.readNBytes(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        this.delegate.skipNBytes(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public void mark(int readLimit) {
        this.delegate.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this.delegate.transferTo(out);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MagicInputStream wrap(Path path, Magic magic, InputStream in) throws IOException {
        MagicInputStream magicInputStream;
        if (in != null && in.markSupported()) {
            in.reset();
            return new MagicInputStream(path, magic, in);
        }
        try {
            magicInputStream = new MagicInputStream(path, magic, Files.newInputStream(path, new OpenOption[0]));
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{in});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{in});
        return magicInputStream;
    }
}

