/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Magic;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.function.IOFunction;
import org.neo4j.function.IOFunctions;
import org.neo4j.function.ThrowingFunction;

public class Readables {
    public static final CharReadable EMPTY = new CharReadable.Adapter(){

        @Override
        public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
            return buffer;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public String sourceDescription() {
            return "EMPTY";
        }
    };

    private Readables() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static CharReadable wrap(final Reader reader) {
        return new CharReadable.Adapter(){
            private long position;
            private final String sourceDescription;
            {
                this.sourceDescription = reader.toString();
            }

            @Override
            public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
                buffer.compact(buffer, from);
                buffer.readFrom(reader);
                this.position += (long)buffer.available();
                return buffer;
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }

            @Override
            public long position() {
                return this.position;
            }

            @Override
            public String sourceDescription() {
                return this.sourceDescription;
            }
        };
    }

    private static boolean invalidZipEntry(String name) {
        return name.contains("__MACOSX") || name.startsWith(".") || name.contains("/.");
    }

    public static CharReadable files(Charset charset, File ... files) throws IOException {
        FromFile opener = new FromFile(charset);
        switch (files.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return Readables.wrap((Reader)opener.apply(files[0]));
            }
        }
        return new MultiReadable(Readables.iterator(files, opener));
    }

    public static CharReadable sources(Reader ... sources) throws IOException {
        return new MultiReadable(Readables.iterator(sources, IOFunctions.identity()));
    }

    public static CharReadable sources(RawIterator<Reader, IOException> sources) throws IOException {
        return new MultiReadable(sources);
    }

    private static <IN, OUT> RawIterator<OUT, IOException> iterator(final IN[] items, final ThrowingFunction<IN, OUT, IOException> converter) {
        if (items.length == 0) {
            throw new IllegalStateException("No source items specified");
        }
        return new RawIterator<OUT, IOException>(){
            private int cursor;

            public boolean hasNext() {
                return this.cursor < items.length;
            }

            public OUT next() throws IOException {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                return converter.apply(items[this.cursor++]);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class FromFile
    implements IOFunction<File, Reader> {
        private final Charset charset;

        FromFile(Charset charset) {
            this.charset = charset;
        }

        public Reader apply(final File file) throws IOException {
            Magic magic = Magic.of(file);
            if (magic == Magic.ZIP) {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry entry = this.getSingleSuitableEntry(zipFile);
                return new InputStreamReader(zipFile.getInputStream(entry), this.charset){

                    public String toString() {
                        return file.getPath();
                    }
                };
            }
            if (magic == Magic.GZIP) {
                GZIPInputStream zipStream = new GZIPInputStream(new FileInputStream(file));
                return new InputStreamReader(zipStream, this.charset){

                    public String toString() {
                        return file.getPath();
                    }
                };
            }
            FileInputStream in = new FileInputStream(file);
            Charset usedCharset = this.charset;
            if (magic.impliesEncoding()) {
                ((InputStream)in).skip(magic.length());
                usedCharset = magic.encoding();
            }
            return new InputStreamReader(in, usedCharset){

                public String toString() {
                    return file.getPath();
                }
            };
        }

        private ZipEntry getSingleSuitableEntry(ZipFile zipFile) throws IOException {
            ArrayList<String> unsuitableEntries = new ArrayList<String>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ZipEntry found = null;
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                if (entry.isDirectory() || Readables.invalidZipEntry(entry.getName())) {
                    unsuitableEntries.add(entry.getName());
                    continue;
                }
                if (found != null) {
                    throw new IOException("Multiple suitable files found in zip file " + zipFile.getName() + ", at least " + found.getName() + " and " + entry.getName() + ". Only a single file per zip file is supported");
                }
                found = entry;
            }
            if (found == null) {
                throw new IOException("No suitable file found in zip file " + zipFile.getName() + "." + (!unsuitableEntries.isEmpty() ? " Although found these unsuitable entries " + unsuitableEntries : ""));
            }
            return found;
        }
    }
}

