/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.SectionedCharBuffer;

public class ThreadAheadReadable
extends Thread
implements CharReadable,
Closeable {
    private static final long PARK_TIME = TimeUnit.MILLISECONDS.toNanos(100L);
    private final CharReadable actual;
    private final Thread owner;
    private SectionedCharBuffer theOtherBuffer;
    private volatile boolean hasReadAhead;
    private volatile boolean closed;
    private volatile boolean eof;
    private volatile IOException ioException;
    private String sourceDescription;
    private String newSourceDescription;

    private ThreadAheadReadable(CharReadable actual, int bufferSize) {
        super(ThreadAheadReadable.class.getSimpleName() + " for " + actual);
        this.actual = actual;
        this.owner = Thread.currentThread();
        this.theOtherBuffer = new SectionedCharBuffer(bufferSize);
        this.sourceDescription = actual.sourceDescription();
        this.setDaemon(true);
        this.start();
    }

    @Override
    public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
        this.assertHealthy();
        while (!this.hasReadAhead) {
            this.parkAWhile();
            this.assertHealthy();
        }
        SectionedCharBuffer resultBuffer = this.theOtherBuffer;
        buffer.compact(resultBuffer, from);
        this.theOtherBuffer = buffer;
        if (this.newSourceDescription != null) {
            this.sourceDescription = this.newSourceDescription;
            this.newSourceDescription = null;
        }
        this.hasReadAhead = false;
        LockSupport.unpark(this);
        return resultBuffer;
    }

    private void assertHealthy() throws IOException {
        if (this.ioException != null) {
            throw new IOException("Error occured in read-ahead thread", this.ioException);
        }
    }

    private void parkAWhile() {
        LockSupport.parkNanos(PARK_TIME);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.actual.close();
        }
    }

    @Override
    public void run() {
        while (!this.closed) {
            if (this.hasReadAhead || this.eof) {
                this.parkAWhile();
                continue;
            }
            try {
                this.theOtherBuffer = this.actual.read(this.theOtherBuffer, this.theOtherBuffer.front());
                String sourceDescriptionAfterRead = this.actual.sourceDescription();
                if (!this.sourceDescription.equals(sourceDescriptionAfterRead)) {
                    this.newSourceDescription = sourceDescriptionAfterRead;
                }
                if (!this.theOtherBuffer.hasAvailable()) {
                    this.eof = true;
                }
                this.hasReadAhead = true;
                LockSupport.unpark(this.owner);
            }
            catch (IOException e) {
                this.ioException = e;
                this.closed = true;
            }
            catch (Throwable e) {
                this.ioException = new IOException(e);
                this.closed = true;
            }
        }
    }

    @Override
    public long position() {
        return this.actual.position();
    }

    @Override
    public String sourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public long lineNumber() {
        return 1L;
    }

    public static CharReadable threadAhead(CharReadable actual, int bufferSize) {
        return new ThreadAheadReadable(actual, bufferSize);
    }
}

