/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.csv.reader.CharReadable;

public class ThreadAheadReadable
extends Thread
implements CharReadable,
Closeable {
    private static final long PARK_TIME = TimeUnit.MILLISECONDS.toNanos(100L);
    private final CharReadable actual;
    private final Thread owner;
    private final char[] readAheadArray;
    private final CharBuffer readAheadBuffer;
    private volatile boolean hasReadAhead;
    private volatile boolean closed;
    private volatile boolean eof;
    private volatile IOException ioException;

    private ThreadAheadReadable(CharReadable actual, int bufferSize) {
        this.actual = actual;
        this.owner = Thread.currentThread();
        this.readAheadArray = new char[bufferSize];
        this.readAheadBuffer = CharBuffer.wrap(this.readAheadArray);
        this.readAheadBuffer.position(bufferSize);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        this.assertHealthy();
        while (!this.hasReadAhead) {
            this.parkAWhile();
            this.assertHealthy();
        }
        if (this.eof) {
            return -1;
        }
        int bytesToCopy = Math.min(this.readAheadBuffer.remaining(), length);
        System.arraycopy(this.readAheadArray, this.readAheadBuffer.position(), buffer, offset, bytesToCopy);
        this.readAheadBuffer.position(this.readAheadBuffer.position() + bytesToCopy);
        this.hasReadAhead = false;
        LockSupport.unpark(this);
        return bytesToCopy == 0 ? -1 : bytesToCopy;
    }

    private void assertHealthy() throws IOException {
        if (this.ioException != null) {
            throw new IOException("Error occured in read-ahead thread", this.ioException);
        }
    }

    private void parkAWhile() {
        LockSupport.parkNanos(PARK_TIME);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.actual.close();
        }
    }

    @Override
    public void run() {
        while (!this.closed) {
            if (this.hasReadAhead || this.eof) {
                this.parkAWhile();
                continue;
            }
            try {
                this.readAheadBuffer.compact();
                int read = this.actual.read(this.readAheadArray, this.readAheadBuffer.position(), this.readAheadBuffer.remaining());
                if (read == -1) {
                    this.eof = true;
                    read = 0;
                }
                this.readAheadBuffer.limit(this.readAheadBuffer.position() + read);
                this.readAheadBuffer.position(0);
                this.hasReadAhead = true;
                LockSupport.unpark(this.owner);
            }
            catch (IOException e) {
                this.ioException = e;
                this.closed = true;
            }
            catch (Throwable e) {
                this.ioException = new IOException(e);
                this.closed = true;
            }
        }
    }

    public static CharReadable threadAhead(CharReadable actual, int bufferSize) {
        return new ThreadAheadReadable(actual, bufferSize);
    }
}

