/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.function.RawFunction;

public class Readables {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int GZIP_MAGIC = 8075;
    public static final CharReadable EMPTY = new CharReadable(){

        @Override
        public int read(char[] buffer, int offset, int length) throws IOException {
            return -1;
        }

        @Override
        public void close() throws IOException {
        }
    };
    private static final RawFunction<File, CharReadable, IOException> FROM_FILE = new RawFunction<File, CharReadable, IOException>(){

        public CharReadable apply(File file) throws IOException {
            int magic = this.magic(file);
            if (magic == 1347093252) {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry entry = this.getSingleSuitableEntry(zipFile);
                return Readables.wrap(new InputStreamReader(zipFile.getInputStream(entry)));
            }
            if (magic >>> 16 == 8075) {
                GZIPInputStream zipStream = new GZIPInputStream(new FileInputStream(file));
                return Readables.wrap(new InputStreamReader(zipStream));
            }
            return Readables.wrap(new FileReader(file));
        }

        private ZipEntry getSingleSuitableEntry(ZipFile zipFile) throws IOException {
            ArrayList<String> unsuitableEntries = new ArrayList<String>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ZipEntry found = null;
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                if (entry.isDirectory() || Readables.invalidZipEntry(entry.getName())) {
                    unsuitableEntries.add(entry.getName());
                    continue;
                }
                if (found != null) {
                    throw new IOException("Multiple suitable files found in zip file " + zipFile.getName() + ", at least " + found.getName() + " and " + entry.getName() + ". Only a single file per zip file is supported");
                }
                found = entry;
            }
            if (found == null) {
                throw new IOException("No suitable file found in zip file " + zipFile.getName() + "." + (!unsuitableEntries.isEmpty() ? " Although found these unsuitable entries " + unsuitableEntries : ""));
            }
            return found;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int magic(File file) throws IOException {
            try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
                int n = in.readInt();
                return n;
            }
            catch (EOFException e) {
                return -1;
            }
        }
    };
    private static final RawFunction<CharReadable, CharReadable, IOException> IDENTITY = new RawFunction<CharReadable, CharReadable, IOException>(){

        public CharReadable apply(CharReadable in) {
            return in;
        }
    };

    private Readables() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static CharReadable wrap(final Reader reader) {
        return new CharReadable(){

            @Override
            public int read(char[] buffer, int offset, int length) throws IOException {
                return reader.read(buffer, offset, length);
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }
        };
    }

    private static boolean invalidZipEntry(String name) {
        return name.contains("__MACOSX") || name.startsWith(".") || name.contains("/.");
    }

    public static CharReadable file(File file) throws IOException {
        return (CharReadable)FROM_FILE.apply((Object)file);
    }

    public static CharReadable multipleFiles(File ... files) {
        return new MultiReadable(Readables.iterator(files, FROM_FILE));
    }

    public static CharReadable multipleSources(CharReadable ... sources) {
        return new MultiReadable(Readables.iterator(sources, IDENTITY));
    }

    public static CharReadable multipleFiles(Iterator<File> files) {
        return new MultiReadable(Readables.iterator(files, FROM_FILE));
    }

    public static CharReadable multipleSources(RawIterator<CharReadable, IOException> sources) {
        return new MultiReadable(sources);
    }

    private static <IN, OUT> RawIterator<OUT, IOException> iterator(final Iterator<IN> items, final RawFunction<IN, OUT, IOException> converter) {
        return new RawIterator<OUT, IOException>(){

            public boolean hasNext() {
                return items.hasNext();
            }

            public OUT next() throws IOException {
                return converter.apply(items.next());
            }

            public void remove() {
                items.remove();
            }
        };
    }

    private static <IN, OUT> RawIterator<OUT, IOException> iterator(final IN[] items, final RawFunction<IN, OUT, IOException> converter) {
        if (items.length == 0) {
            throw new IllegalStateException("No source items specified");
        }
        return new RawIterator<OUT, IOException>(){
            private int cursor;

            public boolean hasNext() {
                return this.cursor < items.length;
            }

            public OUT next() throws IOException {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                return converter.apply(items[this.cursor++]);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

