/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Readables;

public class MultiReadable
implements CharReadable,
Closeable {
    private final RawIterator<CharReadable, IOException> actual;
    private CharReadable current = Readables.EMPTY;
    private int readFromCurrent;

    public MultiReadable(RawIterator<CharReadable, IOException> actual) {
        this.actual = actual;
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        int read = 0;
        while (read < length) {
            int readThisTime = this.current.read(buffer, offset + read, length - read);
            if (readThisTime == -1) {
                if (!this.actual.hasNext()) break;
                this.closeCurrent();
                this.current = (CharReadable)this.actual.next();
                if (this.readFromCurrent <= 0) continue;
                buffer[offset + read++] = 10;
                this.readFromCurrent = 0;
                continue;
            }
            read += readThisTime;
            this.readFromCurrent += readThisTime;
        }
        return read == 0 ? -1 : read;
    }

    private void closeCurrent() throws IOException {
        this.current.close();
    }

    @Override
    public void close() throws IOException {
        this.closeCurrent();
    }
}

