/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.neo4j.consistency.checker.Checker;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.checker.RelationshipGroupLink;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

class RelationshipGroupChecker
implements Checker {
    private static final String RELATIONSHIP_GROUPS_CHECKER_TAG = "relationshipGroupsChecker";
    private final NeoStores neoStores;
    private final ConsistencyReport.Reporter reporter;
    private final CheckerContext context;
    private final ProgressListener progress;

    RelationshipGroupChecker(CheckerContext context) {
        this.neoStores = context.neoStores;
        this.reporter = context.reporter;
        this.context = context;
        this.progress = context.progressReporter(this, "Relationship groups", this.neoStores.getRelationshipGroupStore().getHighId());
    }

    @Override
    public void check(LongRange nodeIdRange, boolean firstRange, boolean lastRange) throws Exception {
        ParallelExecution execution = this.context.execution;
        this.checkToOwner(nodeIdRange, this.context.pageCacheTracer);
        if (firstRange) {
            execution.run(this.getClass().getSimpleName(), execution.partition((RecordStore<?>)this.neoStores.getRelationshipGroupStore(), (from, to, last) -> () -> this.checkToRelationship(from, to, this.context.pageCacheTracer)));
        }
    }

    @Override
    public boolean shouldBeChecked(ConsistencyFlags flags) {
        return flags.isCheckGraph();
    }

    private void checkToOwner(LongRange nodeIdRange, PageCacheTracer pageCacheTracer) {
        ProgressListener localProgress = this.progress.threadLocalReporter();
        RelationshipGroupStore groupStore = this.neoStores.getRelationshipGroupStore();
        CacheAccess.Client client = this.context.cacheAccess.client();
        long highId = groupStore.getHighId();
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(RELATIONSHIP_GROUPS_CHECKER_TAG));
             RecordReader groupReader = new RecordReader(this.neoStores.getRelationshipGroupStore(), true, cursorContext);){
            for (long id = 0L; id < highId && !this.context.isCancelled(); ++id) {
                long owningNode;
                localProgress.add(1L);
                RelationshipGroupRecord record = (RelationshipGroupRecord)groupReader.read(id);
                if (!record.inUse() || !nodeIdRange.isWithinRangeExclusiveTo(owningNode = record.getOwningNode())) continue;
                long cachedOwnerNextRel = client.getFromCache(owningNode, 0);
                boolean nodeIsInUse = client.getBooleanFromCache(owningNode, 2);
                if (!nodeIsInUse) {
                    this.reporter.forRelationshipGroup(record).ownerNotInUse();
                } else if (cachedOwnerNextRel == id) {
                    client.putToCacheSingle(owningNode, 5, 0L);
                }
                if (!Record.NULL_REFERENCE.is(record.getNext())) continue;
                boolean hasAlreadySeenLastGroup = client.getBooleanFromCache(owningNode, 7);
                if (hasAlreadySeenLastGroup) {
                    this.reporter.forRelationshipGroup(record).multipleLastGroups(this.context.recordLoader.node(owningNode, cursorContext));
                }
                client.putToCacheSingle(owningNode, 7, 1L);
            }
        }
        localProgress.done();
    }

    private void checkToRelationship(long fromGroupId, long toGroupId, PageCacheTracer pageCacheTracer) {
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(RELATIONSHIP_GROUPS_CHECKER_TAG));
             RecordReader groupReader = new RecordReader(this.neoStores.getRelationshipGroupStore(), true, cursorContext);
             RecordReader comparativeReader = new RecordReader(this.neoStores.getRelationshipGroupStore(), false, cursorContext);
             RecordStorageReader reader = new RecordStorageReader(this.neoStores);
             RecordRelationshipScanCursor relationshipCursor = reader.allocateRelationshipScanCursor(cursorContext);){
            for (long id = fromGroupId; id < toGroupId && !this.context.isCancelled(); ++id) {
                RelationshipGroupRecord record = (RelationshipGroupRecord)groupReader.read(id);
                if (!record.inUse()) continue;
                long owningNode = record.getOwningNode();
                if (owningNode < 0L) {
                    this.reporter.forRelationshipGroup(record).illegalOwner();
                }
                RecordLoading.checkValidToken(record, record.getType(), this.context.tokenHolders.relationshipTypeTokens(), this.neoStores.getRelationshipTypeTokenStore(), (group, token) -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).illegalRelationshipType(), (group, token) -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).relationshipTypeNotInUse((RelationshipTypeTokenRecord)token), cursorContext);
                if (!Record.NULL_REFERENCE.is(record.getNext())) {
                    RelationshipGroupRecord comparativeRecord = (RelationshipGroupRecord)comparativeReader.read(record.getNext());
                    if (!comparativeRecord.inUse()) {
                        this.reporter.forRelationshipGroup(record).nextGroupNotInUse();
                    } else {
                        if (record.getType() >= comparativeRecord.getType()) {
                            this.reporter.forRelationshipGroup(record).invalidTypeSortOrder();
                        }
                        if (owningNode != comparativeRecord.getOwningNode()) {
                            this.reporter.forRelationshipGroup(record).nextHasOtherOwner(comparativeRecord);
                        }
                    }
                }
                this.checkRelationshipGroupRelationshipLink(relationshipCursor, record, record.getFirstOut(), RelationshipGroupLink.OUT, group -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstOutgoingRelationshipNotInUse(), group -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstOutgoingRelationshipNotFirstInChain(), group -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstOutgoingRelationshipOfOtherType(), (group, rel) -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstOutgoingRelationshipDoesNotShareNodeWithGroup((RelationshipRecord)rel), cursorContext);
                this.checkRelationshipGroupRelationshipLink(relationshipCursor, record, record.getFirstIn(), RelationshipGroupLink.IN, group -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstIncomingRelationshipNotInUse(), group -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstIncomingRelationshipNotFirstInChain(), group -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstIncomingRelationshipOfOtherType(), (group, rel) -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstIncomingRelationshipDoesNotShareNodeWithGroup((RelationshipRecord)rel), cursorContext);
                this.checkRelationshipGroupRelationshipLink(relationshipCursor, record, record.getFirstLoop(), RelationshipGroupLink.LOOP, group -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstLoopRelationshipNotInUse(), group -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstLoopRelationshipNotFirstInChain(), group -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstLoopRelationshipOfOtherType(), (group, rel) -> this.reporter.forRelationshipGroup((RelationshipGroupRecord)group).firstLoopRelationshipDoesNotShareNodeWithGroup((RelationshipRecord)rel), cursorContext);
            }
        }
    }

    private void checkRelationshipGroupRelationshipLink(RecordRelationshipScanCursor relationshipCursor, RelationshipGroupRecord record, long relationshipId, RelationshipGroupLink relationshipGroupLink, Consumer<RelationshipGroupRecord> reportRelationshipNotInUse, Consumer<RelationshipGroupRecord> reportRelationshipNotFirstInChain, Consumer<RelationshipGroupRecord> reportRelationshipOfOtherType, BiConsumer<RelationshipGroupRecord, RelationshipRecord> reportNodeNotSharedWithGroup, CursorContext cursorContext) {
        if (!Record.NULL_REFERENCE.is(relationshipId)) {
            relationshipCursor.single(relationshipId);
            if (!relationshipCursor.next()) {
                reportRelationshipNotInUse.accept(record);
            } else {
                boolean hasCorrectNode;
                if (!relationshipGroupLink.isFirstInChain((RelationshipRecord)relationshipCursor)) {
                    reportRelationshipNotFirstInChain.accept(record);
                }
                if (relationshipCursor.getType() != record.getType()) {
                    reportRelationshipOfOtherType.accept(record);
                }
                boolean bl = hasCorrectNode = relationshipCursor.getFirstNode() == record.getOwningNode() || relationshipCursor.getSecondNode() == record.getOwningNode();
                if (!hasCorrectNode) {
                    reportNodeNotSharedWithGroup.accept(record, this.context.recordLoader.relationship(relationshipCursor.getId(), cursorContext));
                }
            }
        }
    }

    public String toString() {
        return String.format("%s[highId:%d]", this.getClass().getSimpleName(), this.neoStores.getRelationshipGroupStore().getHighId());
    }
}

